/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.naturezaoperacao.EnumConstNatOpSugVlrNFCe;
import com.touchcomp.basementor.constants.enums.naturezaoperacao.EnumConstNatOpSugVlrNFe;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FinalidadeEmNFe;
import com.touchcomp.basementor.model.vo.FinalidadeEmNFeTipo;
import com.touchcomp.basementor.model.vo.GrupoNatOperacaoRelNat;
import com.touchcomp.basementor.model.vo.ModeloDocFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacaoEmpresa;
import com.touchcomp.basementor.model.vo.TipoMovimento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="NATUREZA_OPERACAO", uniqueConstraints={@UniqueConstraint(name="UNQ1_NATUREZA_OPERACAO", columnNames={"DESCRICAO"})})
public class NaturezaOperacao
implements InterfaceVO {
    @Id
    @Column(nullable=false, name="ID_NATUREZA_OPERACAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_NATUREZA_OPERACAO")
    private Long identificador;
    @Column(nullable=false, unique=true, name="DESCRICAO", length=60)
    private String descricao;
    @Column(nullable=false, name="ATIVO")
    private Short ativo = 1;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_NATUREZA_OPERACAO_EMPRESA"))
    private Empresa empresa;
    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    private Date dataCadastro;
    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    private Timestamp dataAtualizacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_DOC_FISCAL", foreignKey=@ForeignKey(name="FK_NATUREZA_OPERACAO_MOD_DOC_FI"))
    private ModeloDocFiscal modeloDocFiscal;
    @Column(nullable=false, name="ENTRADA_SAIDA")
    private Short entradaSaida = 0;
    @Column(nullable=false, name="TIPO_ESTOQUE")
    private Short tipoEstoque = 0;
    @Column(name="PERMITIR_INF_SERIE_NOTA")
    private Short permitirInfSerieNota = 0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_MOVIMENTO", foreignKey=@ForeignKey(name="FK_NATUREZA_OPERACAO_TIPO_MOV"))
    private TipoMovimento tipoMovimento;
    @Column(name="NUMERO_DIAS")
    private Long numDiasVencimento = 0L;
    @Column(name="TIPO_BONUS_REP")
    private Short tipoBonusRep = 0;
    @Column(name="GERAR_COMISSAO_REP")
    private Short gerarComissaoRep = 0;
    @Column(name="TIPO_LANC_CAMP_VENDAS")
    private Short tipoLancCampVendas = 0;
    @Column(name="NAT_OPERACAO_DISP_MOBILE")
    private Short natOperacaoDispMobile = 0;
    @OneToMany(mappedBy="naturezaOperacao")
    private List<GrupoNatOperacaoRelNat> grupoNaturezasRel;
    @Column(nullable=false, name="DESCRICAO_AUXILIAR", length=120)
    private String descricaoAuxiliar;
    @OneToMany(mappedBy="naturezaOperacao", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<NaturezaOperacaoEmpresa> empresas;
    @Column(name="NAT_OP_DISP_PED_ALMOX")
    private Short natOperacaoDispPedAlmox = 0;
    @Column(name="NAT_OP_DISP_NEC_COMPRA")
    private Short natOperacaoDispNecCompra = 0;
    @Column(name="NAT_OPERACAO_DISP_NFCE")
    private Short natOperacaoDispNFCe = 0;
    @Column(name="contabilizar_por_integracao")
    private Short contabilizarPorIntegracao = 0;
    @Column(name="NAT_OPERACAO_DEVOLUCAO")
    private Short natOperacaoDevolucao = 0;
    @Column(name="SUG_VALOR_UNITARIO_FAT_NFE")
    private Short sugValorUnitarioFatNFe = EnumConstNatOpSugVlrNFe.VALOR_NAO_SUGERIR.getValue();
    @Column(name="SUG_VALOR_UNITARIO_FAT_NFCE")
    private Short sugValorUnitarioFatNFCe = EnumConstNatOpSugVlrNFCe.VALOR_VENDA_TAB_PRECO.getValue();
    @Column(name="GERAR_OC_AUT_GERAR_REQ")
    private Short gerarOCAutGerarReq = 0;
    @Column(name="nao_valid_chave_acesso")
    private Short naoValidarChaveDeAcesso;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FINALIDADE_EM_NFE")
    private FinalidadeEmNFe finalidadeEmNFe;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FINALIDADE_EM_NFE_TIPO")
    private FinalidadeEmNFeTipo finalidadeEmNFeTipo;

    public NaturezaOperacao() {
        this.grupoNaturezasRel = new ArrayList<GrupoNatOperacaoRelNat>();
        this.empresas = new ArrayList<NaturezaOperacaoEmpresa>();
        this.setNaoValidarChaveDeAcesso(EnumConstantsMentorSimNao.SIM.getValue());
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricaoAuxiliar()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Transient
    public short getEntradaSaidaNatOperacao() {
        if (this.getEntradaSaida() == 0 || this.getEntradaSaida() == 2) {
            return 0;
        }
        return 1;
    }

    @lombok.Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @lombok.Generated
    public String getDescricao() {
        return this.descricao;
    }

    @lombok.Generated
    public Short getAtivo() {
        return this.ativo;
    }

    @lombok.Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @lombok.Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @lombok.Generated
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @lombok.Generated
    public ModeloDocFiscal getModeloDocFiscal() {
        return this.modeloDocFiscal;
    }

    @lombok.Generated
    public Short getEntradaSaida() {
        return this.entradaSaida;
    }

    @lombok.Generated
    public Short getTipoEstoque() {
        return this.tipoEstoque;
    }

    @lombok.Generated
    public Short getPermitirInfSerieNota() {
        return this.permitirInfSerieNota;
    }

    @lombok.Generated
    public TipoMovimento getTipoMovimento() {
        return this.tipoMovimento;
    }

    @lombok.Generated
    public Long getNumDiasVencimento() {
        return this.numDiasVencimento;
    }

    @lombok.Generated
    public Short getTipoBonusRep() {
        return this.tipoBonusRep;
    }

    @lombok.Generated
    public Short getGerarComissaoRep() {
        return this.gerarComissaoRep;
    }

    @lombok.Generated
    public Short getTipoLancCampVendas() {
        return this.tipoLancCampVendas;
    }

    @lombok.Generated
    public Short getNatOperacaoDispMobile() {
        return this.natOperacaoDispMobile;
    }

    @lombok.Generated
    public List<GrupoNatOperacaoRelNat> getGrupoNaturezasRel() {
        return this.grupoNaturezasRel;
    }

    @lombok.Generated
    public String getDescricaoAuxiliar() {
        return this.descricaoAuxiliar;
    }

    @lombok.Generated
    public List<NaturezaOperacaoEmpresa> getEmpresas() {
        return this.empresas;
    }

    @lombok.Generated
    public Short getNatOperacaoDispPedAlmox() {
        return this.natOperacaoDispPedAlmox;
    }

    @lombok.Generated
    public Short getNatOperacaoDispNecCompra() {
        return this.natOperacaoDispNecCompra;
    }

    @lombok.Generated
    public Short getNatOperacaoDispNFCe() {
        return this.natOperacaoDispNFCe;
    }

    @lombok.Generated
    public Short getContabilizarPorIntegracao() {
        return this.contabilizarPorIntegracao;
    }

    @lombok.Generated
    public Short getNatOperacaoDevolucao() {
        return this.natOperacaoDevolucao;
    }

    @lombok.Generated
    public Short getSugValorUnitarioFatNFe() {
        return this.sugValorUnitarioFatNFe;
    }

    @lombok.Generated
    public Short getSugValorUnitarioFatNFCe() {
        return this.sugValorUnitarioFatNFCe;
    }

    @lombok.Generated
    public Short getGerarOCAutGerarReq() {
        return this.gerarOCAutGerarReq;
    }

    @lombok.Generated
    public Short getNaoValidarChaveDeAcesso() {
        return this.naoValidarChaveDeAcesso;
    }

    @lombok.Generated
    public FinalidadeEmNFe getFinalidadeEmNFe() {
        return this.finalidadeEmNFe;
    }

    @lombok.Generated
    public FinalidadeEmNFeTipo getFinalidadeEmNFeTipo() {
        return this.finalidadeEmNFeTipo;
    }

    @lombok.Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @lombok.Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @lombok.Generated
    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @lombok.Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @lombok.Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @lombok.Generated
    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @lombok.Generated
    public void setModeloDocFiscal(ModeloDocFiscal modeloDocFiscal) {
        this.modeloDocFiscal = modeloDocFiscal;
    }

    @lombok.Generated
    public void setEntradaSaida(Short entradaSaida) {
        this.entradaSaida = entradaSaida;
    }

    @lombok.Generated
    public void setTipoEstoque(Short tipoEstoque) {
        this.tipoEstoque = tipoEstoque;
    }

    @lombok.Generated
    public void setPermitirInfSerieNota(Short permitirInfSerieNota) {
        this.permitirInfSerieNota = permitirInfSerieNota;
    }

    @lombok.Generated
    public void setTipoMovimento(TipoMovimento tipoMovimento) {
        this.tipoMovimento = tipoMovimento;
    }

    @lombok.Generated
    public void setNumDiasVencimento(Long numDiasVencimento) {
        this.numDiasVencimento = numDiasVencimento;
    }

    @lombok.Generated
    public void setTipoBonusRep(Short tipoBonusRep) {
        this.tipoBonusRep = tipoBonusRep;
    }

    @lombok.Generated
    public void setGerarComissaoRep(Short gerarComissaoRep) {
        this.gerarComissaoRep = gerarComissaoRep;
    }

    @lombok.Generated
    public void setTipoLancCampVendas(Short tipoLancCampVendas) {
        this.tipoLancCampVendas = tipoLancCampVendas;
    }

    @lombok.Generated
    public void setNatOperacaoDispMobile(Short natOperacaoDispMobile) {
        this.natOperacaoDispMobile = natOperacaoDispMobile;
    }

    @lombok.Generated
    public void setGrupoNaturezasRel(List<GrupoNatOperacaoRelNat> grupoNaturezasRel) {
        this.grupoNaturezasRel = grupoNaturezasRel;
    }

    @lombok.Generated
    public void setDescricaoAuxiliar(String descricaoAuxiliar) {
        this.descricaoAuxiliar = descricaoAuxiliar;
    }

    @lombok.Generated
    public void setEmpresas(List<NaturezaOperacaoEmpresa> empresas) {
        this.empresas = empresas;
    }

    @lombok.Generated
    public void setNatOperacaoDispPedAlmox(Short natOperacaoDispPedAlmox) {
        this.natOperacaoDispPedAlmox = natOperacaoDispPedAlmox;
    }

    @lombok.Generated
    public void setNatOperacaoDispNecCompra(Short natOperacaoDispNecCompra) {
        this.natOperacaoDispNecCompra = natOperacaoDispNecCompra;
    }

    @lombok.Generated
    public void setNatOperacaoDispNFCe(Short natOperacaoDispNFCe) {
        this.natOperacaoDispNFCe = natOperacaoDispNFCe;
    }

    @lombok.Generated
    public void setContabilizarPorIntegracao(Short contabilizarPorIntegracao) {
        this.contabilizarPorIntegracao = contabilizarPorIntegracao;
    }

    @lombok.Generated
    public void setNatOperacaoDevolucao(Short natOperacaoDevolucao) {
        this.natOperacaoDevolucao = natOperacaoDevolucao;
    }

    @lombok.Generated
    public void setSugValorUnitarioFatNFe(Short sugValorUnitarioFatNFe) {
        this.sugValorUnitarioFatNFe = sugValorUnitarioFatNFe;
    }

    @lombok.Generated
    public void setSugValorUnitarioFatNFCe(Short sugValorUnitarioFatNFCe) {
        this.sugValorUnitarioFatNFCe = sugValorUnitarioFatNFCe;
    }

    @lombok.Generated
    public void setGerarOCAutGerarReq(Short gerarOCAutGerarReq) {
        this.gerarOCAutGerarReq = gerarOCAutGerarReq;
    }

    @lombok.Generated
    public void setNaoValidarChaveDeAcesso(Short naoValidarChaveDeAcesso) {
        this.naoValidarChaveDeAcesso = naoValidarChaveDeAcesso;
    }

    @lombok.Generated
    public void setFinalidadeEmNFe(FinalidadeEmNFe finalidadeEmNFe) {
        this.finalidadeEmNFe = finalidadeEmNFe;
    }

    @lombok.Generated
    public void setFinalidadeEmNFeTipo(FinalidadeEmNFeTipo finalidadeEmNFeTipo) {
        this.finalidadeEmNFeTipo = finalidadeEmNFeTipo;
    }
}

