/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AtendPedAlmoxItemGradeNecComp;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.ClassificacaoNecessidadeCompra;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.EmailGrupoNecCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GrupoNecCompra;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ItemNecCompraDetalhes;
import com.touchcomp.basementor.model.vo.LiberacaoNecCompraItem;
import com.touchcomp.basementor.model.vo.MotivoAquisicaoPref;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.SituacaoNecessidadeCompra;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="NECESSIDADE_DE_COMPRA")
public class NecessidadeCompra
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Date dataNecessidade;
    private Timestamp dataAtualizacao;
    private Short tipoGeracao = 0;
    private Short tipoNecessidade = 0;
    private Double quantidadeNecessidade = 0.0;
    private Usuario usuarioSolicitante;
    private Usuario usuarioComprador;
    private Usuario usuarioLiberacao;
    private Empresa empresa;
    private GradeCor gradeCor;
    private CentroCusto centroCusto;
    private ItemCotacaoCompra itemCotacaoCompraGerada;
    private List<AtendPedAlmoxItemGradeNecComp> atendPedAlmoxNecCompra = new ArrayList<AtendPedAlmoxItemGradeNecComp>();
    private Double estoqueMinimo = 0.0;
    private Double estoqueRessuprimento = 0.0;
    private Double estoqueMaximo = 0.0;
    private Double estoque = 0.0;
    private Double quantidadeComprada = 0.0;
    private Double quantidadeAdicional = 0.0;
    private Double quantidadeNecessidadeGerada = 0.0;
    private String observacao;
    private Short desativarNecessidade = 0;
    private String motivoDesativacao;
    private GrupoNecCompra grupoNecCompra;
    private LiberacaoNecCompraItem liberacaoNecCompraItem;
    private OrdemServico ordemServico;
    private Short aquisicaoPreferencial = 0;
    private String motivoAquisicaoPreferencial;
    private UnidadeFatFornecedor unidadeFatFornecedor;
    private Double valor = 0.0;
    private CondicoesPagamento condicoesPagamento;
    private String condicaoMutante;
    private TipoFrete tipoFrete;
    private Long prazoEntrega = 0L;
    private Date dataPrevFaturamento;
    private List<EmailGrupoNecCompra> emailGrupoNecCompra = new ArrayList<EmailGrupoNecCompra>();
    private Equipamento ativo;
    private List<ItemNecCompraDetalhes> itemNecCompraDetalhes = new ArrayList<ItemNecCompraDetalhes>();
    private Pedido pedido;
    private SituacaoNecessidadeCompra situacaoNecessidadeCompra;
    private NaturezaOperacao naturezaOperacao;
    private ClassificacaoNecessidadeCompra classificacaoNecessidade;
    private MotivoAquisicaoPref motivoAquisPref;

    public NecessidadeCompra() {
        this.dataNecessidade = new Date();
        this.dataCadastro = new Date();
    }

    @Id
    @Column(name="ID_NECESSIDADE_COMPRA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_NECESSIDADE_COMPRA")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_NECESSIDADE")
    public Date getDataNecessidade() {
        return this.dataNecessidade;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(name="TIPO_GERACAO")
    public Short getTipoGeracao() {
        return this.tipoGeracao;
    }

    @Column(name="TIPO_NECESSIDADE")
    public Short getTipoNecessidade() {
        return this.tipoNecessidade;
    }

    @Column(nullable=false, name="QUANTIDADE_NECESSIDADE", precision=18, scale=6)
    public Double getQuantidadeNecessidade() {
        return this.quantidadeNecessidade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_NECESSIDADE_DE_COMPRA_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_NECESSIDADE_DE_COMPRA_GC"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_COTACAO_COMPRA", foreignKey=@ForeignKey(name="FK_NECESSIDADE_DE_COMPRA_ICC"))
    public ItemCotacaoCompra getItemCotacaoCompraGerada() {
        return this.itemCotacaoCompraGerada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_NECESSIDADE_DE_COMPRA_CC"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_SOLICITANTE", foreignKey=@ForeignKey(name="FK_NECESSIDADE_DE_COMPRA_US"))
    public Usuario getUsuarioSolicitante() {
        return this.usuarioSolicitante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_COMPRADOR", foreignKey=@ForeignKey(name="FK_NECESSIDADE_DE_COMPRA_UC"))
    public Usuario getUsuarioComprador() {
        return this.usuarioComprador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_LIBERACAO", foreignKey=@ForeignKey(name="FK_NECESSIDADE_DE_COMPRA_UL"))
    public Usuario getUsuarioLiberacao() {
        return this.usuarioLiberacao;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataNecessidade(Date dataNecessidade) {
        this.dataNecessidade = dataNecessidade;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setTipoGeracao(Short tipoGeracao) {
        this.tipoGeracao = tipoGeracao;
    }

    public void setTipoNecessidade(Short tipoNecessidade) {
        this.tipoNecessidade = tipoNecessidade;
    }

    public void setQuantidadeNecessidade(Double quantidadeNecessidade) {
        this.quantidadeNecessidade = quantidadeNecessidade;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    public void setItemCotacaoCompraGerada(ItemCotacaoCompra itemCotacaoCompraGerada) {
        this.itemCotacaoCompraGerada = itemCotacaoCompraGerada;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    public void setUsuarioSolicitante(Usuario usuarioSolicitante) {
        this.usuarioSolicitante = usuarioSolicitante;
    }

    public void setUsuarioComprador(Usuario usuarioComprador) {
        this.usuarioComprador = usuarioComprador;
    }

    public void setUsuarioLiberacao(Usuario usuarioLiberacao) {
        this.usuarioLiberacao = usuarioLiberacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Necessidade de compra numero: {0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="necessidadeCompra", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<AtendPedAlmoxItemGradeNecComp> getAtendPedAlmoxNecCompra() {
        return this.atendPedAlmoxNecCompra;
    }

    public void setAtendPedAlmoxNecCompra(List<AtendPedAlmoxItemGradeNecComp> atendPedAlmoxNecCompra) {
        this.atendPedAlmoxNecCompra = atendPedAlmoxNecCompra;
    }

    @Column(name="ESTOQUE_MINIMO", precision=15, scale=4)
    public Double getEstoqueMinimo() {
        return this.estoqueMinimo;
    }

    public void setEstoqueMinimo(Double estoqueMinimo) {
        this.estoqueMinimo = estoqueMinimo;
    }

    @Column(name="ESTOQUE_RESSUPRIMENTO", precision=15, scale=4)
    public Double getEstoqueRessuprimento() {
        return this.estoqueRessuprimento;
    }

    public void setEstoqueRessuprimento(Double estoqueRessuprimento) {
        this.estoqueRessuprimento = estoqueRessuprimento;
    }

    @Column(name="ESTOQUE_MAXIMO", precision=15, scale=4)
    public Double getEstoqueMaximo() {
        return this.estoqueMaximo;
    }

    public void setEstoqueMaximo(Double estoqueMaximo) {
        this.estoqueMaximo = estoqueMaximo;
    }

    @Column(name="ESTOQUE", precision=15, scale=4)
    public Double getEstoque() {
        return this.estoque;
    }

    public void setEstoque(Double estoque) {
        this.estoque = estoque;
    }

    @Column(nullable=false, name="QUANTIDADE_COMPRADA", precision=15, scale=4)
    public Double getQuantidadeComprada() {
        return this.quantidadeComprada;
    }

    public void setQuantidadeComprada(Double quantidadeComprada) {
        this.quantidadeComprada = quantidadeComprada;
    }

    @Column(nullable=false, name="QUANTIDADE_ADICIONAL", precision=15, scale=4)
    public Double getQuantidadeAdicional() {
        return this.quantidadeAdicional;
    }

    public void setQuantidadeAdicional(Double quantidadeAdicional) {
        this.quantidadeAdicional = quantidadeAdicional;
    }

    @Column(nullable=false, name="QTD_NECESSARIA_GERADA", precision=15, scale=4)
    public Double getQuantidadeNecessidadeGerada() {
        return this.quantidadeNecessidadeGerada;
    }

    public void setQuantidadeNecessidadeGerada(Double quantidadeNecessidadeGerada) {
        this.quantidadeNecessidadeGerada = quantidadeNecessidadeGerada;
    }

    @Column(name="OBSERVACAO", length=15000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="DESATIVAR_NECESSIDADE")
    public Short getDesativarNecessidade() {
        return this.desativarNecessidade;
    }

    public void setDesativarNecessidade(Short desativarNecessidade) {
        this.desativarNecessidade = desativarNecessidade;
    }

    @Column(name="MOTIVO_DESATIVACAO", length=200)
    public String getMotivoDesativacao() {
        return this.motivoDesativacao;
    }

    public void setMotivoDesativacao(String motivoDesativacao) {
        this.motivoDesativacao = motivoDesativacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_NEC_COMPRA", foreignKey=@ForeignKey(name="FK_NECESSIDADE_DE_COMPRA_GR_NEC"))
    public GrupoNecCompra getGrupoNecCompra() {
        return this.grupoNecCompra;
    }

    public void setGrupoNecCompra(GrupoNecCompra grupoNecCompra) {
        this.grupoNecCompra = grupoNecCompra;
    }

    @OneToOne(fetch=FetchType.LAZY, mappedBy="necessidadeCompra")
    public LiberacaoNecCompraItem getLiberacaoNecCompraItem() {
        return this.liberacaoNecCompraItem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ORDEM_SERVICO", foreignKey=@ForeignKey(name="FK_NECESSIDADE_DE_COMPRA_0S"))
    public OrdemServico getOrdemServico() {
        return this.ordemServico;
    }

    public void setOrdemServico(OrdemServico ordemServico) {
        this.ordemServico = ordemServico;
    }

    public void setLiberacaoNecCompraItem(LiberacaoNecCompraItem liberacaoNecCompraItem) {
        this.liberacaoNecCompraItem = liberacaoNecCompraItem;
    }

    @Column(name="AQUISICAO_PREFERENCIAL")
    public Short getAquisicaoPreferencial() {
        return this.aquisicaoPreferencial;
    }

    public void setAquisicaoPreferencial(Short aquisicaoPreferencial) {
        this.aquisicaoPreferencial = aquisicaoPreferencial;
    }

    @Column(name="MOTIVO_AQUISICAO_PREFERENCIAL", length=255)
    public String getMotivoAquisicaoPreferencial() {
        return this.motivoAquisicaoPreferencial;
    }

    public void setMotivoAquisicaoPreferencial(String motivoAquisicaoPreferencial) {
        this.motivoAquisicaoPreferencial = motivoAquisicaoPreferencial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_FORNECEDOR", foreignKey=@ForeignKey(name="FK_NECESSIDADE_DE_COMPRA_UF"))
    public UnidadeFatFornecedor getUnidadeFatFornecedor() {
        return this.unidadeFatFornecedor;
    }

    public void setUnidadeFatFornecedor(UnidadeFatFornecedor unidadeFatFornecedor) {
        this.unidadeFatFornecedor = unidadeFatFornecedor;
    }

    @Column(name="VALOR", precision=15, scale=4)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_NECESSIDADE_DE_COMPRA_CP"))
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @Column(name="CONDICAO_MUTANTE", length=255)
    public String getCondicaoMutante() {
        return this.condicaoMutante;
    }

    public void setCondicaoMutante(String condicaoMutante) {
        this.condicaoMutante = condicaoMutante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_FRETE", foreignKey=@ForeignKey(name="FK_NECESSIDADE_DE_COMPRA_TF"))
    public TipoFrete getTipoFrete() {
        return this.tipoFrete;
    }

    public void setTipoFrete(TipoFrete tipoFrete) {
        this.tipoFrete = tipoFrete;
    }

    @Column(name="PRAZO_ENTREGA")
    public Long getPrazoEntrega() {
        return this.prazoEntrega;
    }

    public void setPrazoEntrega(Long prazoEntrega) {
        this.prazoEntrega = prazoEntrega;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_PREV_FATURAMENTO")
    public Date getDataPrevFaturamento() {
        return this.dataPrevFaturamento;
    }

    public void setDataPrevFaturamento(Date dataPrevFaturamento) {
        this.dataPrevFaturamento = dataPrevFaturamento;
    }

    @OneToMany(mappedBy="necessidadeCompra", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<EmailGrupoNecCompra> getEmailGrupoNecCompra() {
        return this.emailGrupoNecCompra;
    }

    public void setEmailGrupoNecCompra(List<EmailGrupoNecCompra> emailGrupoNecCompra) {
        this.emailGrupoNecCompra = emailGrupoNecCompra;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ATIVO", foreignKey=@ForeignKey(name="FK_NECESSIDADE_DE_COMPRA_ATIVO"))
    public Equipamento getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Equipamento ativo) {
        this.ativo = ativo;
    }

    @OneToMany(mappedBy="necessidadeCompra", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemNecCompraDetalhes> getItemNecCompraDetalhes() {
        return this.itemNecCompraDetalhes;
    }

    public void setItemNecCompraDetalhes(List<ItemNecCompraDetalhes> itemNecCompraDetalhes) {
        this.itemNecCompraDetalhes = itemNecCompraDetalhes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PEDIDO", foreignKey=@ForeignKey(name="FK_NECESSIDADE_DE_COMPRA_PEDIDO"))
    public Pedido getPedido() {
        return this.pedido;
    }

    public void setPedido(Pedido pedido) {
        this.pedido = pedido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SITUACAO_NEC_COMPRA", foreignKey=@ForeignKey(name="FK_NEC_COMPRA_SIT_NEC_COMPRA"))
    public SituacaoNecessidadeCompra getSituacaoNecessidadeCompra() {
        return this.situacaoNecessidadeCompra;
    }

    public void setSituacaoNecessidadeCompra(SituacaoNecessidadeCompra situacaoNecessidadeCompra) {
        this.situacaoNecessidadeCompra = situacaoNecessidadeCompra;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_NECESSIDADE_DE_COMPRA_NAT_OP"))
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_NECESSIDADE", foreignKey=@ForeignKey(name="FK_NECESSIDADE_COMPRA_CLASSIFIC"))
    public ClassificacaoNecessidadeCompra getClassificacaoNecessidade() {
        return this.classificacaoNecessidade;
    }

    public void setClassificacaoNecessidade(ClassificacaoNecessidadeCompra classificacaoNecessidade) {
        this.classificacaoNecessidade = classificacaoNecessidade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOTIVO_AQUISICAO_PREF", foreignKey=@ForeignKey(name="FK_FORN_ITEM_COT_COMP_MOT_AQ_PR"))
    public MotivoAquisicaoPref getMotivoAquisPref() {
        return this.motivoAquisPref;
    }

    public void setMotivoAquisPref(MotivoAquisicaoPref motivoAquisPref) {
        this.motivoAquisPref = motivoAquisPref;
    }
}

