/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BalancaRodoviario;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesTicketFiscalCliente;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="OPCOES_TICKET_FISCAL", uniqueConstraints={@UniqueConstraint(name="UNQ1_OPCOES_TICKET_FISCAL", columnNames={"ID_EMPRESA"})})
public class OpcoesTicketFiscal
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private BalancaRodoviario balancaRodoviario;
    private Short informarPedido;
    private Short informarConjuntoTransportador;
    private Short habilitadoPesoTaraTotal;
    private Short habPesoEstimadoLiquidoEst;
    private Short validarInversoPesoTotalTara;
    private Short buscarAutGradeCorLoteFab;
    private BusinessIntelligence biImpTicketFiscalEntrada;
    private Short informarNrManualTicketEnt = EnumConstantsMentorSimNao.NAO.getValue();
    private Short movimentarEstoqueTicketEnt;
    private String chaveFichaTecnicaQtdAmostragem;
    private Short importarNumeroXml;
    private Short importarDadosProdutoXml;
    private Short importarStatusAbertoXml;
    private Short impStatusFechadoGridNetEnt;
    private UnidadeFatFornecedor unidFatFornGridNetEnt;
    private Transportador transportadorGridNetEnt;
    private Produto produtoGridNetEnt;
    private CentroEstoque centroEstoqueGridNetEnt;
    private List<OpcoesTicketFiscalCliente> opcoesTicketFiscalCliente;
    private Short pesosZeradosTicEnt;
    private Short habilitarMaisTicketNota;
    private Short desabilitarinformarManualPesoTaraTotal;

    public OpcoesTicketFiscal() {
        this.informarPedido = EnumConstantsMentorSimNao.NAO.getValue();
        this.informarConjuntoTransportador = EnumConstantsMentorSimNao.NAO.getValue();
        this.habilitadoPesoTaraTotal = EnumConstantsMentorSimNao.NAO.getValue();
        this.habPesoEstimadoLiquidoEst = EnumConstantsMentorSimNao.NAO.getValue();
        this.validarInversoPesoTotalTara = EnumConstantsMentorSimNao.NAO.getValue();
        this.buscarAutGradeCorLoteFab = EnumConstantsMentorSimNao.NAO.getValue();
        this.movimentarEstoqueTicketEnt = EnumConstantsMentorSimNao.NAO.getValue();
        this.importarNumeroXml = EnumConstantsMentorSimNao.SIM.getValue();
        this.importarDadosProdutoXml = EnumConstantsMentorSimNao.SIM.getValue();
        this.importarStatusAbertoXml = EnumConstantsMentorSimNao.NAO.getValue();
        this.impStatusFechadoGridNetEnt = EnumConstantsMentorSimNao.NAO.getValue();
        this.opcoesTicketFiscalCliente = new ArrayList<OpcoesTicketFiscalCliente>();
        this.pesosZeradosTicEnt = EnumConstantsMentorSimNao.NAO.getValue();
        this.habilitarMaisTicketNota = EnumConstantsMentorSimNao.NAO.getValue();
        this.desabilitarinformarManualPesoTaraTotal = EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Id
    @Column(nullable=false, name="ID_OPCOES_TICKET_FISCAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_OPCOES_TICKET_FISCAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_OPCOES_TICKET_FISCAL_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BALANCA_RODOVIARIO", foreignKey=@ForeignKey(name="FK_OPCOES_TICKET_FISCAL_BAL_ROD"))
    public BalancaRodoviario getBalancaRodoviario() {
        return this.balancaRodoviario;
    }

    public void setBalancaRodoviario(BalancaRodoviario balancaRodoviario) {
        this.balancaRodoviario = balancaRodoviario;
    }

    @Column(nullable=false, name="INFORMAR_PEDIDO")
    public Short getInformarPedido() {
        return this.informarPedido;
    }

    public void setInformarPedido(Short informarPedido) {
        this.informarPedido = informarPedido;
    }

    @Column(nullable=false, name="INFORMAR_CONJUNTO_TRANSPORTADOR")
    public Short getInformarConjuntoTransportador() {
        return this.informarConjuntoTransportador;
    }

    public void setInformarConjuntoTransportador(Short informarConjuntoTransportador) {
        this.informarConjuntoTransportador = informarConjuntoTransportador;
    }

    @Column(nullable=false, name="HABILITADO_PESO_TARA_TOTAL")
    public Short getHabilitadoPesoTaraTotal() {
        return this.habilitadoPesoTaraTotal;
    }

    public void setHabilitadoPesoTaraTotal(Short habilitadoPesoTaraTotal) {
        this.habilitadoPesoTaraTotal = habilitadoPesoTaraTotal;
    }

    @Column(nullable=false, name="HAB_PESO_ESTIMADO_LIQUIDO_EST")
    public Short getHabPesoEstimadoLiquidoEst() {
        return this.habPesoEstimadoLiquidoEst;
    }

    public void setHabPesoEstimadoLiquidoEst(Short habPesoEstimadoLiquidoEst) {
        this.habPesoEstimadoLiquidoEst = habPesoEstimadoLiquidoEst;
    }

    @Column(nullable=false, name="VALIDAR_INVERSO_PESO_TOTAL_TARA")
    public Short getValidarInversoPesoTotalTara() {
        return this.validarInversoPesoTotalTara;
    }

    public void setValidarInversoPesoTotalTara(Short validarInversoPesoTotalTara) {
        this.validarInversoPesoTotalTara = validarInversoPesoTotalTara;
    }

    @Column(nullable=false, name="BUSCAR_AUT_GRADE_COR_LOTE_FAB")
    public Short getBuscarAutGradeCorLoteFab() {
        return this.buscarAutGradeCorLoteFab;
    }

    public void setBuscarAutGradeCorLoteFab(Short buscarAutGradeCorLoteFab) {
        this.buscarAutGradeCorLoteFab = buscarAutGradeCorLoteFab;
    }

    @ManyToOne(targetEntity=BusinessIntelligence.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BI_IMP_TICKET_FISCAL_ENTRADA", foreignKey=@ForeignKey(name="FK_OPCOES_TICKET_FISCAL_BI_TFE"))
    public BusinessIntelligence getBiImpTicketFiscalEntrada() {
        return this.biImpTicketFiscalEntrada;
    }

    public void setBiImpTicketFiscalEntrada(BusinessIntelligence biImpTicketFiscalEntrada) {
        this.biImpTicketFiscalEntrada = biImpTicketFiscalEntrada;
    }

    @Column(nullable=false, name="IMPORTAR_NUMERO_XML")
    public Short getImportarNumeroXml() {
        return this.importarNumeroXml;
    }

    public void setImportarNumeroXml(Short importarNumeroXml) {
        this.importarNumeroXml = importarNumeroXml;
    }

    @Column(nullable=false, name="IMPORTAR_DADOS_PRODUTO_XML")
    public Short getImportarDadosProdutoXml() {
        return this.importarDadosProdutoXml;
    }

    public void setImportarDadosProdutoXml(Short importarDadosProdutoXml) {
        this.importarDadosProdutoXml = importarDadosProdutoXml;
    }

    @Column(nullable=false, name="IMPORTAR_STATUS_ABERTO_XML")
    public Short getImportarStatusAbertoXml() {
        return this.importarStatusAbertoXml;
    }

    public void setImportarStatusAbertoXml(Short importarStatusAbertoXml) {
        this.importarStatusAbertoXml = importarStatusAbertoXml;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="INFORMAR_NR_MANUAL_TICKET_ENT")
    public Short getInformarNrManualTicketEnt() {
        return this.informarNrManualTicketEnt;
    }

    public void setInformarNrManualTicketEnt(Short informarNrManualTicketEnt) {
        this.informarNrManualTicketEnt = informarNrManualTicketEnt;
    }

    @Column(name="MOVIMENTAR_ESTOQUE_TICKET_ENT")
    public Short getMovimentarEstoqueTicketEnt() {
        return this.movimentarEstoqueTicketEnt;
    }

    public void setMovimentarEstoqueTicketEnt(Short movimentarEstoqueTicketEnt) {
        this.movimentarEstoqueTicketEnt = movimentarEstoqueTicketEnt;
    }

    @Column(name="CHAVE_FICHA_TEC_QTD_AMOSTRA")
    public String getChaveFichaTecnicaQtdAmostragem() {
        return this.chaveFichaTecnicaQtdAmostragem;
    }

    public void setChaveFichaTecnicaQtdAmostragem(String chaveFichaTecnicaQtdAmostragem) {
        this.chaveFichaTecnicaQtdAmostragem = chaveFichaTecnicaQtdAmostragem;
    }

    @Column(name="IMP_STATUS_FECHADO_GRID_NET_ENT")
    public Short getImpStatusFechadoGridNetEnt() {
        return this.impStatusFechadoGridNetEnt;
    }

    public void setImpStatusFechadoGridNetEnt(Short impStatusFechadoGridNetEnt) {
        this.impStatusFechadoGridNetEnt = impStatusFechadoGridNetEnt;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNID_FAT_FORN_GRID_NET_ENT", foreignKey=@ForeignKey(name="FK_OPCOES_TICKET_FISCAL_U_F_F"))
    public UnidadeFatFornecedor getUnidFatFornGridNetEnt() {
        return this.unidFatFornGridNetEnt;
    }

    public void setUnidFatFornGridNetEnt(UnidadeFatFornecedor unidFatFornGridNetEnt) {
        this.unidFatFornGridNetEnt = unidFatFornGridNetEnt;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSPORTADOR_GRID_NET_ENT", foreignKey=@ForeignKey(name="FK_OPCOES_TICKET_FISCAL_TRANSPO"))
    public Transportador getTransportadorGridNetEnt() {
        return this.transportadorGridNetEnt;
    }

    public void setTransportadorGridNetEnt(Transportador transportadorGridNetEnt) {
        this.transportadorGridNetEnt = transportadorGridNetEnt;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO_GRID_NET_ENT", foreignKey=@ForeignKey(name="FK_OPCOES_TICKET_FISCAL_PRODUTO"))
    public Produto getProdutoGridNetEnt() {
        return this.produtoGridNetEnt;
    }

    public void setProdutoGridNetEnt(Produto produtoGridNetEnt) {
        this.produtoGridNetEnt = produtoGridNetEnt;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE_GRID_NET_ENT", foreignKey=@ForeignKey(name="FK_OPCOES_TICKET_FISCAL_CEN_EST"))
    public CentroEstoque getCentroEstoqueGridNetEnt() {
        return this.centroEstoqueGridNetEnt;
    }

    public void setCentroEstoqueGridNetEnt(CentroEstoque centroEstoqueGridNetEnt) {
        this.centroEstoqueGridNetEnt = centroEstoqueGridNetEnt;
    }

    @OneToMany(mappedBy="opcoesTicketFiscal", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<OpcoesTicketFiscalCliente> getOpcoesTicketFiscalCliente() {
        return this.opcoesTicketFiscalCliente;
    }

    public void setOpcoesTicketFiscalCliente(List<OpcoesTicketFiscalCliente> opcoesTicketFiscalCliente) {
        this.opcoesTicketFiscalCliente = opcoesTicketFiscalCliente;
    }

    @Column(name="PESOS_ZERADOS_TIC_ENT")
    public Short getPesosZeradosTicEnt() {
        return this.pesosZeradosTicEnt;
    }

    public void setPesosZeradosTicEnt(Short pesosZeradosTicEnt) {
        this.pesosZeradosTicEnt = pesosZeradosTicEnt;
    }

    @Column(name="HABILITAR_MAIS_TICKET_NOTA")
    public Short getHabilitarMaisTicketNota() {
        return this.habilitarMaisTicketNota;
    }

    public void setHabilitarMaisTicketNota(Short habilitarMaisTicketNota) {
        this.habilitarMaisTicketNota = habilitarMaisTicketNota;
    }

    @Column(name="DESABILITAR_INF_MANUAL_PES_TARA")
    public Short getDesabilitarinformarManualPesoTaraTotal() {
        return this.desabilitarinformarManualPesoTaraTotal;
    }

    public void setDesabilitarinformarManualPesoTaraTotal(Short desabilitarinformarManualPesoTaraTotal) {
        this.desabilitarinformarManualPesoTaraTotal = desabilitarinformarManualPesoTaraTotal;
    }
}

