/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.CronogramaOrdemServico;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.FechamentoOrdemServico;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.ItemControleSolicitacaoServico;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OrdemServicoNecMateriais;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivo;
import com.touchcomp.basementor.model.vo.SetorExecutante;
import com.touchcomp.basementor.model.vo.TipoServico;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="ORDEM_SERVICO", uniqueConstraints={@UniqueConstraint(name="UNQ1_ORDEM_SERVICO", columnNames={"CODIGO"})})
public class OrdemServico
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private String descricaoServico;
    private String observacoes = "";
    private Short gerado = 0;
    private Short status = 0;
    private Short prioridade = 0;
    private Date dataEmissao;
    private Timestamp dataPrevisao;
    private Timestamp dataProgramada;
    private Timestamp dataHoraParada;
    private Long codigo;
    private Pessoa solicitante;
    private Pessoa responsavel;
    private Equipamento equipamento;
    private SetorExecutante setorExecutante;
    private CentroCusto centroCusto;
    private TipoServico tipoServico;
    private Fornecedor fornecedor;
    private ItemControleSolicitacaoServico itemControleSolicitacaoServico;
    private FechamentoOrdemServico fechamentoOrdemServico;
    private List<PlanoManutencaoAtivo> planosManutencaoAtivo = new ArrayList<PlanoManutencaoAtivo>();
    private Short reservarEstoque = 0;
    private List<OrdemServicoNecMateriais> ordemServicoNecMateriais;
    private List<TransferenciaCentroEstoque> transferenciaCentroEstoques;
    private List<NecessidadeCompra> necessidadeCompra = new ArrayList<NecessidadeCompra>();
    private CronogramaOrdemServico cronogramaOrdemServico;
    private Coleta coleta;
    private DiagnosticoOSAtivo diagnosticoOSAtivo;
    private Short ativoParado = 1;

    public OrdemServico() {
        this.ordemServicoNecMateriais = new ArrayList<OrdemServicoNecMateriais>();
        this.transferenciaCentroEstoques = new ArrayList<TransferenciaCentroEstoque>();
    }

    @Id
    @Column(nullable=false, name="ID_ORDEM_SERVICO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ORDEM_SERVICO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_ORDEM_SERVICO_CENTRO_CUSTO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Column(nullable=false, name="DESCRICAO", length=300)
    public String getDescricaoServico() {
        return this.descricaoServico;
    }

    public void setDescricaoServico(String descricaoServico) {
        this.descricaoServico = descricaoServico;
    }

    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ORDEM_SERVICO_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(nullable=false, name="ID_EQUIPAMENTO", foreignKey=@ForeignKey(name="FK_ORDEM_SERVICO_EQUIPAMENTO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Equipamento getEquipamento() {
        return this.equipamento;
    }

    public void setEquipamento(Equipamento equipamento) {
        this.equipamento = equipamento;
    }

    @Column(nullable=false, name="GERADO")
    public Short getGerado() {
        return this.gerado;
    }

    public void setGerado(Short gerado) {
        this.gerado = gerado;
    }

    @JoinColumn(nullable=true, name="ID_SOLICITANTE", foreignKey=@ForeignKey(name="FK_ORDEM_SERVICO_PESSOA_S"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getSolicitante() {
        return this.solicitante;
    }

    public void setSolicitante(Pessoa solicitante) {
        this.solicitante = solicitante;
    }

    @Generated(value=GenerationTime.INSERT)
    @Column(name="CODIGO")
    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @JoinColumn(name="ID_SETOR_EXECUTANTE", foreignKey=@ForeignKey(name="FK_ORDEM_SERVICO_SETOR_EXECUTAN"))
    @ManyToOne(fetch=FetchType.LAZY)
    public SetorExecutante getSetorExecutante() {
        return this.setorExecutante;
    }

    public void setSetorExecutante(SetorExecutante setorExecutante) {
        this.setorExecutante = setorExecutante;
    }

    @Column(name="PRIORIDADE")
    public Short getPrioridade() {
        return this.prioridade;
    }

    public void setPrioridade(Short prioridade) {
        this.prioridade = prioridade;
    }

    @JoinColumn(name="ID_RESPONSAVEL", foreignKey=@ForeignKey(name="FK_ORDEM_SERVICO_PESSOA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(Pessoa responsavel) {
        this.responsavel = responsavel;
    }

    @JoinColumn(name="ID_TIPO_SERVICO", foreignKey=@ForeignKey(name="FK_ORDEM_SERVICO_TIPO_SERVICO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoServico getTipoServico() {
        return this.tipoServico;
    }

    public void setTipoServico(TipoServico tipoServico) {
        this.tipoServico = tipoServico;
    }

    @Column(name="DATA_PROGRAMADA")
    public Timestamp getDataProgramada() {
        return this.dataProgramada;
    }

    public void setDataProgramada(Timestamp dataProgramada) {
        this.dataProgramada = dataProgramada;
    }

    @Column(name="DATA_HORA_PARADA")
    public Timestamp getDataHoraParada() {
        return this.dataHoraParada;
    }

    public void setDataHoraParada(Timestamp dataHoraParada) {
        this.dataHoraParada = dataHoraParada;
    }

    @Column(name="STATUS")
    public Short getStatus() {
        return this.status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    @Column(name="DATA_PREVISAO")
    public Timestamp getDataPrevisao() {
        return this.dataPrevisao;
    }

    public void setDataPrevisao(Timestamp dataPrevisao) {
        this.dataPrevisao = dataPrevisao;
    }

    @Column(name="OBSERVACOES", length=500)
    public String getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    @JoinColumn(name="ID_FORNECEDOR", foreignKey=@ForeignKey(name="FK_ORDEM_SERVICO_FORNECEDOR"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Fornecedor getFornecedor() {
        return this.fornecedor;
    }

    public void setFornecedor(Fornecedor fornecedor) {
        this.fornecedor = fornecedor;
    }

    @OneToOne(mappedBy="ordemServico", fetch=FetchType.LAZY)
    public ItemControleSolicitacaoServico getItemControleSolicitacaoServico() {
        return this.itemControleSolicitacaoServico;
    }

    public void setItemControleSolicitacaoServico(ItemControleSolicitacaoServico itemControleSolicitacaoServico) {
        this.itemControleSolicitacaoServico = itemControleSolicitacaoServico;
    }

    @OneToOne(mappedBy="ordemServico", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public FechamentoOrdemServico getFechamentoOrdemServico() {
        return this.fechamentoOrdemServico;
    }

    public void setFechamentoOrdemServico(FechamentoOrdemServico fechamentoOrdemServico) {
        this.fechamentoOrdemServico = fechamentoOrdemServico;
    }

    @OneToMany(targetEntity=PlanoManutencaoAtivo.class)
    @Cascade(value={CascadeType.MERGE, CascadeType.SAVE_UPDATE})
    @JoinTable(name="OS_PLANO_MANUTENCAO", joinColumns={@JoinColumn(name="ID_ORDEM_SERVICO")}, inverseJoinColumns={@JoinColumn(name="ID_PLANO_MANUTENCAO_ATIVO")})
    public List<PlanoManutencaoAtivo> getPlanosManutencaoAtivo() {
        return this.planosManutencaoAtivo;
    }

    public void setPlanosManutencaoAtivo(List<PlanoManutencaoAtivo> planosManutencaoAtivo) {
        this.planosManutencaoAtivo = planosManutencaoAtivo;
    }

    @Column(name="RESERVAR_ESTOQUE")
    public Short getReservarEstoque() {
        return this.reservarEstoque;
    }

    public void setReservarEstoque(Short reservarEstoque) {
        this.reservarEstoque = reservarEstoque;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="ordemServico")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<OrdemServicoNecMateriais> getOrdemServicoNecMateriais() {
        return this.ordemServicoNecMateriais;
    }

    public void setOrdemServicoNecMateriais(List<OrdemServicoNecMateriais> ordemServicoNecMateriais) {
        this.ordemServicoNecMateriais = ordemServicoNecMateriais;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="ordemServico")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<TransferenciaCentroEstoque> getTransferenciaCentroEstoques() {
        return this.transferenciaCentroEstoques;
    }

    public void setTransferenciaCentroEstoques(List<TransferenciaCentroEstoque> transferenciaCentroEstoques) {
        this.transferenciaCentroEstoques = transferenciaCentroEstoques;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="ordemServico")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<NecessidadeCompra> getNecessidadeCompra() {
        return this.necessidadeCompra;
    }

    public void setNecessidadeCompra(List<NecessidadeCompra> necessidadeCompra) {
        this.necessidadeCompra = necessidadeCompra;
    }

    @OneToOne(fetch=FetchType.LAZY, mappedBy="ordemServico")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public CronogramaOrdemServico getCronogramaOrdemServico() {
        return this.cronogramaOrdemServico;
    }

    public void setCronogramaOrdemServico(CronogramaOrdemServico cronogramaOrdemServico) {
        this.cronogramaOrdemServico = cronogramaOrdemServico;
    }

    @JoinColumn(name="ID_COLETA", foreignKey=@ForeignKey(name="FK_ORDEM_SERVICO_COLETA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Coleta getColeta() {
        return this.coleta;
    }

    public void setColeta(Coleta coleta) {
        this.coleta = coleta;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricaoServico()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToOne(mappedBy="ordemServico")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public DiagnosticoOSAtivo getDiagnosticoOSAtivo() {
        return this.diagnosticoOSAtivo;
    }

    public void setDiagnosticoOSAtivo(DiagnosticoOSAtivo diagnosticoOSAtivo) {
        this.diagnosticoOSAtivo = diagnosticoOSAtivo;
    }

    @Column(name="ATIVO_PARADO")
    public Short getAtivoParado() {
        return this.ativoParado;
    }

    public void setAtivoParado(Short ativoParado) {
        this.ativoParado = ativoParado;
    }
}

