/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.ParamContabilizacaoFolhaCentroCusto;
import com.touchcomp.basementor.model.vo.ParamContabilizacaoFolhaEventos;
import com.touchcomp.basementor.model.vo.ParamContabilizacaoFolhaTipoCalculo;
import com.touchcomp.basementor.model.vo.ParamContabilizacaoTipoColaborador;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PARAMETRIZACAO_CONTABIL_FOLHA")
public class ParametrizacaoContabilizacaoFolha
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private PlanoConta planoContaDebito;
    private PlanoConta planoContaCredito;
    private HistoricoPadrao historico;
    private List<ParamContabilizacaoFolhaCentroCusto> paramCentroCusto = new ArrayList<ParamContabilizacaoFolhaCentroCusto>();
    private List<ParamContabilizacaoFolhaEventos> paramEventos = new ArrayList<ParamContabilizacaoFolhaEventos>();
    private List<ParamContabilizacaoFolhaTipoCalculo> paramTipoCalculo = new ArrayList<ParamContabilizacaoFolhaTipoCalculo>();
    private List<ParamContabilizacaoTipoColaborador> paramTipoColaborador = new ArrayList<ParamContabilizacaoTipoColaborador>();
    private Short buscarContaCreditoColaborador = 0;
    private Short buscarContaDebitoColaborador = 0;
    private PlanoContaGerencial planoContaGerencial;
    private String descricao;

    @Id
    @Column(nullable=false, unique=true, name="ID_PARAM_FOLHA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PARAM_FOLHA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PARAME_CONTABIL_FOLH_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_DEBITO", foreignKey=@ForeignKey(name="FK_PARAME_CONTABIL_FOLH_DEBITO"))
    public PlanoConta getPlanoContaDebito() {
        return this.planoContaDebito;
    }

    public void setPlanoContaDebito(PlanoConta planoContaDebito) {
        this.planoContaDebito = planoContaDebito;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_CREDITO", foreignKey=@ForeignKey(name="FK_PARAME_CONTABIL_FOLH_CREDITO"))
    public PlanoConta getPlanoContaCredito() {
        return this.planoContaCredito;
    }

    public void setPlanoContaCredito(PlanoConta planoContaCredito) {
        this.planoContaCredito = planoContaCredito;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_HISTORICO_PADRAO", foreignKey=@ForeignKey(name="FK_PARAME_CONTABIL_FOLH_HISTORI"))
    public HistoricoPadrao getHistorico() {
        return this.historico;
    }

    public void setHistorico(HistoricoPadrao historico) {
        this.historico = historico;
    }

    @OneToMany(mappedBy="parametrizacaoFolha", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ParamContabilizacaoFolhaCentroCusto> getParamCentroCusto() {
        return this.paramCentroCusto;
    }

    public void setParamCentroCusto(List<ParamContabilizacaoFolhaCentroCusto> paramCentroCusto) {
        this.paramCentroCusto = paramCentroCusto;
    }

    @OneToMany(mappedBy="parametrizacaoFolha", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ParamContabilizacaoFolhaEventos> getParamEventos() {
        return this.paramEventos;
    }

    public void setParamEventos(List<ParamContabilizacaoFolhaEventos> paramEventos) {
        this.paramEventos = paramEventos;
    }

    @OneToMany(mappedBy="parametrizacaoFolha", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ParamContabilizacaoFolhaTipoCalculo> getParamTipoCalculo() {
        return this.paramTipoCalculo;
    }

    public void setParamTipoCalculo(List<ParamContabilizacaoFolhaTipoCalculo> paramTipoCalculo) {
        this.paramTipoCalculo = paramTipoCalculo;
    }

    @OneToMany(mappedBy="contabilizacaoFolha", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ParamContabilizacaoTipoColaborador> getParamTipoColaborador() {
        return this.paramTipoColaborador;
    }

    public void setParamTipoColaborador(List<ParamContabilizacaoTipoColaborador> paramTipoColaborador) {
        this.paramTipoColaborador = paramTipoColaborador;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="BUSCAR_CONTA_CREDITO_COLABORADO")
    public Short getBuscarContaCreditoColaborador() {
        return this.buscarContaCreditoColaborador;
    }

    public void setBuscarContaCreditoColaborador(Short buscarContaCreditoColaborador) {
        this.buscarContaCreditoColaborador = buscarContaCreditoColaborador;
    }

    @Column(name="BUSCAR_CONTA_DEBITO_COLABORADO")
    public Short getBuscarContaDebitoColaborador() {
        return this.buscarContaDebitoColaborador;
    }

    public void setBuscarContaDebitoColaborador(Short buscarContaDebitoColaborador) {
        this.buscarContaDebitoColaborador = buscarContaDebitoColaborador;
    }

    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_PARAME_CONTABIL_PC_GER"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @Column(name="DESCRICAO", length=50)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }
}

