/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="PERFIL_INTEGRACAO_PONTO")
public class PerfilIntegracaoPonto {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private String descricao;
    private Short posicaoInicialColaborador = 0;
    private Short posicaoFinalColaborador = 0;
    private Short posicaoInicialData = 0;
    private Short posicaoFinalData = 0;
    private Short posicaoInicialHora = 0;
    private Short posicaoFinalHora = 0;
    private Double tempoTolerancia = 0.0;
    private Double horasTrabalhadasDia = 0.0;
    private String campoBuscaColaborador;

    @Id
    @Column(nullable=false, unique=true, name="ID_PERFIL_PONTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PERFIL_PONTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PERFIL_INTEGRACAO_PONTO_1"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DESCRICAO", length=40)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="POSICAO_INICIAL_COLABORADOR")
    public Short getPosicaoInicialColaborador() {
        return this.posicaoInicialColaborador;
    }

    public void setPosicaoInicialColaborador(Short posicaoInicialColaborador) {
        this.posicaoInicialColaborador = posicaoInicialColaborador;
    }

    @Column(name="POSICAO_FINAL_COLABORADOR")
    public Short getPosicaoFinalColaborador() {
        return this.posicaoFinalColaborador;
    }

    public void setPosicaoFinalColaborador(Short posicaoFinalColaborador) {
        this.posicaoFinalColaborador = posicaoFinalColaborador;
    }

    @Column(name="POSICAO_INICIAL_DATA")
    public Short getPosicaoInicialData() {
        return this.posicaoInicialData;
    }

    public void setPosicaoInicialData(Short posicaoInicialData) {
        this.posicaoInicialData = posicaoInicialData;
    }

    @Column(name="POSICAO_FINAL_DATA")
    public Short getPosicaoFinalData() {
        return this.posicaoFinalData;
    }

    public void setPosicaoFinalData(Short posicaoFinalData) {
        this.posicaoFinalData = posicaoFinalData;
    }

    @Column(name="POSICAO_INICIAL_HORA")
    public Short getPosicaoInicialHora() {
        return this.posicaoInicialHora;
    }

    public void setPosicaoInicialHora(Short posicaoInicialHora) {
        this.posicaoInicialHora = posicaoInicialHora;
    }

    @Column(name="POSICAO_FINAL_HORA")
    public Short getPosicaoFinalHora() {
        return this.posicaoFinalHora;
    }

    public void setPosicaoFinalHora(Short posicaoFinalHora) {
        this.posicaoFinalHora = posicaoFinalHora;
    }

    @Column(nullable=false, name="TEMPO_TOLERANCIA", precision=15, scale=2)
    public Double getTempoTolerancia() {
        return this.tempoTolerancia;
    }

    public void setTempoTolerancia(Double tempoTolerancia) {
        this.tempoTolerancia = tempoTolerancia;
    }

    @Column(nullable=false, name="HORAS_TRABALHADAS_DIA", precision=15, scale=2)
    public Double getHorasTrabalhadasDia() {
        return this.horasTrabalhadasDia;
    }

    public void setHorasTrabalhadasDia(Double horasTrabalhadasDia) {
        this.horasTrabalhadasDia = horasTrabalhadasDia;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="CAMPO_BUSCA_COLABORADOR", length=15)
    public String getCampoBuscaColaborador() {
        return this.campoBuscaColaborador;
    }

    public void setCampoBuscaColaborador(String campoBuscaColaborador) {
        this.campoBuscaColaborador = campoBuscaColaborador;
    }
}

