/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="PERIODO_FOLHA_PAG")
public class PeriodoFolhaPagamento
implements InterfaceVO {
    private Long identificador;
    private Date dataPagamento;
    private Date dataInicialFolha;
    private Date dataFinalFolha;
    private Date dataInicialVA;
    private Date dataFinalVA;
    private Date dataInicialVT;
    private Date dataFinalVT;
    private Date dataInicialApPonto;
    private Date dataFinalApPonto;
    private Date dataCadastro;
    private Empresa empresa;
    private String descricao;
    private Timestamp dataAtualizacao;
    private Short ativo = 1;

    @Id
    @Column(nullable=false, name="ID_PERIODO_FOLHA_PAG")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PERIODO_FOLHA_PAG")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_PAGAMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Column(name="DATA_INICIAL_VA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicialVA() {
        return this.dataInicialVA;
    }

    public void setDataInicialVA(Date dataInicialVA) {
        this.dataInicialVA = dataInicialVA;
    }

    @Column(name="DATA_FINAL_VA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinalVA() {
        return this.dataFinalVA;
    }

    public void setDataFinalVA(Date dataFinalVA) {
        this.dataFinalVA = dataFinalVA;
    }

    @Column(name="DATA_INICIAL_VT")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicialVT() {
        return this.dataInicialVT;
    }

    public void setDataInicialVT(Date dataInicialVT) {
        this.dataInicialVT = dataInicialVT;
    }

    @Column(name="DATA_FINAL_VT")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinalVT() {
        return this.dataFinalVT;
    }

    public void setDataFinalVT(Date dataFinalVT) {
        this.dataFinalVT = dataFinalVT;
    }

    @Column(name="DESCRICAO", length=300)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} / {1}({2})", (Object[])new Object[]{ToolDate.dateToStr((Date)this.dataPagamento), this.getDescricao(), this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PERIODO_FOLHA_PAG_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="DATA_INICIAL_FOLHA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicialFolha() {
        return this.dataInicialFolha;
    }

    public void setDataInicialFolha(Date dataInicialFolha) {
        this.dataInicialFolha = dataInicialFolha;
    }

    @Column(name="DATA_FINAL_FOLHA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinalFolha() {
        return this.dataFinalFolha;
    }

    public void setDataFinalFolha(Date dataFinalFolha) {
        this.dataFinalFolha = dataFinalFolha;
    }

    @Column(name="DATA_FINAL_AP_PONTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinalApPonto() {
        return this.dataFinalApPonto;
    }

    public void setDataFinalApPonto(Date dataFinalApPonto) {
        this.dataFinalApPonto = dataFinalApPonto;
    }

    @Column(name="DATA_INICIAL_AP_PONTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicialApPonto() {
        return this.dataInicialApPonto;
    }

    public void setDataInicialApPonto(Date dataInicialApPonto) {
        this.dataInicialApPonto = dataInicialApPonto;
    }
}

