/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AnaliseCustoProd;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.PlanejVendasProdItens;
import com.touchcomp.basementor.model.vo.PlanejVendasProdPlanLinProd;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="PLANEJ_VENDAS_PROD")
public class PlanejVendasProd
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private List<PlanejVendasProdPlanLinProd> planejamentos;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private List<PlanejVendasProdItens> itens = new LinkedList<PlanejVendasProdItens>();
    private Short tipoPesqCusto = 0;
    private TabelaPrecoBase tabelaPrecosBase;
    private Short tipoAnaliseCustoPCPLinha = 0;
    private Short tipoCapacidadeProdutiva = 0;
    private Date dataProdInicial;
    private Date dataProdFinal;
    private Date dataBase;
    private AnaliseCustoProd analiseCustoProd;
    private Double percentualEficiencia = 0.0;
    private Moeda moedaMatPrima;
    private Short carregarTabPrecosMatPrima = 0;
    private String observacao;

    public PlanejVendasProd() {
        this.planejamentos = new ArrayList<PlanejVendasProdPlanLinProd>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_PLANEJ_VENDAS_PROD")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PLANEJ_VENDAS_PROD")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DESCRICAO", length=255)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToMany(mappedBy="planejVendasProd")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<PlanejVendasProdPlanLinProd> getPlanejamentos() {
        return this.planejamentos;
    }

    public void setPlanejamentos(List<PlanejVendasProdPlanLinProd> planejamentos) {
        this.planejamentos = planejamentos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PLANEJ_V_PROD_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="planejamentoVendasProd")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<PlanejVendasProdItens> getItens() {
        return this.itens;
    }

    public void setItens(List<PlanejVendasProdItens> itens) {
        this.itens = itens;
    }

    @Column(nullable=false, name="TIPO_PESQ_CUSTO")
    public Short getTipoPesqCusto() {
        return this.tipoPesqCusto;
    }

    public void setTipoPesqCusto(Short tipoPesqCusto) {
        this.tipoPesqCusto = tipoPesqCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TABELA_PRECO_BASE", foreignKey=@ForeignKey(name="FK_PLANEJ_V_PROD_TAB_PR_BASE"))
    public TabelaPrecoBase getTabelaPrecosBase() {
        return this.tabelaPrecosBase;
    }

    public void setTabelaPrecosBase(TabelaPrecoBase tabelaPrecosBase) {
        this.tabelaPrecosBase = tabelaPrecosBase;
    }

    @Column(nullable=false, name="TIPO_ANALISE_CUSTO_PCP_LIN")
    public Short getTipoAnaliseCustoPCPLinha() {
        return this.tipoAnaliseCustoPCPLinha;
    }

    public void setTipoAnaliseCustoPCPLinha(Short tipoAnaliseCustoPCPLinha) {
        this.tipoAnaliseCustoPCPLinha = tipoAnaliseCustoPCPLinha;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_PROD_INICIAL")
    public Date getDataProdInicial() {
        return this.dataProdInicial;
    }

    public void setDataProdInicial(Date dataProdInicial) {
        this.dataProdInicial = dataProdInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_PROD_FINAL")
    public Date getDataProdFinal() {
        return this.dataProdFinal;
    }

    public void setDataProdFinal(Date dataProdFinal) {
        this.dataProdFinal = dataProdFinal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ANALISE_CUSTO_PROD", foreignKey=@ForeignKey(name="FK_PLANEJ_V_PROD_ANA_CUSTO_PROD"))
    public AnaliseCustoProd getAnaliseCustoProd() {
        return this.analiseCustoProd;
    }

    public void setAnaliseCustoProd(AnaliseCustoProd analiseCustoProd) {
        this.analiseCustoProd = analiseCustoProd;
    }

    @Column(nullable=false, name="TIPO_CAPACIDADE_PRODUTIVA")
    public Short getTipoCapacidadeProdutiva() {
        return this.tipoCapacidadeProdutiva;
    }

    public void setTipoCapacidadeProdutiva(Short tipoCapacidadeProdutiva) {
        this.tipoCapacidadeProdutiva = tipoCapacidadeProdutiva;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_BASE")
    public Date getDataBase() {
        return this.dataBase;
    }

    public void setDataBase(Date dataBase) {
        this.dataBase = dataBase;
    }

    @Column(nullable=false, name="PERCENTUAL_EFICIENCIA", precision=15, scale=2)
    public Double getPercentualEficiencia() {
        return this.percentualEficiencia;
    }

    public void setPercentualEficiencia(Double indiceEficiencia) {
        this.percentualEficiencia = indiceEficiencia;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOEDA_MAT_PRIMA", foreignKey=@ForeignKey(name="FK_PLANEJ_V_PROD_MOEDA_MAT_PRIM"))
    public Moeda getMoedaMatPrima() {
        return this.moedaMatPrima;
    }

    public void setMoedaMatPrima(Moeda moedaMatPrima) {
        this.moedaMatPrima = moedaMatPrima;
    }

    @Column(nullable=false, name="CARREGAR_TAB_PRECOS_MAT_PR")
    public Short getCarregarTabPrecosMatPrima() {
        return this.carregarTabPrecosMatPrima;
    }

    public void setCarregarTabPrecosMatPrima(Short carregarTabPrecosMatPrima) {
        this.carregarTabPrecosMatPrima = carregarTabPrecosMatPrima;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

