/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.GrupoAtendPedidoAlmox;
import com.touchcomp.basementor.model.vo.GrupoAtendPedidoAlmoxPreFatTransf;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.PreFaturamentoNFItem;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaGC;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PRE_FAT_NF")
public class PreFaturamentoNF
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Date dataEmissao;
    private Date dataSaida;
    private NaturezaOperacao naturezaOperacao;
    private UnidadeFatCliente unidadeFatCliente;
    private List<PreFaturamentoNFItem> itens = new ArrayList<PreFaturamentoNFItem>();
    private CondicoesPagamento condicoesPagamento;
    private Empresa empresa;
    private NotaFiscalPropria notaFiscalPropria;
    private SituacaoDocumento situacaoDocumento;
    private List<ComunicadoProducao> comunicadosProducao;
    private List<GrupoAtendPedidoAlmox> grupoAtendPedidoAlmox = new ArrayList<GrupoAtendPedidoAlmox>();
    private List<TransferenciaCentroEstoque> transfCentroEst;
    private List<RelacionamentoPessoaGC> relacionamentosPessoaGC;
    private String observacao;
    private Short tipoPesqValorUnitario = 0;
    private TabelaPrecoBase tabelaPrecoBase;
    private GrupoAtendPedidoAlmoxPreFatTransf grupoAtendPedAlmoxPrefFatTransf;
    private Expedicao expedicao;

    public PreFaturamentoNF() {
        this.comunicadosProducao = new ArrayList<ComunicadoProducao>();
        this.transfCentroEst = new ArrayList<TransferenciaCentroEstoque>();
        this.relacionamentosPessoaGC = new ArrayList<RelacionamentoPessoaGC>();
    }

    @Id
    @Column(name="ID_PRE_FAT_NF")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PRE_FAT_NF")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="DATA_EMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Column(nullable=false, name="DATA_SAIDA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataSaida() {
        return this.dataSaida;
    }

    public void setDataSaida(Date dataSaida) {
        this.dataSaida = dataSaida;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_PRE_FAT_NF_NAT_OPERACAP"))
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_UNID_FAT_CLIENTE", foreignKey=@ForeignKey(name="FK_PRE_FAT_NF_UNID_FAT_CLIENTE"))
    public UnidadeFatCliente getUnidadeFatCliente() {
        return this.unidadeFatCliente;
    }

    public void setUnidadeFatCliente(UnidadeFatCliente unidadeFatCliente) {
        this.unidadeFatCliente = unidadeFatCliente;
    }

    @OneToMany(mappedBy="preFaturamentoNF")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<PreFaturamentoNFItem> getItens() {
        return this.itens;
    }

    public void setItens(List<PreFaturamentoNFItem> itens) {
        this.itens = itens;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_COND_PAGAMENTO", foreignKey=@ForeignKey(name="FK_PRE_FAT_NF_COND_PAGAMENTO"))
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PRE_FAT_NF_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToOne(mappedBy="preFaturamentoNF", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public NotaFiscalPropria getNotaFiscalPropria() {
        return this.notaFiscalPropria;
    }

    public void setNotaFiscalPropria(NotaFiscalPropria notaFiscalPropria) {
        this.notaFiscalPropria = notaFiscalPropria;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_SITUACAO_DOCUMENTO", foreignKey=@ForeignKey(name="FK_PRE_FAT_NF_SIT_DOCUMENTO"))
    public SituacaoDocumento getSituacaoDocumento() {
        return this.situacaoDocumento;
    }

    public void setSituacaoDocumento(SituacaoDocumento situacaoDocumento) {
        this.situacaoDocumento = situacaoDocumento;
    }

    @OneToMany(mappedBy="preFaturamentoNF")
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    public List<ComunicadoProducao> getComunicadosProducao() {
        return this.comunicadosProducao;
    }

    public void setComunicadosProducao(List<ComunicadoProducao> comunicadosProducao) {
        this.comunicadosProducao = comunicadosProducao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), ToolDate.dateToStr((Date)this.getDataEmissao())});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(nullable=false, name="TIPO_PESQ_VALOR_UNITARIO")
    public Short getTipoPesqValorUnitario() {
        return this.tipoPesqValorUnitario;
    }

    public void setTipoPesqValorUnitario(Short tipoPesqValorUnitario) {
        this.tipoPesqValorUnitario = tipoPesqValorUnitario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TAB_PRECO_BASE", foreignKey=@ForeignKey(name="FK_PRE_FAT_NF_TAB_PR_BASE"))
    public TabelaPrecoBase getTabelaPrecoBase() {
        return this.tabelaPrecoBase;
    }

    public void setTabelaPrecoBase(TabelaPrecoBase tabelaPrecoBase) {
        this.tabelaPrecoBase = tabelaPrecoBase;
    }

    @OneToMany(mappedBy="preFaturamentoNF")
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    public List<TransferenciaCentroEstoque> getTransfCentroEst() {
        return this.transfCentroEst;
    }

    public void setTransfCentroEst(List<TransferenciaCentroEstoque> transfCentroEst) {
        this.transfCentroEst = transfCentroEst;
    }

    @OneToMany(mappedBy="preFaturamentoNF")
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    public List<GrupoAtendPedidoAlmox> getGrupoAtendPedidoAlmox() {
        return this.grupoAtendPedidoAlmox;
    }

    public void setGrupoAtendPedidoAlmox(List<GrupoAtendPedidoAlmox> grupoAtendPedidoAlmox) {
        this.grupoAtendPedidoAlmox = grupoAtendPedidoAlmox;
    }

    @OneToMany(mappedBy="preFaturamentoNF")
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE})
    public List<RelacionamentoPessoaGC> getRelacionamentosPessoaGC() {
        return this.relacionamentosPessoaGC;
    }

    public void setRelacionamentosPessoaGC(List<RelacionamentoPessoaGC> relacionamentosPessoaGC) {
        this.relacionamentosPessoaGC = relacionamentosPessoaGC;
    }

    @OneToOne(mappedBy="preFaturamentoNF")
    public GrupoAtendPedidoAlmoxPreFatTransf getGrupoAtendPedAlmoxPrefFatTransf() {
        return this.grupoAtendPedAlmoxPrefFatTransf;
    }

    public void setGrupoAtendPedAlmoxPrefFatTransf(GrupoAtendPedidoAlmoxPreFatTransf grupoAtendPedAlmoxPrefFatTransf) {
        this.grupoAtendPedAlmoxPrefFatTransf = grupoAtendPedAlmoxPrefFatTransf;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="ID_EXPEDICAO")
    public Expedicao getExpedicao() {
        return this.expedicao;
    }

    public void setExpedicao(Expedicao expedicao) {
        this.expedicao = expedicao;
    }
}

