/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoMarketing;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PrioridadeMarketing;
import com.touchcomp.basementor.model.vo.ProcedenciaSolicitacaoClassificacaoMarketing;
import com.touchcomp.basementor.model.vo.ProcedenciaSolicitacaoSetorUsuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PROCEDENCIA_SOLICITACAO")
public class ProcedenciaSolicitacao
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Short assistenciaTecnica = 0;
    private String assuntoSugerido;
    private String solucaoSugerido;
    private ClassificacaoMarketing classificacaoMarketing;
    private PrioridadeMarketing prioridadeMarketing;
    private Short solucionarAtend = 0;
    private List<ProcedenciaSolicitacaoSetorUsuario> procedenciaSolicitacaoSetorUsuario = new ArrayList<ProcedenciaSolicitacaoSetorUsuario>();
    private List<ProcedenciaSolicitacaoClassificacaoMarketing> procedenciaSolicitacaoClassificacaoMarketing = new ArrayList<ProcedenciaSolicitacaoClassificacaoMarketing>();

    @Id
    @Column(nullable=false, name="ID_PROCEDENCIA_SOLICITACAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PROCEDENCIA_SOLICITACAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, unique=true, name="NOME", length=40)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PROCEDENCIA_SOLICITACAO_1"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empreasa) {
        this.empresa = empreasa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="ASSISTENCIA_TECNICA")
    public Short getAssistenciaTecnica() {
        return this.assistenciaTecnica;
    }

    public void setAssistenciaTecnica(Short assistenciaTecnica) {
        this.assistenciaTecnica = assistenciaTecnica;
    }

    @Column(name="ASSUNTO_SUGERIDO", length=1000)
    public String getAssuntoSugerido() {
        return this.assuntoSugerido;
    }

    public void setAssuntoSugerido(String assuntoSugerido) {
        this.assuntoSugerido = assuntoSugerido;
    }

    @Column(name="SOLUCAO_SUGERIDA", length=1000)
    public String getSolucaoSugerido() {
        return this.solucaoSugerido;
    }

    public void setSolucaoSugerido(String solucaoSugerido) {
        this.solucaoSugerido = solucaoSugerido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_MARKETING", foreignKey=@ForeignKey(name="FK_PROC_SOLICITACAO_CLASS_MARK"))
    public ClassificacaoMarketing getClassificacaoMarketing() {
        return this.classificacaoMarketing;
    }

    public void setClassificacaoMarketing(ClassificacaoMarketing classificacaoMarketing) {
        this.classificacaoMarketing = classificacaoMarketing;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRIORIDADE_MARKETING", foreignKey=@ForeignKey(name="FK_PROC_SOLICITACAO_PRIO_MARK"))
    public PrioridadeMarketing getPrioridadeMarketing() {
        return this.prioridadeMarketing;
    }

    public void setPrioridadeMarketing(PrioridadeMarketing prioridadeMarketing) {
        this.prioridadeMarketing = prioridadeMarketing;
    }

    @Column(name="SOLUCIONAR_ATENDIMENTO")
    public Short getSolucionarAtend() {
        return this.solucionarAtend;
    }

    public void setSolucionarAtend(Short solucionarAtend) {
        this.solucionarAtend = solucionarAtend;
    }

    @OneToMany(mappedBy="procedenciaSolicitacao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ProcedenciaSolicitacaoSetorUsuario> getProcedenciaSolicitacaoSetorUsuario() {
        return this.procedenciaSolicitacaoSetorUsuario;
    }

    public void setProcedenciaSolicitacaoSetorUsuario(List<ProcedenciaSolicitacaoSetorUsuario> procedenciaSolicitacaoSetorUsuario) {
        this.procedenciaSolicitacaoSetorUsuario = procedenciaSolicitacaoSetorUsuario;
    }

    @OneToMany(mappedBy="procedenciaSolicitacao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ProcedenciaSolicitacaoClassificacaoMarketing> getProcedenciaSolicitacaoClassificacaoMarketing() {
        return this.procedenciaSolicitacaoClassificacaoMarketing;
    }

    public void setProcedenciaSolicitacaoClassificacaoMarketing(List<ProcedenciaSolicitacaoClassificacaoMarketing> procedenciaSolicitacaoClassificacaoMarketing) {
        this.procedenciaSolicitacaoClassificacaoMarketing = procedenciaSolicitacaoClassificacaoMarketing;
    }
}

