/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.DiagnosticoOSAtivoServProc;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PreProcedimento;
import com.touchcomp.basementor.model.vo.ProdutoPrevManutencao;
import com.touchcomp.basementor.model.vo.ServicoProcedimento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="PROCEDIMENTO")
public class Procedimento
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private String descricao;
    private Short executado = 0;
    private List<ProdutoPrevManutencao> produtosPrevisaoManutencao = new ArrayList<ProdutoPrevManutencao>();
    private ServicoProcedimento servicoProcedimento;
    private PreProcedimento preProcedimento;
    private DiagnosticoOSAtivoServProc diagnosticoOSServProc;

    @Id
    @Column(nullable=false, name="ID_PROCEDIMENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PROCEDIMENTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PROCEDIMENTO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DESCRICAO", length=200)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="EXECUTADO")
    public Short getExecutado() {
        return this.executado;
    }

    public void setExecutado(Short executado) {
        this.executado = executado;
    }

    @OneToMany(mappedBy="procedimento", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.MERGE, CascadeType.SAVE_UPDATE, CascadeType.REFRESH, CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<ProdutoPrevManutencao> getProdutosPrevisaoManutencao() {
        return this.produtosPrevisaoManutencao;
    }

    public void setProdutosPrevisaoManutencao(List<ProdutoPrevManutencao> produtosPrevisaoManutencao) {
        this.produtosPrevisaoManutencao = produtosPrevisaoManutencao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SERVICO_PROCEDIMENTO", foreignKey=@ForeignKey(name="FK_PROCEDIMENTO_SERV_PROC"))
    public ServicoProcedimento getServicoProcedimento() {
        return this.servicoProcedimento;
    }

    public void setServicoProcedimento(ServicoProcedimento servicoProcedimento) {
        this.servicoProcedimento = servicoProcedimento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRE_PROCEDIMENTO", foreignKey=@ForeignKey(name="FK_PROCEDIMENTO_PRE_PROC"))
    public PreProcedimento getPreProcedimento() {
        return this.preProcedimento;
    }

    public void setPreProcedimento(PreProcedimento preProcedimento) {
        this.preProcedimento = preProcedimento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DIAGNOSTICO_OS_SERV_PROC", foreignKey=@ForeignKey(name="FK_PROCEDIMENTO_4"))
    public DiagnosticoOSAtivoServProc getDiagnosticoOSServProc() {
        return this.diagnosticoOSServProc;
    }

    public void setDiagnosticoOSServProc(DiagnosticoOSAtivoServProc diagnosticoOSServProc) {
        this.diagnosticoOSServProc = diagnosticoOSServProc;
    }
}

