/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CotacaoMoeda;
import com.touchcomp.basementor.model.vo.DadosContainer;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObservacaoProcessoImportacao;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.ProcessoImportacaoProformeInvoice;
import com.touchcomp.basementor.model.vo.ProcessoImportacaoTitulos;
import com.touchcomp.basementor.model.vo.StatusDocImportacao;
import com.touchcomp.basementor.model.vo.StatusFinanceiroImportacao;
import com.touchcomp.basementor.model.vo.StatusFisicoImportacao;
import com.touchcomp.basementor.model.vo.TipoIntermedioImportacao;
import com.touchcomp.basementor.model.vo.TipoTransporteImportacao;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="PROCESSO_IMPORTACAO")
public class ProcessoImportacao
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private String descricao;
    private Date dataEmbarque;
    private Date dataChegadaPorto;
    private Date dataFabrica;
    private StatusFisicoImportacao statusFisico;
    private StatusFinanceiroImportacao statusFinanceiro;
    private StatusDocImportacao statusDocumentacao;
    private UnidadeFatFornecedor unidadeFatFornecedor;
    private Date dataEncerramento;
    private NotaFiscalPropria nfEntrada;
    private Pessoa despachante;
    private String observacao;
    private String observacaoVinculada;
    private Pessoa ciaMaritima;
    private String navio;
    private String bl;
    private String invoice;
    private String nrDI;
    private Date dataRegistroDI;
    private Double valor = 0.0;
    private Double valorFinal = 0.0;
    private Moeda moeda;
    private CotacaoMoeda cotacaoMoeda;
    private String desembaracoAduaneiro;
    private Date dataDesembaracoAduaneiro;
    private Double valorFRMM = 0.0;
    private List<OrdemCompra> ordensCompra = new ArrayList<OrdemCompra>();
    private TipoIntermedioImportacao tipoIntermedio;
    private TipoTransporteImportacao tipoTransporte;
    private Double valorDolar = 0.0;
    private Double valorDolarEncProcesso = 0.0;
    private UnidadeFederativa uf;
    private List<DadosContainer> dadosContainer = new ArrayList<DadosContainer>();
    private String numeroControle;
    private String referenciaMaritima;
    private List<ProcessoImportacaoTitulos> titulos = new ArrayList<ProcessoImportacaoTitulos>();
    private List<ObservacaoProcessoImportacao> observacaoProcessoImportacao = new ArrayList<ObservacaoProcessoImportacao>();
    private Double faltaNacionalizacao = 0.0;
    private NotaFiscalPropria notaPropria;
    private List<ProcessoImportacaoProformeInvoice> listProformeInvoice = new ArrayList<ProcessoImportacaoProformeInvoice>();

    @Id
    @Column(name="ID_PROCESSO_IMPORTACAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PROCESSO_IMPORTACAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PROCESSO_IMP_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DESCRICAO", length=150)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="DATA_EMBARQUE")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmbarque() {
        return this.dataEmbarque;
    }

    public void setDataEmbarque(Date dataEmbarque) {
        this.dataEmbarque = dataEmbarque;
    }

    @Column(name="DATA_CHEGADA_PORTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataChegadaPorto() {
        return this.dataChegadaPorto;
    }

    public void setDataChegadaPorto(Date dataChegadaPorto) {
        this.dataChegadaPorto = dataChegadaPorto;
    }

    @Column(name="DATA_FABRICA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFabrica() {
        return this.dataFabrica;
    }

    public void setDataFabrica(Date dataFabrica) {
        this.dataFabrica = dataFabrica;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_STATUS_FISICO", foreignKey=@ForeignKey(name="FK_PROCESSO_IMP_STATUS_FISICO"))
    public StatusFisicoImportacao getStatusFisico() {
        return this.statusFisico;
    }

    public void setStatusFisico(StatusFisicoImportacao statusFisico) {
        this.statusFisico = statusFisico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_STATUS_FINANCEIRO", foreignKey=@ForeignKey(name="FK_PROCESSO_IMP_STATUS_FINANC"))
    public StatusFinanceiroImportacao getStatusFinanceiro() {
        return this.statusFinanceiro;
    }

    public void setStatusFinanceiro(StatusFinanceiroImportacao statusFinanceiro) {
        this.statusFinanceiro = statusFinanceiro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_STATUS_DOC", foreignKey=@ForeignKey(name="FK_PROCESSO_IMP_STATUS_DOC"))
    public StatusDocImportacao getStatusDocumentacao() {
        return this.statusDocumentacao;
    }

    public void setStatusDocumentacao(StatusDocImportacao statusDocumentacao) {
        this.statusDocumentacao = statusDocumentacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_FORNECEDOR", foreignKey=@ForeignKey(name="FK_PROCESSO_IMP_UNID_FAT_FORN"))
    public UnidadeFatFornecedor getUnidadeFatFornecedor() {
        return this.unidadeFatFornecedor;
    }

    public void setUnidadeFatFornecedor(UnidadeFatFornecedor unidadeFatFornecedor) {
        this.unidadeFatFornecedor = unidadeFatFornecedor;
    }

    @Column(name="DATA_ENCERRAMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEncerramento() {
        return this.dataEncerramento;
    }

    public void setDataEncerramento(Date dataEncerramento) {
        this.dataEncerramento = dataEncerramento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_DESPACHANTE", foreignKey=@ForeignKey(name="FK_PROCESSO_IMP_PESSOA_DESPACH"))
    public Pessoa getDespachante() {
        return this.despachante;
    }

    public void setDespachante(Pessoa despachante) {
        this.despachante = despachante;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="OBSERVACAO_VINC", length=1000)
    public String getObservacaoVinculada() {
        return this.observacaoVinculada;
    }

    public void setObservacaoVinculada(String observacaoVinculada) {
        this.observacaoVinculada = observacaoVinculada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_CIA_MARITIMA", foreignKey=@ForeignKey(name="FK_PROCESSO_IMP_PESSOA_CIA_MAR"))
    public Pessoa getCiaMaritima() {
        return this.ciaMaritima;
    }

    public void setCiaMaritima(Pessoa ciaMaritima) {
        this.ciaMaritima = ciaMaritima;
    }

    @Column(name="NAVIO", length=100)
    public String getNavio() {
        return this.navio;
    }

    public void setNavio(String navio) {
        this.navio = navio;
    }

    @Column(name="BL", length=50)
    public String getBl() {
        return this.bl;
    }

    public void setBl(String bl) {
        this.bl = bl;
    }

    @Column(name="INVOICE", length=50)
    public String getInvoice() {
        return this.invoice;
    }

    public void setInvoice(String invoice) {
        this.invoice = invoice;
    }

    @Column(name="NR_DI", length=50)
    public String getNrDI() {
        return this.nrDI;
    }

    public void setNrDI(String nrDI) {
        this.nrDI = nrDI;
    }

    @Column(name="DATA_REGISTRO_DI")
    @Temporal(value=TemporalType.DATE)
    public Date getDataRegistroDI() {
        return this.dataRegistroDI;
    }

    public void setDataRegistroDI(Date dataRegistroDI) {
        this.dataRegistroDI = dataRegistroDI;
    }

    @Column(nullable=false, name="VALOR", precision=15, scale=6)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @Column(name="VALOR_FINAL", precision=15, scale=6)
    public Double getValorFinal() {
        return this.valorFinal;
    }

    public void setValorFinal(Double valorFinal) {
        this.valorFinal = valorFinal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOEDA", foreignKey=@ForeignKey(name="FK_PROCESSO_IMP_ID_MOEDA"))
    public Moeda getMoeda() {
        return this.moeda;
    }

    public void setMoeda(Moeda moeda) {
        this.moeda = moeda;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COTACAO_MOEDA", foreignKey=@ForeignKey(name="FK_PROCESSO_IMP_COTACAO_MOEDA"))
    public CotacaoMoeda getCotacaoMoeda() {
        return this.cotacaoMoeda;
    }

    public void setCotacaoMoeda(CotacaoMoeda cotacaoMoeda) {
        this.cotacaoMoeda = cotacaoMoeda;
    }

    @Column(name="DESEMBARACO_ADUANEIRO", length=200)
    public String getDesembaracoAduaneiro() {
        return this.desembaracoAduaneiro;
    }

    public void setDesembaracoAduaneiro(String desembaracoAduaneiro) {
        this.desembaracoAduaneiro = desembaracoAduaneiro;
    }

    @Column(name="DATA_DESEMBARACO_AD")
    @Temporal(value=TemporalType.DATE)
    public Date getDataDesembaracoAduaneiro() {
        return this.dataDesembaracoAduaneiro;
    }

    public void setDataDesembaracoAduaneiro(Date dataDesembaracoAduaneiro) {
        this.dataDesembaracoAduaneiro = dataDesembaracoAduaneiro;
    }

    @Column(nullable=false, name="VALOR_FRMM", precision=15, scale=6)
    public Double getValorFRMM() {
        return this.valorFRMM;
    }

    public void setValorFRMM(Double valorFRMM) {
        this.valorFRMM = valorFRMM;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_FISCAL_PROPRIA", foreignKey=@ForeignKey(name="FK_PROCESSO_IMP_NOTA_PROPRIA"))
    public NotaFiscalPropria getNfEntrada() {
        return this.nfEntrada;
    }

    public void setNfEntrada(NotaFiscalPropria nfEntrada) {
        this.nfEntrada = nfEntrada;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getDescricao() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany
    @JoinTable(name="PROCESSO_IMPORTACAO_ORDEM_COMPR", joinColumns={@JoinColumn(name="ID_PROCESSO_IMPORTACAO")}, inverseJoinColumns={@JoinColumn(name="ID_ORDEM_COMPRA")})
    public List<OrdemCompra> getOrdensCompra() {
        return this.ordensCompra;
    }

    public void setOrdensCompra(List<OrdemCompra> ordensCompra) {
        this.ordensCompra = ordensCompra;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_INTERMEDIO_IMPORTACAO", foreignKey=@ForeignKey(name="FK_PROCESSO_IMP_TIPO_INTERMEDIO"))
    public TipoIntermedioImportacao getTipoIntermedio() {
        return this.tipoIntermedio;
    }

    public void setTipoIntermedio(TipoIntermedioImportacao tipoIntermedio) {
        this.tipoIntermedio = tipoIntermedio;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_TRANSP_IMPORTACAO", foreignKey=@ForeignKey(name="FK_PROCESSO_IMP_TIPO_TRANP"))
    public TipoTransporteImportacao getTipoTransporte() {
        return this.tipoTransporte;
    }

    public void setTipoTransporte(TipoTransporteImportacao tipoTransporte) {
        this.tipoTransporte = tipoTransporte;
    }

    @Column(nullable=false, name="VALOR_DOLAR", precision=15, scale=6)
    public Double getValorDolar() {
        return this.valorDolar;
    }

    public void setValorDolar(Double valorDolar) {
        this.valorDolar = valorDolar;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_ADUANEIRO", foreignKey=@ForeignKey(name="FK_PROCESSO_IMP_UF_ADUANEIRO"))
    public UnidadeFederativa getUf() {
        return this.uf;
    }

    public void setUf(UnidadeFederativa uf) {
        this.uf = uf;
    }

    @OneToMany(mappedBy="processoImportacao", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<DadosContainer> getDadosContainer() {
        return this.dadosContainer;
    }

    public void setDadosContainer(List<DadosContainer> dadosContainer) {
        this.dadosContainer = dadosContainer;
    }

    @Column(nullable=false, name="VALOR_DOLAR_ENC_PROCESSO", precision=15, scale=6)
    public Double getValorDolarEncProcesso() {
        return this.valorDolarEncProcesso;
    }

    public void setValorDolarEncProcesso(Double valorDolarEncProcesso) {
        this.valorDolarEncProcesso = valorDolarEncProcesso;
    }

    @Column(name="NUMERO_CONTROLE", length=20)
    public String getNumeroControle() {
        return this.numeroControle;
    }

    public void setNumeroControle(String numeroControle) {
        this.numeroControle = numeroControle;
    }

    @Column(name="REFERENCIA_MARITIMA", length=14)
    public String getReferenciaMaritima() {
        return this.referenciaMaritima;
    }

    public void setReferenciaMaritima(String referenciaMaritima) {
        this.referenciaMaritima = referenciaMaritima;
    }

    @OneToMany(mappedBy="processoImportacao", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ProcessoImportacaoTitulos> getTitulos() {
        return this.titulos;
    }

    public void setTitulos(List<ProcessoImportacaoTitulos> titulos) {
        this.titulos = titulos;
    }

    @OneToMany(mappedBy="processoImportacao", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ObservacaoProcessoImportacao> getObservacaoProcessoImportacao() {
        return this.observacaoProcessoImportacao;
    }

    public void setObservacaoProcessoImportacao(List<ObservacaoProcessoImportacao> observacaoProcessoImportacao) {
        this.observacaoProcessoImportacao = observacaoProcessoImportacao;
    }

    @Column(nullable=false, name="FALTA_NACIONALIZACAO", precision=15, scale=6)
    public Double getFaltaNacionalizacao() {
        return this.faltaNacionalizacao;
    }

    public void setFaltaNacionalizacao(Double faltaNacionalizacao) {
        this.faltaNacionalizacao = faltaNacionalizacao;
    }

    @OneToOne(mappedBy="processoImportacao", fetch=FetchType.LAZY, targetEntity=NotaFiscalPropria.class)
    public NotaFiscalPropria getNotaPropria() {
        return this.notaPropria;
    }

    public void setNotaPropria(NotaFiscalPropria notaPropria) {
        this.notaPropria = notaPropria;
    }

    @OneToMany(mappedBy="processoImportacao", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ProcessoImportacaoProformeInvoice> getListProformeInvoice() {
        return this.listProformeInvoice;
    }

    public void setListProformeInvoice(List<ProcessoImportacaoProformeInvoice> listProformeInvoice) {
        this.listProformeInvoice = listProformeInvoice;
    }
}

