/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="PRODUTO_GRADE", uniqueConstraints={@UniqueConstraint(name="UNQ1_PRODUTO_GRADE", columnNames={"ID_PRODUTO"})})
public class ProdutoGrade
implements InterfaceVO {
    private Long identificador;
    private Produto produto;
    private List<GradeCor> gradesCores;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Date dataUltModificacao;
    private Empresa empresa;

    public ProdutoGrade() {
        this.gradesCores = new ArrayList<GradeCor>();
    }

    public ProdutoGrade(Long identificador, Produto produto, List<GradeCor> gradesCores) {
        this.identificador = identificador;
        this.produto = produto;
        this.gradesCores = gradesCores;
    }

    @Id
    @Column(nullable=false, name="ID_PRODUTO_GRADE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PRODUTO_GRADE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_PRODUTO_GRADE_PRODUTO"))
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="produtoGrade", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @OrderBy(value="indice")
    public List<GradeCor> getGradesCores() {
        return this.gradesCores;
    }

    public void setGradesCores(List<GradeCor> cores) {
        this.gradesCores = cores;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PRODUTO_GRADE_1"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getProduto()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="DATA_ULT_MODIFICACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataUltModificacao() {
        return this.dataUltModificacao;
    }

    public void setDataUltModificacao(Date dataUltModificacao) {
        this.dataUltModificacao = dataUltModificacao;
    }
}

