/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemProvisaoDissidio;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PROVISAO_DISSIDIO_COLETIVO")
public class ProvisaoDissidioColetivo
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Double indice = 0.0;
    private Date periodoInicial;
    private Date periodoFinal;
    private Short possuiDesoneracao = 0;
    private Double percDesoneracao = 0.0;
    private List<ItemProvisaoDissidio> provisoes = new ArrayList<ItemProvisaoDissidio>();
    private Double aliquotaInss = 0.0;
    private Double aliquotaRat = 0.0;
    private Double aliquotaTerceiros = 0.0;
    private Double aliquotaFgts = 0.0;
    private Double indiceFap = 0.0;

    @Id
    @Column(nullable=false, unique=true, name="ID_PROVISAO_DISSIDIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PROVISAO_DISSIDIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PROVISAO_DISSIDIO_COLETIVO_1"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="INDICE", precision=15, scale=6)
    public Double getIndice() {
        return this.indice;
    }

    public void setIndice(Double indice) {
        this.indice = indice;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO_INICIAL")
    public Date getPeriodoInicial() {
        return this.periodoInicial;
    }

    public void setPeriodoInicial(Date periodoInicial) {
        this.periodoInicial = periodoInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO_FINAL")
    public Date getPeriodoFinal() {
        return this.periodoFinal;
    }

    public void setPeriodoFinal(Date periodoFinal) {
        this.periodoFinal = periodoFinal;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIndice(), ToolDate.dateToStr((Date)this.getPeriodoInicial(), (String)"dd/MM/yyyy")});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="POSSUI_DESONERACAO")
    public Short getPossuiDesoneracao() {
        return this.possuiDesoneracao;
    }

    public void setPossuiDesoneracao(Short possuiDesoneracao) {
        this.possuiDesoneracao = possuiDesoneracao;
    }

    @Column(name="PERC_DESONERACAO", precision=15, scale=4)
    public Double getPercDesoneracao() {
        return this.percDesoneracao;
    }

    public void setPercDesoneracao(Double percDesoneracao) {
        this.percDesoneracao = percDesoneracao;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="provisaoDissidio", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemProvisaoDissidio> getProvisoes() {
        return this.provisoes;
    }

    public void setProvisoes(List<ItemProvisaoDissidio> provisoes) {
        this.provisoes = provisoes;
    }

    @Column(name="ALIQUOTA_INSS", precision=15, scale=4)
    public Double getAliquotaInss() {
        return this.aliquotaInss;
    }

    public void setAliquotaInss(Double aliquotaInss) {
        this.aliquotaInss = aliquotaInss;
    }

    @Column(name="ALIQUOTA_RAT", precision=15, scale=4)
    public Double getAliquotaRat() {
        return this.aliquotaRat;
    }

    public void setAliquotaRat(Double aliquotaRat) {
        this.aliquotaRat = aliquotaRat;
    }

    @Column(nullable=false, name="ALIQUOTA_TERCEIROS", precision=15, scale=4)
    public Double getAliquotaTerceiros() {
        return this.aliquotaTerceiros;
    }

    public void setAliquotaTerceiros(Double aliquotaTerceiros) {
        this.aliquotaTerceiros = aliquotaTerceiros;
    }

    @Column(name="ALIQUOTA_FGTS", precision=15, scale=2)
    public Double getAliquotaFgts() {
        return this.aliquotaFgts;
    }

    public void setAliquotaFgts(Double aliquotaFgts) {
        this.aliquotaFgts = aliquotaFgts;
    }

    @Column(nullable=false, name="INDICE_FAP", precision=15, scale=4)
    public Double getIndiceFap() {
        return this.indiceFap;
    }

    public void setIndiceFap(Double indiceFap) {
        this.indiceFap = indiceFap;
    }
}

