/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.provisao.EnumConsiderarEmpresa;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemProvisaoFerias;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PROVISAO_FERIAS")
public class ProvisaoFerias
implements InterfaceVO {
    private Long identificador;
    private Date periodo;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private List<ItemProvisaoFerias> itensProvisoes = new ArrayList<ItemProvisaoFerias>();
    private LoteContabil loteContabil;
    private Double percDesoneracao = 0.0;
    private List<LancamentoCtbGerencial> lancsGerencial = new ArrayList<LancamentoCtbGerencial>();
    private CentroCusto centroCusto;
    private Short filtrarCentroCusto = 0;
    private Short filtrarEmpresa = 0;
    private Empresa empresaFiltrada;
    private Short considerarEmpresa = EnumConsiderarEmpresa.CONSIDERAR_EMPRESA_COLABORADOR.getEnumId();

    @Id
    @Column(nullable=false, unique=true, name="ID_PROVISAO_FERIAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PROVISAO_FERIAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO")
    public Date getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(Date periodo) {
        this.periodo = periodo;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="provisao", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemProvisaoFerias> getItensProvisoes() {
        return this.itensProvisoes;
    }

    public void setItensProvisoes(List<ItemProvisaoFerias> itensProvisoes) {
        this.itensProvisoes = itensProvisoes;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{" PROVISAO "});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PROVISAO_FERIAS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_CONTABIL", foreignKey=@ForeignKey(name="FK_PROVISAO_FERIAS_LOTE"))
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public LoteContabil getLoteContabil() {
        return this.loteContabil;
    }

    public void setLoteContabil(LoteContabil lote) {
        this.loteContabil = lote;
    }

    @Column(nullable=false, name="PERC_DESONERACAO", precision=15, scale=4)
    public Double getPercDesoneracao() {
        return this.percDesoneracao;
    }

    public void setPercDesoneracao(Double percDesoneracao) {
        this.percDesoneracao = percDesoneracao;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinTable(name="PROVISAO_FERIAS_LANC_GEREN", joinColumns={@JoinColumn(name="ID_PROVISAO_FERIAS")}, inverseJoinColumns={@JoinColumn(name="ID_LANCAMENTO_GERENCIAL")})
    public List<LancamentoCtbGerencial> getLancsGerencial() {
        return this.lancsGerencial;
    }

    public void setLancsGerencial(List<LancamentoCtbGerencial> lancsGerencial) {
        this.lancsGerencial = lancsGerencial;
    }

    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_PROVISAO_FERIAS_CENT_CUST"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @Column(name="FILTRAR_CENTRO_CUSTO")
    public Short getFiltrarCentroCusto() {
        return this.filtrarCentroCusto;
    }

    public void setFiltrarCentroCusto(Short filtrarCentroCusto) {
        this.filtrarCentroCusto = filtrarCentroCusto;
    }

    @Column(name="FILTRAR_EMPRESA")
    public Short getFiltrarEmpresa() {
        return this.filtrarEmpresa;
    }

    public void setFiltrarEmpresa(Short filtrarEmpresa) {
        this.filtrarEmpresa = filtrarEmpresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA_FILTRADA", foreignKey=@ForeignKey(name="FK_PROVISAO_FERIAS_EMPRESA_FILT"))
    public Empresa getEmpresaFiltrada() {
        return this.empresaFiltrada;
    }

    public void setEmpresaFiltrada(Empresa empresaFiltrada) {
        this.empresaFiltrada = empresaFiltrada;
    }

    @Column(name="CONSIDERAR_EMPRESA")
    public Short getConsiderarEmpresa() {
        return this.considerarEmpresa;
    }

    public void setConsiderarEmpresa(Short considerarEmpresa) {
        this.considerarEmpresa = considerarEmpresa;
    }
}

