/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.rh.EnumTipoContrato;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocCategoriaTrabalhador;
import com.touchcomp.basementor.model.vo.EsocNaturezaAtividade;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.TipoSalario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="REGISTRO_ADMISSAO_PRELIMINAR")
public class RegistroAdmissaoPreLiminar
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private String cpf;
    private Date dataNascimento;
    private Date dataAdmissao;
    private String nome;
    private String matricula;
    private EsocCategoriaTrabalhador esocCategoria;
    private EsocNaturezaAtividade naturezaAtividade;
    private Funcao funcao;
    private Double salario = 0.0;
    private TipoSalario tipoSalario;
    private Short tipoContrato;
    private Date dataTermino;
    private List<EsocPreEvento> preEventosEsocial = new ArrayList<EsocPreEvento>();

    public RegistroAdmissaoPreLiminar() {
        this.tipoContrato = EnumTipoContrato.INDETERMINADO.value;
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_ADMISSAO_PRELIMINAR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ADMISSAO_PRELIMINAR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ADMISSAO_PRELIMINAR_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="CPF", length=14)
    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    @Column(name="DATA_NASCIMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(Date dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    @Column(name="DATA_ADMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataAdmissao() {
        return this.dataAdmissao;
    }

    public void setDataAdmissao(Date dataAdmissao) {
        this.dataAdmissao = dataAdmissao;
    }

    @Override
    @OneToMany(mappedBy="admissaoPreLiminar")
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    @Column(name="NOME", length=100)
    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="matricula", length=255)
    public String getMatricula() {
        return this.matricula;
    }

    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_esoc_categoria_trabalhador")
    public EsocCategoriaTrabalhador getEsocCategoria() {
        return this.esocCategoria;
    }

    public void setEsocCategoria(EsocCategoriaTrabalhador esocCategoria) {
        this.esocCategoria = esocCategoria;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_natureza")
    public EsocNaturezaAtividade getNaturezaAtividade() {
        return this.naturezaAtividade;
    }

    public void setNaturezaAtividade(EsocNaturezaAtividade naturezaAtividade) {
        this.naturezaAtividade = naturezaAtividade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_funcao")
    public Funcao getFuncao() {
        return this.funcao;
    }

    public void setFuncao(Funcao funcao) {
        this.funcao = funcao;
    }

    @Column(name="salario")
    public Double getSalario() {
        return this.salario;
    }

    public void setSalario(Double salario) {
        this.salario = salario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_salario")
    public TipoSalario getTipoSalario() {
        return this.tipoSalario;
    }

    public void setTipoSalario(TipoSalario tipoSalario) {
        this.tipoSalario = tipoSalario;
    }

    @Column(name="tipo_contrato")
    public Short getTipoContrato() {
        return this.tipoContrato;
    }

    public void setTipoContrato(Short tipoContrato) {
        this.tipoContrato = tipoContrato;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="data_termino")
    public Date getDataTermino() {
        return this.dataTermino;
    }

    public void setDataTermino(Date dataTermino) {
        this.dataTermino = dataTermino;
    }
}

