/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocCadastroEstabelcimento;
import com.touchcomp.basementor.model.vo.EsocClienteProducaoRural;
import com.touchcomp.basementor.model.vo.EsocFornecedorProducaoRural;
import com.touchcomp.basementor.model.vo.ReinfIndAquisicaoProdRural;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="reinf_aquisicao_prod_rural")
public class ReinfAquisicaoProdRural
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualiazacao;
    private Date periodoReferencia;
    private EsocCadastroEstabelcimento estabelecimento;
    private ReinfIndAquisicaoProdRural indicativoProdRural;
    private List<EsocFornecedorProducaoRural> fornecedorProdRural = new ArrayList<EsocFornecedorProducaoRural>();
    private List<EsocClienteProducaoRural> clienteProdRural;
    private List<ReinfPreEvento> preEventosReinf = new ArrayList<ReinfPreEvento>();

    public ReinfAquisicaoProdRural() {
        this.clienteProdRural = new ArrayList<EsocClienteProducaoRural>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_REINF_AQ_PROD_RURAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_REINF_AQ_PROD_RURAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EMPRESA_REINF_AQ_PROD_RURAL"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualiazacao() {
        return this.dataAtualiazacao;
    }

    public void setDataAtualiazacao(Timestamp dataAtualiazacao) {
        this.dataAtualiazacao = dataAtualiazacao;
    }

    @Column(name="PERIODO_REFERENCIA")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoReferencia() {
        return this.periodoReferencia;
    }

    public void setPeriodoReferencia(Date periodoReferencia) {
        this.periodoReferencia = periodoReferencia;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_CADASTRO_ESTAB", foreignKey=@ForeignKey(name="FK_REINF_CAD_ESTABELECIMENTO"))
    public EsocCadastroEstabelcimento getEstabelecimento() {
        return this.estabelecimento;
    }

    public void setEstabelecimento(EsocCadastroEstabelcimento estabelecimento) {
        this.estabelecimento = estabelecimento;
    }

    @OneToMany(mappedBy="reinfAquisicao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<EsocFornecedorProducaoRural> getFornecedorProdRural() {
        return this.fornecedorProdRural;
    }

    public void setFornecedorProdRural(List<EsocFornecedorProducaoRural> fornecedorProdRural) {
        this.fornecedorProdRural = fornecedorProdRural;
    }

    @OneToMany(mappedBy="reinfAquisicao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<EsocClienteProducaoRural> getClienteProdRural() {
        return this.clienteProdRural;
    }

    public void setClienteProdRural(List<EsocClienteProducaoRural> clienteProdRural) {
        this.clienteProdRural = clienteProdRural;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REINF_IND_AQ_PROD_RURAL", foreignKey=@ForeignKey(name="FK_REINF_IND_AQ_PROD_RURAL"))
    public ReinfIndAquisicaoProdRural getIndicativoProdRural() {
        return this.indicativoProdRural;
    }

    public void setIndicativoProdRural(ReinfIndAquisicaoProdRural indicativoProdRural) {
        this.indicativoProdRural = indicativoProdRural;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

