/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ReinfCodAtividadeEconomica;
import com.touchcomp.basementor.model.vo.ReinfR2060;
import com.touchcomp.basementor.model.vo.ReinfR2060Ajuste;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="REINF_R_2060_ITEM")
public class ReinfR2060Item
implements InterfaceVO {
    private Long identificador;
    private ReinfR2060 r2060;
    private ReinfCodAtividadeEconomica reinfCodAtividadeEconomica;
    private Double valorReceitaBrutaAtiva = 0.0;
    private Double valorReceitaBrutaExclusao = 0.0;
    private Double valorReceitaBrutaAdicional = 0.0;
    private Double valorBCContribPrev = 0.0;
    private Double valorContribPrev = 0.0;
    private List<ReinfR2060Ajuste> ajustes = new ArrayList<ReinfR2060Ajuste>();

    @Id
    @Column(nullable=false, unique=true, name="ID_REINF_R_2060_ITEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_REINF_R_2060_ITEM")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_REINF_R_2060", foreignKey=@ForeignKey(name="FK_REINF_R_2060_ITEM_R_2060"))
    public ReinfR2060 getR2060() {
        return this.r2060;
    }

    public void setR2060(ReinfR2060 r2060) {
        this.r2060 = r2060;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REINF_COD_ATIVIDADE_ECON", foreignKey=@ForeignKey(name="FK_REINF_R_2060_ITEM_COD_AT_EC"))
    public ReinfCodAtividadeEconomica getReinfCodAtividadeEconomica() {
        return this.reinfCodAtividadeEconomica;
    }

    public void setReinfCodAtividadeEconomica(ReinfCodAtividadeEconomica reinfCodAtividadeEconomica) {
        this.reinfCodAtividadeEconomica = reinfCodAtividadeEconomica;
    }

    @Column(name="VALOR_RECEITA_BRUTA_ATIVA", precision=15, scale=2)
    public Double getValorReceitaBrutaAtiva() {
        return this.valorReceitaBrutaAtiva;
    }

    public void setValorReceitaBrutaAtiva(Double valorReceitaBrutaAtiva) {
        this.valorReceitaBrutaAtiva = valorReceitaBrutaAtiva;
    }

    @Column(name="VALOR_RECEITA_BRUTA_EXCLUSAO", precision=15, scale=2)
    public Double getValorReceitaBrutaExclusao() {
        return this.valorReceitaBrutaExclusao;
    }

    public void setValorReceitaBrutaExclusao(Double valorReceitaBrutaExclusao) {
        this.valorReceitaBrutaExclusao = valorReceitaBrutaExclusao;
    }

    @Column(name="VALOR_RECEITA_BRUTA_ADIC", precision=15, scale=2)
    public Double getValorReceitaBrutaAdicional() {
        return this.valorReceitaBrutaAdicional;
    }

    public void setValorReceitaBrutaAdicional(Double valorReceitaBrutaAdicional) {
        this.valorReceitaBrutaAdicional = valorReceitaBrutaAdicional;
    }

    @Column(name="VALOR_BC_CONTRIB_PREV", precision=15, scale=2)
    public Double getValorBCContribPrev() {
        return this.valorBCContribPrev;
    }

    public void setValorBCContribPrev(Double valorBCContribPrev) {
        this.valorBCContribPrev = valorBCContribPrev;
    }

    @Column(name="VALOR_CONTRIB_PREV", precision=15, scale=2)
    public Double getValorContribPrev() {
        return this.valorContribPrev;
    }

    public void setValorContribPrev(Double valorContribPrev) {
        this.valorContribPrev = valorContribPrev;
    }

    @OneToMany(mappedBy="r2060Item", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ReinfR2060Ajuste> getAjustes() {
        return this.ajustes;
    }

    public void setAjustes(List<ReinfR2060Ajuste> ajustes) {
        this.ajustes = ajustes;
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }
}

