/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ArquivamentoDoc;
import com.touchcomp.basementor.model.vo.CheckList;
import com.touchcomp.basementor.model.vo.ClassificacaoMarketing;
import com.touchcomp.basementor.model.vo.EmailEnviadoRelPessoa;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemInfAdicionalItemRelPes;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PessoasInteressadasRelPessoa;
import com.touchcomp.basementor.model.vo.PrioridadeMarketing;
import com.touchcomp.basementor.model.vo.ProcedenciaSolicitacao;
import com.touchcomp.basementor.model.vo.ProspeccaoPessoasEvt;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaAgEmail;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaGC;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaItem;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaItemNotaPropria;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaLog;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaRps;
import com.touchcomp.basementor.model.vo.SetorUsuario;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="RELACIONAMENTO_PESSOA", uniqueConstraints={@UniqueConstraint(name="UNQ1_RELACIONAMENTO_PESSOA", columnNames={"NR_PROTOCOLO"})})
public class RelacionamentoPessoa
implements InterfaceVO {
    private Long identificador;
    private Usuario usuario;
    private String assunto;
    private String solucao;
    private ProcedenciaSolicitacao procedenciaSolicitacao;
    private Double valorPerda = 0.0;
    private Double valorReembolso = 0.0;
    private Short agendamento = 0;
    private Short enviadoEmailCadastro = 0;
    private Short enviadoEmailAgendamento = 0;
    private Short enviadoEmailSolucao = 0;
    private Pessoa pessoa;
    private Date dataSolucao;
    private Usuario usuarioSolucao;
    private Usuario usuarioAgendamento;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Date dataRelacionamento;
    private Empresa empresa;
    private Short solucionado = 0;
    private EmailPessoa emailContato;
    private ClassificacaoMarketing classificacaoMarketing;
    private List<RelacionamentoPessoaLog> agendamentos;
    private List<RelacionamentoPessoaItemNotaPropria> itensNotaPropria;
    private List<RelacionamentoPessoaItemNotaTerceiros> itensNotaTerceiros;
    private List<RelacionamentoPessoaGC> produtos;
    private String origemRel;
    private List<ItemInfAdicionalItemRelPes> itensInfAdicional;
    private List<EmailEnviadoRelPessoa> emailsEnviados = new ArrayList<EmailEnviadoRelPessoa>();
    private Long nrProtocolo;
    private SetorUsuario setor;
    private ArquivamentoDoc arquivamentoDoc;
    private ProspeccaoPessoasEvt eventoProspeccao;
    private PrioridadeMarketing prioridadeMarketing;
    private CheckList checkList;
    private List<RelacionamentoPessoaItem> itensTarefasRel;
    private Short agendarEnvioEmail = 0;
    private RelacionamentoPessoaAgEmail relacionamentoPessoaAgEmail;
    private Date dataPrevistaSol;
    private Date dataPrevistaSolInterna;
    private String emailsEnviadosPara;
    private List<PessoasInteressadasRelPessoa> pessoasInteressadas;
    private List<RelacionamentoPessoaRps> rps;

    public RelacionamentoPessoa() {
        this.itensInfAdicional = new ArrayList<ItemInfAdicionalItemRelPes>();
        this.produtos = new ArrayList<RelacionamentoPessoaGC>();
        this.itensNotaTerceiros = new ArrayList<RelacionamentoPessoaItemNotaTerceiros>();
        this.itensNotaPropria = new ArrayList<RelacionamentoPessoaItemNotaPropria>();
        this.agendamentos = new ArrayList<RelacionamentoPessoaLog>();
        this.itensTarefasRel = new ArrayList<RelacionamentoPessoaItem>();
        this.pessoasInteressadas = new ArrayList<PessoasInteressadasRelPessoa>();
        this.rps = new ArrayList<RelacionamentoPessoaRps>();
    }

    @Id
    @Column(nullable=false, name="ID_RELACIONAMENTO_PESSOA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_RELACIONAMENTO_PESSOA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_RELACIONAMENTO_P_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Column(name="ASSUNTO", length=5000)
    public String getAssunto() {
        return this.assunto;
    }

    public void setAssunto(String assunto) {
        this.assunto = assunto;
    }

    @Column(name="SOLUCAO", length=5000)
    public String getSolucao() {
        return this.solucao;
    }

    public void setSolucao(String solucao) {
        this.solucao = solucao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PROCEDENCIA_SOLICITACAO", foreignKey=@ForeignKey(name="FK_RELACIONAMENTO_P_PROC_SOLICI"))
    public ProcedenciaSolicitacao getProcedenciaSolicitacao() {
        return this.procedenciaSolicitacao;
    }

    public void setProcedenciaSolicitacao(ProcedenciaSolicitacao procedenciaSolicitacao) {
        this.procedenciaSolicitacao = procedenciaSolicitacao;
    }

    @Column(name="VALOR_PERDA", precision=12, scale=2)
    public Double getValorPerda() {
        return this.valorPerda;
    }

    public void setValorPerda(Double valorPerda) {
        this.valorPerda = valorPerda;
    }

    @Column(nullable=false, name="VALOR_REEMBOLSO", precision=12, scale=2)
    public Double getValorReembolso() {
        return this.valorReembolso;
    }

    public void setValorReembolso(Double valorReembolso) {
        this.valorReembolso = valorReembolso;
    }

    @Column(name="AGENDADO")
    public Short getAgendamento() {
        return this.agendamento;
    }

    public void setAgendamento(Short agendamento) {
        this.agendamento = agendamento;
    }

    @Column(name="DATA_SOLUCAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataSolucao() {
        return this.dataSolucao;
    }

    public void setDataSolucao(Date dataSolucao) {
        this.dataSolucao = dataSolucao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_SOLUCAO", foreignKey=@ForeignKey(name="FK_RELACIONAMENTO_P_US_SOLUCAO"))
    public Usuario getUsuarioSolucao() {
        return this.usuarioSolucao;
    }

    public void setUsuarioSolucao(Usuario usuarioSolucao) {
        this.usuarioSolucao = usuarioSolucao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_AGENDADO", foreignKey=@ForeignKey(name="FK_RELACIONAMENTO_P_US_AGENDAME"))
    public Usuario getUsuarioAgendamento() {
        return this.usuarioAgendamento;
    }

    public void setUsuarioAgendamento(Usuario usuarioAgendamento) {
        this.usuarioAgendamento = usuarioAgendamento;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_RELACIONAMENTO_P_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_RELACIONAMENTO")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getDataRelacionamento() {
        return this.dataRelacionamento;
    }

    public void setDataRelacionamento(Date dataRelacionamento) {
        this.dataRelacionamento = dataRelacionamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_RELACIONAMENTO_P_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Id.:{0} Pessoa: {1}", (Object[])new Object[]{this.getIdentificador(), this.getPessoa() != null ? this.getPessoa().getNome() : this.getPessoa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="SOLUCIONADO")
    public Short getSolucionado() {
        return this.solucionado;
    }

    public void setSolucionado(Short solucionado) {
        this.solucionado = solucionado;
    }

    @Column(name="ENVIADO_EMAIL_CADASTRO")
    public Short getEnviadoEmailCadastro() {
        return this.enviadoEmailCadastro;
    }

    public void setEnviadoEmailCadastro(Short enviadoEmailCadastro) {
        this.enviadoEmailCadastro = enviadoEmailCadastro;
    }

    @Column(name="ENVIADO_EMAIL_AGEND")
    public Short getEnviadoEmailAgendamento() {
        return this.enviadoEmailAgendamento;
    }

    public void setEnviadoEmailAgendamento(Short enviadoEmailAgendamento) {
        this.enviadoEmailAgendamento = enviadoEmailAgendamento;
    }

    @Column(name="ENVIADO_EMAIL_SOLUCAO")
    public Short getEnviadoEmailSolucao() {
        return this.enviadoEmailSolucao;
    }

    public void setEnviadoEmailSolucao(Short enviadoEmailSolucao) {
        this.enviadoEmailSolucao = enviadoEmailSolucao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMAIL_CONTATO", foreignKey=@ForeignKey(name="FK_RELACIONAMENTO_P_EMAIL_CONTA"))
    public EmailPessoa getEmailContato() {
        return this.emailContato;
    }

    public void setEmailContato(EmailPessoa emailContato) {
        this.emailContato = emailContato;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_MARKETING", foreignKey=@ForeignKey(name="FK_RELACIONAMENTO_P_CLAS_MARKET"))
    public ClassificacaoMarketing getClassificacaoMarketing() {
        return this.classificacaoMarketing;
    }

    public void setClassificacaoMarketing(ClassificacaoMarketing classificacaoMarketing) {
        this.classificacaoMarketing = classificacaoMarketing;
    }

    @OneToMany(mappedBy="relacionamentoPessoa")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<RelacionamentoPessoaLog> getAgendamentos() {
        return this.agendamentos;
    }

    public void setAgendamentos(List<RelacionamentoPessoaLog> agendamentos) {
        this.agendamentos = agendamentos;
    }

    @OneToMany(mappedBy="relacionamentoPessoa", fetch=FetchType.LAZY)
    public List<RelacionamentoPessoaItemNotaPropria> getItensNotaPropria() {
        return this.itensNotaPropria;
    }

    public void setItensNotaPropria(List<RelacionamentoPessoaItemNotaPropria> itensNotaPropria) {
        this.itensNotaPropria = itensNotaPropria;
    }

    @OneToMany(mappedBy="relacionamentoPessoa", fetch=FetchType.LAZY)
    public List<RelacionamentoPessoaItemNotaTerceiros> getItensNotaTerceiros() {
        return this.itensNotaTerceiros;
    }

    public void setItensNotaTerceiros(List<RelacionamentoPessoaItemNotaTerceiros> itensNotaTerceiros) {
        this.itensNotaTerceiros = itensNotaTerceiros;
    }

    @Column(name="ORIGEM_RELACIONAMENTO", length=5000)
    public String getOrigemRel() {
        return this.origemRel;
    }

    public void setOrigemRel(String origemRel) {
        this.origemRel = origemRel;
    }

    @OneToMany(mappedBy="relacionamentoPessoa", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<RelacionamentoPessoaGC> getProdutos() {
        return this.produtos;
    }

    public void setProdutos(List<RelacionamentoPessoaGC> produtos) {
        this.produtos = produtos;
    }

    @OneToMany(mappedBy="relacionamentoPessoa", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemInfAdicionalItemRelPes> getItensInfAdicional() {
        return this.itensInfAdicional;
    }

    public void setItensInfAdicional(List<ItemInfAdicionalItemRelPes> itensInfAdicional) {
        this.itensInfAdicional = itensInfAdicional;
    }

    @OneToMany(mappedBy="relacionamentoPessoa", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<EmailEnviadoRelPessoa> getEmailsEnviados() {
        return this.emailsEnviados;
    }

    public void setEmailsEnviados(List<EmailEnviadoRelPessoa> emailsEnviados) {
        this.emailsEnviados = emailsEnviados;
    }

    @Ignore
    @Column(name="NR_PROTOCOLO")
    public Long getNrProtocolo() {
        return this.nrProtocolo;
    }

    public void setNrProtocolo(Long nrProtocolo) {
        this.nrProtocolo = nrProtocolo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SETOR", foreignKey=@ForeignKey(name="FK_RELACIONAMENTO_P_SETOR"))
    public SetorUsuario getSetor() {
        return this.setor;
    }

    public void setSetor(SetorUsuario setor) {
        this.setor = setor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ARQUIVAMENTO_DOC", foreignKey=@ForeignKey(name="FK_RELACIONAMENTO_P_ARQ_DOC"))
    public ArquivamentoDoc getArquivamentoDoc() {
        return this.arquivamentoDoc;
    }

    public void setArquivamentoDoc(ArquivamentoDoc arquivamentoDoc) {
        this.arquivamentoDoc = arquivamentoDoc;
    }

    @OneToOne(mappedBy="relacionamentoPessoa")
    public ProspeccaoPessoasEvt getEventoProspeccao() {
        return this.eventoProspeccao;
    }

    public void setEventoProspeccao(ProspeccaoPessoasEvt eventoProspeccao) {
        this.eventoProspeccao = eventoProspeccao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRIORIDADE_MARKETING", foreignKey=@ForeignKey(name="FK_REL_PESSOA_PRIORIDADE_MARKET"))
    public PrioridadeMarketing getPrioridadeMarketing() {
        return this.prioridadeMarketing;
    }

    public void setPrioridadeMarketing(PrioridadeMarketing prioridadeMarketing) {
        this.prioridadeMarketing = prioridadeMarketing;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CHECK_LIST", foreignKey=@ForeignKey(name="FK_REL_PESSOA_CHECK_LIST"))
    public CheckList getCheckList() {
        return this.checkList;
    }

    public void setCheckList(CheckList checkList) {
        this.checkList = checkList;
    }

    @OneToMany(mappedBy="relacionamentoPessoa", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<RelacionamentoPessoaItem> getItensTarefasRel() {
        return this.itensTarefasRel;
    }

    public void setItensTarefasRel(List<RelacionamentoPessoaItem> itensTarefasRel) {
        this.itensTarefasRel = itensTarefasRel;
    }

    @Column(name="AGENDAR_ENVIO_EMAIL")
    public Short getAgendarEnvioEmail() {
        return this.agendarEnvioEmail;
    }

    public void setAgendarEnvioEmail(Short agendarEnvioEmail) {
        this.agendarEnvioEmail = agendarEnvioEmail;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REL_PESSOA_AG_EMAIL", foreignKey=@ForeignKey(name="FK_REL_PESSOA_REL_PES_AG_EMAIL"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public RelacionamentoPessoaAgEmail getRelacionamentoPessoaAgEmail() {
        return this.relacionamentoPessoaAgEmail;
    }

    public void setRelacionamentoPessoaAgEmail(RelacionamentoPessoaAgEmail relacionamentoPessoaAgEmail) {
        this.relacionamentoPessoaAgEmail = relacionamentoPessoaAgEmail;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_PREVISTA_SOL")
    public Date getDataPrevistaSol() {
        return this.dataPrevistaSol;
    }

    public void setDataPrevistaSol(Date dataPrevistaSol) {
        this.dataPrevistaSol = dataPrevistaSol;
    }

    @OneToMany(mappedBy="relacionamentoPessoa", fetch=FetchType.LAZY)
    public List<RelacionamentoPessoaRps> getRps() {
        return this.rps;
    }

    public void setRps(List<RelacionamentoPessoaRps> rps) {
        this.rps = rps;
    }

    @OneToMany(mappedBy="relacionamentoPessoa", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<PessoasInteressadasRelPessoa> getPessoasInteressadas() {
        return this.pessoasInteressadas;
    }

    public void setPessoasInteressadas(List<PessoasInteressadasRelPessoa> pessoasInteressadas) {
        this.pessoasInteressadas = pessoasInteressadas;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_PREVISTA_SOL_INTERNA")
    public Date getDataPrevistaSolInterna() {
        return this.dataPrevistaSolInterna;
    }

    public void setDataPrevistaSolInterna(Date dataPrevistaSolInterna) {
        this.dataPrevistaSolInterna = dataPrevistaSolInterna;
    }

    @Column(name="EMAILS_ENVIADOS_PARA")
    public String getEmailsEnviadosPara() {
        return this.emailsEnviadosPara;
    }

    public void setEmailsEnviadosPara(String emailsEnviadosPara) {
        this.emailsEnviadosPara = emailsEnviadosPara;
    }
}

