/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemSaneamentoDadosColaborador;
import com.touchcomp.basementor.model.vo.ItemSaneamentoDadosColaboradorLiberados;
import com.touchcomp.basementor.model.vo.TipoColaborador;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="SANEAMENTO_DADOS_COL")
public class SaneamentoDadosColaborador
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private List<ItemSaneamentoDadosColaborador> itemSaneamento = new ArrayList<ItemSaneamentoDadosColaborador>();
    private List<ItemSaneamentoDadosColaboradorLiberados> itemSaneamentoLiberados = new ArrayList<ItemSaneamentoDadosColaboradorLiberados>();
    private TipoColaborador tipoColaborador;
    private TipoEventoEsocial tipoEvento;

    @Id
    @Column(name="ID_SANEA_DADOS_COL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_SANEA_DADOS_COL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_SANEA_DADOS_COL_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="saneamentoDadosColaborador", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemSaneamentoDadosColaborador> getItemSaneamento() {
        return this.itemSaneamento;
    }

    public void setItemSaneamento(List<ItemSaneamentoDadosColaborador> itemSaneamento) {
        this.itemSaneamento = itemSaneamento;
    }

    @OneToMany(mappedBy="saneamentoDadosColaborador", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemSaneamentoDadosColaboradorLiberados> getItemSaneamentoLiberados() {
        return this.itemSaneamentoLiberados;
    }

    public void setItemSaneamentoLiberados(List<ItemSaneamentoDadosColaboradorLiberados> itemSaneamentoLiberados) {
        this.itemSaneamentoLiberados = itemSaneamentoLiberados;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_COLABORADOR", foreignKey=@ForeignKey(name="FK_SANEA_DADOS_ESOC_TP_COL"))
    public TipoColaborador getTipoColaborador() {
        return this.tipoColaborador;
    }

    public void setTipoColaborador(TipoColaborador tipoColaborador) {
        this.tipoColaborador = tipoColaborador;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_TIPO_EVENTO", foreignKey=@ForeignKey(name="FK_TIPO_EVENTO_SANEAMENTO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoEventoEsocial getTipoEvento() {
        return this.tipoEvento;
    }

    public void setTipoEvento(TipoEventoEsocial tipoEvento) {
        this.tipoEvento = tipoEvento;
    }
}

