/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="SECURO_CTE_CLIENTE")
public class SeguroCTeCliente
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Pessoa seguradora;
    private String numeroApolice;
    private String numeroAverbacao;
    private Short responsavelSeguro = 0;
    private Short responsavelSeguroMDFe = 6;
    private List<Cliente> clientes = new ArrayList<Cliente>();
    private Empresa empresa;
    private Short naoSubstituirDadosSegXML = 0;
    private Short concatenarNumeroCteAverb = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_SEGURO_CTE_CLIENTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_SEGURO_CTE_CLIENTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_SEGURADORA", foreignKey=@ForeignKey(name="FK_SECURO_CTE_CLIENTE_PESSOA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getSeguradora() {
        return this.seguradora;
    }

    public void setSeguradora(Pessoa seguradora) {
        this.seguradora = seguradora;
    }

    @Column(name="NUMERO_APOLICE", length=20)
    public String getNumeroApolice() {
        return this.numeroApolice;
    }

    public void setNumeroApolice(String numeroApolice) {
        this.numeroApolice = numeroApolice;
    }

    @Column(name="NUMERO_AVERBACAO", length=40)
    public String getNumeroAverbacao() {
        return this.numeroAverbacao;
    }

    public void setNumeroAverbacao(String numeroAverbacao) {
        this.numeroAverbacao = numeroAverbacao;
    }

    @Column(name="RESP_SEGURO")
    public Short getResponsavelSeguro() {
        return this.responsavelSeguro;
    }

    public void setResponsavelSeguro(Short responsavelSeguro) {
        this.responsavelSeguro = responsavelSeguro;
    }

    @OneToMany
    @JoinTable(name="seguro_cte_cliente_clientes", joinColumns={@JoinColumn(name="ID_SEGURO_CTE_CLIENTE")}, inverseJoinColumns={@JoinColumn(name="ID_CLIENTE")}, uniqueConstraints={@UniqueConstraint(name="UNQ1_SEGURO_CTE_CLIENTE_CLIENTE", columnNames={"ID_CLIENTE"})})
    public List<Cliente> getClientes() {
        return this.clientes;
    }

    public void setClientes(List<Cliente> clientes) {
        this.clientes = clientes;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_SECURO_CTE_CLIENTE_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="NAO_SUBS_DADOS_SEG_XML")
    public Short getNaoSubstituirDadosSegXML() {
        return this.naoSubstituirDadosSegXML;
    }

    public void setNaoSubstituirDadosSegXML(Short naoSubstituirDadosSegXML) {
        this.naoSubstituirDadosSegXML = naoSubstituirDadosSegXML;
    }

    @Column(name="RESP_SEGURO_MDFE")
    public Short getResponsavelSeguroMDFe() {
        return this.responsavelSeguroMDFe;
    }

    public void setResponsavelSeguroMDFe(Short responsavelSeguroMDFe) {
        this.responsavelSeguroMDFe = responsavelSeguroMDFe;
    }

    @Column(name="CONCATENAR_NUMERO_CTE_ABERB")
    public Short getConcatenarNumeroCteAverb() {
        return this.concatenarNumeroCteAverb;
    }

    public void setConcatenarNumeroCteAverb(Short concatenarNumeroCteAverb) {
        this.concatenarNumeroCteAverb = concatenarNumeroCteAverb;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

