/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocMotivoDesligamentoTSV;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.ItemOutrosTitulosFolha;
import com.touchcomp.basementor.model.vo.ItemTerminoTrabalhadorSemVinculo;
import com.touchcomp.basementor.model.vo.Rubricas2299;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="TERMINO_CONTRATO_TSV")
public class TerminoTrabalhadorSemVinculo
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Colaborador colaborador;
    private Date dataTermino;
    private Date dataPagamento;
    private Double remuneracao = 0.0;
    private Short informarRemuneracaoManual = 0;
    private EsocMotivoDesligamentoTSV esocMotivoDesligamento;
    private List<ItemTerminoTrabalhadorSemVinculo> itensTerminoTsv;
    private Double totalProventos = 0.0;
    private Double totalDescontos = 0.0;
    private Double totalLiquido = 0.0;
    private Double baseCalculoIrrf = 0.0;
    private Double baseCalculoInss = 0.0;
    private Double baseCalculoIrrfDec = 0.0;
    private Double baseCalculoInssDec = 0.0;
    private Double aliquotaInss = 0.0;
    private Double aliquotaInssDec = 0.0;
    private Double aliquotaIrrf = 0.0;
    private Double aliquotaIrrfDec = 0.0;
    private Double valorIrrf = 0.0;
    private Double valorInss = 0.0;
    private Double valorInssDec = 0.0;
    private Double valorIrrfDec = 0.0;
    private Short informarImpostoManualmente = 0;
    private Double dependentesIrrf = 0.0;
    private List<EsocPreEvento> preEventosEsocial = new ArrayList<EsocPreEvento>();
    private List<Rubricas2299> rubricas;
    private ItemOutrosTitulosFolha outrosTitulosFolha;

    public TerminoTrabalhadorSemVinculo() {
        this.itensTerminoTsv = new ArrayList<ItemTerminoTrabalhadorSemVinculo>();
        this.rubricas = new ArrayList<Rubricas2299>();
    }

    @Id
    @Column(nullable=false, name="ID_TERMINO_CONTRATO_TSV")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TERMINO_CONTRATO_TSV")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_TERMINO_CONT_TSV_COLABORADOR"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_TERMINO")
    public Date getDataTermino() {
        return this.dataTermino;
    }

    public void setDataTermino(Date dataTermino) {
        this.dataTermino = dataTermino;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_MOT_DESLIGAMENTO", foreignKey=@ForeignKey(name="FK_TERMINO_TSV_ESOC_MOT_DESLIG"))
    public EsocMotivoDesligamentoTSV getEsocMotivoDesligamento() {
        return this.esocMotivoDesligamento;
    }

    public void setEsocMotivoDesligamento(EsocMotivoDesligamentoTSV esocMotivoDesligamento) {
        this.esocMotivoDesligamento = esocMotivoDesligamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TERMINO_TSV_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="REMUNERACAO", precision=15, scale=4)
    public Double getRemuneracao() {
        return this.remuneracao;
    }

    public void setRemuneracao(Double remuneracao) {
        this.remuneracao = remuneracao;
    }

    @Column(name="INFORMAR_REMUNERACAO")
    public Short getInformarRemuneracaoManual() {
        return this.informarRemuneracaoManual;
    }

    public void setInformarRemuneracaoManual(Short informarRemuneracaoManual) {
        this.informarRemuneracaoManual = informarRemuneracaoManual;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="terminoContrato", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemTerminoTrabalhadorSemVinculo> getItensTerminoTsv() {
        return this.itensTerminoTsv;
    }

    public void setItensTerminoTsv(List<ItemTerminoTrabalhadorSemVinculo> itensTerminoTsv) {
        this.itensTerminoTsv = itensTerminoTsv;
    }

    @Column(name="TOTAL_PROVENTOS", precision=15, scale=4)
    public Double getTotalProventos() {
        return this.totalProventos;
    }

    public void setTotalProventos(Double totalProventos) {
        this.totalProventos = totalProventos;
    }

    @Column(name="TOTAL_DESCONTOS", precision=15, scale=4)
    public Double getTotalDescontos() {
        return this.totalDescontos;
    }

    public void setTotalDescontos(Double totalDescontos) {
        this.totalDescontos = totalDescontos;
    }

    @Column(name="TOTAL_LIQUIDO", precision=15, scale=4)
    public Double getTotalLiquido() {
        return this.totalLiquido;
    }

    public void setTotalLiquido(Double totalLiquido) {
        this.totalLiquido = totalLiquido;
    }

    @Column(name="BASE_CALCULO_IRRF", precision=15, scale=4)
    public Double getBaseCalculoIrrf() {
        return this.baseCalculoIrrf;
    }

    public void setBaseCalculoIrrf(Double baseCalculoIrrf) {
        this.baseCalculoIrrf = baseCalculoIrrf;
    }

    @Column(name="BASE_CALCULO_INSS", precision=15, scale=4)
    public Double getBaseCalculoInss() {
        return this.baseCalculoInss;
    }

    public void setBaseCalculoInss(Double baseCalculoInss) {
        this.baseCalculoInss = baseCalculoInss;
    }

    @Column(name="BASE_CALCULO_IRRF_DEC", precision=15, scale=4)
    public Double getBaseCalculoIrrfDec() {
        return this.baseCalculoIrrfDec;
    }

    public void setBaseCalculoIrrfDec(Double baseCalculoIrrfDec) {
        this.baseCalculoIrrfDec = baseCalculoIrrfDec;
    }

    @Column(name="BASE_CALCULO_INSS_DEC", precision=15, scale=4)
    public Double getBaseCalculoInssDec() {
        return this.baseCalculoInssDec;
    }

    public void setBaseCalculoInssDec(Double baseCalculoInssDec) {
        this.baseCalculoInssDec = baseCalculoInssDec;
    }

    @Column(name="ALIQUOTA_INSS", precision=15, scale=4)
    public Double getAliquotaInss() {
        return this.aliquotaInss;
    }

    public void setAliquotaInss(Double aliquotaInss) {
        this.aliquotaInss = aliquotaInss;
    }

    @Column(name="ALIQUOTA_INSS_DEC", precision=15, scale=4)
    public Double getAliquotaInssDec() {
        return this.aliquotaInssDec;
    }

    public void setAliquotaInssDec(Double aliquotaInssDec) {
        this.aliquotaInssDec = aliquotaInssDec;
    }

    @Column(name="ALIQUOTA_IRRF", precision=15, scale=4)
    public Double getAliquotaIrrf() {
        return this.aliquotaIrrf;
    }

    public void setAliquotaIrrf(Double aliquotaIrrf) {
        this.aliquotaIrrf = aliquotaIrrf;
    }

    @Column(name="ALIQUOTA_IRRF_DEC", precision=15, scale=4)
    public Double getAliquotaIrrfDec() {
        return this.aliquotaIrrfDec;
    }

    public void setAliquotaIrrfDec(Double aliquotaIrrfDec) {
        this.aliquotaIrrfDec = aliquotaIrrfDec;
    }

    @Column(name="VALOR_IRRF", precision=15, scale=4)
    public Double getValorIrrf() {
        return this.valorIrrf;
    }

    public void setValorIrrf(Double valorIrrf) {
        this.valorIrrf = valorIrrf;
    }

    @Column(name="VALOR_INSS", precision=15, scale=4)
    public Double getValorInss() {
        return this.valorInss;
    }

    public void setValorInss(Double valorInss) {
        this.valorInss = valorInss;
    }

    @Column(name="VALOR_INSS_DEC", precision=15, scale=4)
    public Double getValorInssDec() {
        return this.valorInssDec;
    }

    public void setValorInssDec(Double valorInssDec) {
        this.valorInssDec = valorInssDec;
    }

    @Column(name="VALOR_IRRF_DEC", precision=15, scale=4)
    public Double getValorIrrfDec() {
        return this.valorIrrfDec;
    }

    public void setValorIrrfDec(Double valorIrrfDec) {
        this.valorIrrfDec = valorIrrfDec;
    }

    @Column(name="INFORMAR_IMPOSTO_MANUALMENTE")
    public Short getInformarImpostoManualmente() {
        return this.informarImpostoManualmente;
    }

    public void setInformarImpostoManualmente(Short informarImpostoManualmente) {
        this.informarImpostoManualmente = informarImpostoManualmente;
    }

    @Column(name="DEPENDENTES_IRRF")
    public Double getDependentesIrrf() {
        return this.dependentesIrrf;
    }

    public void setDependentesIrrf(Double dependentesIrrf) {
        this.dependentesIrrf = dependentesIrrf;
    }

    @Column(name="DATA_PAGAMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Override
    @OneToMany(mappedBy="terminoTsv")
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    @OneToMany(mappedBy="terminoSemVinculo", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<Rubricas2299> getRubricas() {
        return this.rubricas;
    }

    public void setRubricas(List<Rubricas2299> rubricas) {
        this.rubricas = rubricas;
    }

    @OneToOne(mappedBy="terminoTSV")
    public ItemOutrosTitulosFolha getOutrosTitulosFolha() {
        return this.outrosTitulosFolha;
    }

    public void setOutrosTitulosFolha(ItemOutrosTitulosFolha outrosTitulosFolha) {
        this.outrosTitulosFolha = outrosTitulosFolha;
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getColaborador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

