/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoIdentificacaoChavePix;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AdiantamentoViagem;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContrato;
import com.touchcomp.basementor.model.vo.ApuracaoTitulosCartaoDebCred;
import com.touchcomp.basementor.model.vo.ArquivamentoDoc;
import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.CancAntecTitulos;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.CompensacaoChequeTerceiros;
import com.touchcomp.basementor.model.vo.ConfiguracaoCnab;
import com.touchcomp.basementor.model.vo.ContratoLocacao;
import com.touchcomp.basementor.model.vo.CotacaoMoeda;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.CupomDesconto;
import com.touchcomp.basementor.model.vo.DevolucaoPedComercio;
import com.touchcomp.basementor.model.vo.DevolucaoVendas;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaturaCte;
import com.touchcomp.basementor.model.vo.FaturaTitulos;
import com.touchcomp.basementor.model.vo.FechamentoPeriodo;
import com.touchcomp.basementor.model.vo.GeracaoTitulos;
import com.touchcomp.basementor.model.vo.GeracaoTitulosFolhaPagamento;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.InfPagamentoNfTerceiros;
import com.touchcomp.basementor.model.vo.InfPagamentoPedido;
import com.touchcomp.basementor.model.vo.ItemDistribuicaoSobraCooperado;
import com.touchcomp.basementor.model.vo.ItemOutrosTitulosFolha;
import com.touchcomp.basementor.model.vo.LancContAdicDocFinanceiro;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LancamentoEventoCooperado;
import com.touchcomp.basementor.model.vo.LogCobrancaTitulos;
import com.touchcomp.basementor.model.vo.LogTituloCnab;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.LoteLancamentoEventoCooperado;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.NFCeControleCaixa;
import com.touchcomp.basementor.model.vo.NFCePagamento;
import com.touchcomp.basementor.model.vo.NotaContratoLocacao;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.PedidoComercio;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.RenegociacaoTitulos;
import com.touchcomp.basementor.model.vo.RetornoCnabCobranca;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.SituacaoTitulo;
import com.touchcomp.basementor.model.vo.TipoDoc;
import com.touchcomp.basementor.model.vo.TipoValoresTitulosTitulos;
import com.touchcomp.basementor.model.vo.TituloPisCofins;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="TITULO")
public class Titulo
implements InterfaceVO {
    private Long identificador;
    private Pessoa pessoa;
    private Short pagRec = 0;
    private TipoDoc tipoDoc;
    private CarteiraCobranca carteiraCobranca;
    private List<TituloRepresentante> representantes;
    private Short provisao = 0;
    private Date dataVencimento;
    private Date dataEmissao;
    private Date dataEntradaSaida;
    private String numeroBanco;
    private String observacao;
    private Short naoCompoeFluxo = 0;
    private Double valor = 0.0;
    private Date dataCompetencia;
    private Double vrDescontoCondicional = 0.0;
    private Double vrJurosDia = 0.0;
    private Date dataCadastro;
    private Empresa empresa;
    private Double percJurosMes = 0.0;
    private Short numParcTituloEstnota = 0;
    private Set movimentoTitulos;
    private Timestamp dataAtualizacao;
    private PlanoConta planoConta;
    private Short tipoPessoa = 0;
    private List<LancamentoCtbGerencial> lancCtbGerencial = new ArrayList<LancamentoCtbGerencial>();
    private Double valorSaldo = 0.0;
    private List<BoletoTitulo> boletoTitulo;
    private Date dataLimiteDesconto;
    private Date dataInicioJuros;
    private Date dataAplicacaoMulta;
    private Double vrIofPago = 0.0;
    private Double vrAbatimento = 0.0;
    private String codigoAuxiliar;
    private Double descontoFinanceiro = 0.0;
    private Double percDescontoMes = 0.0;
    private FaturaCte faturaCte;
    private Double valorJurosEmbutido = 0.0;
    private Double valorMultaEmbutida = 0.0;
    private Double valorDespesaBancariaEmbutida = 0.0;
    private Short antecipado = 0;
    private Rps rps;
    private Double valorDescontosEmbutido = 0.0;
    private OrdemCompra ordemCompra;
    private LoteContabil loteAdLancamentos;
    private LancContAdicDocFinanceiro lancContAdicDocFinanc;
    private AdiantamentoViagem adiantamentoViagem;
    private Double valorDespBancPaga = 0.0;
    private FaturaTitulos faturaTitulos;
    private FechamentoPeriodo fechamentoFolha;
    private List<LogTituloCnab> logTituloCnab;
    private String codigoDeBarras;
    private AdiantamentoViagem adiantamentoViagemFechamento;
    private GeracaoTitulos geracaoTitulos;
    private ConfiguracaoCnab configuracaoCnab;
    private GeracaoTitulosFolhaPagamento titulosFolha;
    private NotaContratoLocacao notaContratoLocacao;
    private PedidoComercio pedidoComercio;
    private ContratoLocacao contratoLocacao;
    private Short numeroParcelas = 1;
    private SituacaoTitulo situacaoTitulo;
    private CarteiraCobranca cartCobrancaDestino;
    private ArquivamentoDoc arquivoDoc;
    private Date dataVencimentoBase;
    private Double percMulta = 0.0;
    private ApuracaoLocacaoContrato apuracaoLocacaoContrato;
    private LancamentoEventoCooperado lancamentoCooperado;
    private RenegociacaoTitulos renegociacaoTitulos;
    private CompensacaoChequeTerceiros compensacaoChequeTerceiros;
    private Cte cte;
    private Double valorAdicional = 0.0;
    private String linhaDigitavel;
    private CancAntecTitulos cancAntecTitulos;
    private DevolucaoVendas devolucaoVendas;
    private RetornoCnabCobranca retornoCnabCobranca;
    private DevolucaoPedComercio devolucaoPedComercio;
    private InfPagamentoNfPropria infPagamentoNfPropria;
    private InfPagamentoNfTerceiros infPagamentoNfTerceiros;
    private ItemDistribuicaoSobraCooperado itemDistribuicaoSobraCooperado;
    private String lacreConectividadeSocial;
    private String identificadorFGTS;
    private String codigoReceitaFederal;
    private InfPagamentoPedido infPagamentoPedido;
    private Short capturarIdFgts = 0;
    private Pessoa sacadorAvalista;
    private List<TituloPisCofins> tituloPisCofins;
    private NFCePagamento nfcePagamento;
    private NFCeControleCaixa nfCeControleCaixa;
    private Double valorTaxaCartao = 0.0;
    private MeioPagamento meioPagamento;
    private Short contabilizar = 1;
    private List<LogCobrancaTitulos> logCobrancaTitulos;
    private String nrDocOrigemManual;
    private CotacaoMoeda cotacaoMoeda;
    private Double valorOutraMoeda = 0.0;
    private String serialForSinc;
    private ApuracaoTitulosCartaoDebCred apuracaoTitulosCartaoDebCred;
    private LoteLancamentoEventoCooperado loteLancamentoCooperado;
    private ItemOutrosTitulosFolha geracaoOutrosTitulosFolha;
    private ClassificacaoClientes classificacaoPessoa;
    private List<TipoValoresTitulosTitulos> tipoValoresTitulosTitulos;
    private List<CupomDesconto> cupomDesconto;
    private Short tipoChavePix;
    private String chavePix;
    private String codigoQrCode;

    public Titulo() {
        this.representantes = new ArrayList<TituloRepresentante>();
        this.logTituloCnab = new ArrayList<LogTituloCnab>();
        this.boletoTitulo = new ArrayList<BoletoTitulo>();
        this.movimentoTitulos = new HashSet();
        this.tituloPisCofins = new ArrayList<TituloPisCofins>();
        this.logCobrancaTitulos = new ArrayList<LogCobrancaTitulos>();
        this.tipoValoresTitulosTitulos = new ArrayList<TipoValoresTitulosTitulos>();
        this.cupomDesconto = new ArrayList<CupomDesconto>();
        this.tipoChavePix = EnumConstTipoIdentificacaoChavePix.CPF_CNPJ.getValue();
    }

    @Id
    @Column(name="ID_TITULO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TITULO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_TITULO_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(nullable=false, name="PAG_REC")
    public Short getPagRec() {
        return this.pagRec;
    }

    public void setPagRec(Short pagamentoRecebimento) {
        this.pagRec = pagamentoRecebimento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DOC_FINANCEIRO", foreignKey=@ForeignKey(name="FK_TITULO_TIPO_DOC_FIN"))
    public TipoDoc getTipoDoc() {
        return this.tipoDoc;
    }

    public void setTipoDoc(TipoDoc docFinanceiro) {
        this.tipoDoc = docFinanceiro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=true, name="ID_CARTEIRA_COBRANCA", foreignKey=@ForeignKey(name="FK_TITULO_CARTEIRA_COBRANCA"))
    public CarteiraCobranca getCarteiraCobranca() {
        return this.carteiraCobranca;
    }

    public void setCarteiraCobranca(CarteiraCobranca carteiraCobranca) {
        this.carteiraCobranca = carteiraCobranca;
    }

    @Column(nullable=true, name="PROVISAO")
    public Short getProvisao() {
        return this.provisao;
    }

    public void setProvisao(Short provisao) {
        this.provisao = provisao;
    }

    @Column(nullable=true, name="DATA_VENCIMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Column(nullable=false, name="DATA_EMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Column(nullable=true, unique=true, name="NR_BANCO", length=100)
    public String getNumeroBanco() {
        return this.numeroBanco;
    }

    public void setNumeroBanco(String numeroBanco) {
        this.numeroBanco = numeroBanco;
    }

    @Column(nullable=true, name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(nullable=true, name="NAO_COMPOE_FLUXO")
    public Short getNaoCompoeFluxo() {
        return this.naoCompoeFluxo;
    }

    public void setNaoCompoeFluxo(Short naoCompoeFluxo) {
        this.naoCompoeFluxo = naoCompoeFluxo;
    }

    @Column(nullable=false, name="VALOR", precision=12, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @Column(nullable=true, name="VR_DESCONTO_CONDICIONAL", precision=12, scale=2)
    public Double getVrDescontoCondicional() {
        return this.vrDescontoCondicional;
    }

    public void setVrDescontoCondicional(Double valorDescontoCondicional) {
        this.vrDescontoCondicional = valorDescontoCondicional;
    }

    @Column(nullable=true, name="VR_JUROS_DIA", precision=12, scale=2)
    public Double getVrJurosDia() {
        return this.vrJurosDia;
    }

    public void setVrJurosDia(Double valorJurosDias) {
        this.vrJurosDia = valorJurosDias;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TITULO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=true, name="PERC_JUROS_MES", precision=12, scale=2)
    public Double getPercJurosMes() {
        return this.percJurosMes;
    }

    public void setPercJurosMes(Double percentualJurosMes) {
        this.percJurosMes = percentualJurosMes;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        if (this.getPessoa() != null) {
            return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getPessoa().getNome()});
        }
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Transient
    public Set getMovimentoTitulos() {
        return this.movimentoTitulos;
    }

    public void setMovimentoTitulos(Set movimentoTitulos) {
        this.movimentoTitulos = movimentoTitulos;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_TITULO_PLANO_CONTA"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    @Column(name="TIPO_PESSOA")
    public Short getTipoPessoa() {
        return this.tipoPessoa;
    }

    public void setTipoPessoa(Short tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    @Column(name="NUM_PARC_TITULO_ESTNOTA")
    public Short getNumParcTituloEstnota() {
        return this.numParcTituloEstnota;
    }

    public void setNumParcTituloEstnota(Short numParcTituloEstnota) {
        this.numParcTituloEstnota = numParcTituloEstnota;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinTable(name="TITULO_LANC_CTB_GERENCIAL", joinColumns={@JoinColumn(name="ID_TITULO")}, inverseJoinColumns={@JoinColumn(name="ID_LANCAMENTO_CTB_GERENCIAL")})
    public List<LancamentoCtbGerencial> getLancCtbGerencial() {
        return this.lancCtbGerencial;
    }

    public void setLancCtbGerencial(List<LancamentoCtbGerencial> lancCtbGerencial) {
        this.lancCtbGerencial = lancCtbGerencial;
    }

    @Column(nullable=true, name="DATA_LIMITE_DESCONTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataLimiteDesconto() {
        return this.dataLimiteDesconto;
    }

    public void setDataLimiteDesconto(Date dataLimiteDesconto) {
        this.dataLimiteDesconto = dataLimiteDesconto;
    }

    @Column(nullable=true, name="DATA_INICIO_JUROS")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicioJuros() {
        return this.dataInicioJuros;
    }

    public void setDataInicioJuros(Date dataInicioJuros) {
        this.dataInicioJuros = dataInicioJuros;
    }

    @Column(nullable=true, name="DATA_APLICACAO_MULTA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataAplicacaoMulta() {
        return this.dataAplicacaoMulta;
    }

    public void setDataAplicacaoMulta(Date dataAplicacaoMulta) {
        this.dataAplicacaoMulta = dataAplicacaoMulta;
    }

    @Column(nullable=true, name="VR_IOF_PAGO", precision=12, scale=2)
    public Double getVrIofPago() {
        return this.vrIofPago;
    }

    public void setVrIofPago(Double vrIofPago) {
        this.vrIofPago = vrIofPago;
    }

    @Column(nullable=true, name="VR_ABATIMENTO", precision=12, scale=2)
    public Double getVrAbatimento() {
        return this.vrAbatimento;
    }

    public void setVrAbatimento(Double vrAbatimento) {
        this.vrAbatimento = vrAbatimento;
    }

    @Ignore
    @Column(name="CODIGO_AUXILIAR")
    public String getCodigoAuxiliar() {
        return this.codigoAuxiliar;
    }

    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=true, name="VALOR_SALDO", precision=15, scale=2)
    public Double getValorSaldo() {
        return this.valorSaldo;
    }

    public void setValorSaldo(Double valorSaldo) {
        this.valorSaldo = valorSaldo;
    }

    public void setCodigoAuxiliar(String codigoAuxiliar) {
        this.codigoAuxiliar = codigoAuxiliar;
    }

    @Column(name="DATA_COMPETENCIA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCompetencia() {
        return this.dataCompetencia;
    }

    public void setDataCompetencia(Date dataCompetencia) {
        if (dataCompetencia == null) {
            dataCompetencia = this.dataEmissao;
        }
        this.dataCompetencia = dataCompetencia;
    }

    @Column(name="PERC_DESCONTO_MES", precision=15, scale=2)
    public Double getPercDescontoMes() {
        return this.percDescontoMes;
    }

    public void setPercDescontoMes(Double percDescontoMes) {
        this.percDescontoMes = percDescontoMes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FATURA_CTE", foreignKey=@ForeignKey(name="FK_TITULO_FATURA_CTE"))
    public FaturaCte getFaturaCte() {
        return this.faturaCte;
    }

    public void setFaturaCte(FaturaCte faturaCte) {
        this.faturaCte = faturaCte;
    }

    @Column(name="VALOR_JUROS_EMBUTIDO", precision=15, scale=2)
    public Double getValorJurosEmbutido() {
        return this.valorJurosEmbutido;
    }

    public void setValorJurosEmbutido(Double valorJurosEmbutido) {
        this.valorJurosEmbutido = valorJurosEmbutido;
    }

    @Column(name="VALOR_MULTA_EMBUTIDA", precision=15, scale=2)
    public Double getValorMultaEmbutida() {
        return this.valorMultaEmbutida;
    }

    public void setValorMultaEmbutida(Double valorMultaEmbutida) {
        this.valorMultaEmbutida = valorMultaEmbutida;
    }

    @Column(name="ANTECIPADO")
    public Short getAntecipado() {
        return this.antecipado;
    }

    public void setAntecipado(Short antecipado) {
        this.antecipado = antecipado;
    }

    @Column(name="VALOR_DESCONTO_EMBUTIDO", precision=15, scale=2)
    public Double getValorDescontosEmbutido() {
        return this.valorDescontosEmbutido;
    }

    public void setValorDescontosEmbutido(Double valorDescontosEmbutido) {
        this.valorDescontosEmbutido = valorDescontosEmbutido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RPS", foreignKey=@ForeignKey(name="FK_TITULO_RPS"))
    public Rps getRps() {
        return this.rps;
    }

    public void setRps(Rps rps) {
        this.rps = rps;
    }

    @OneToMany(mappedBy="titulo", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public List<BoletoTitulo> getBoletoTitulo() {
        return this.boletoTitulo;
    }

    public void setBoletoTitulo(List<BoletoTitulo> boletoTitulo) {
        this.boletoTitulo = boletoTitulo;
    }

    @JoinColumn(nullable=true, name="ID_ORDEM_COMPRA", foreignKey=@ForeignKey(name="FK_TITULO_ORDEM_COMPRA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public OrdemCompra getOrdemCompra() {
        return this.ordemCompra;
    }

    public void setOrdemCompra(OrdemCompra ordemCompra) {
        this.ordemCompra = ordemCompra;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_AD_LANCAMENTOS", foreignKey=@ForeignKey(name="FK_TITULO_LOTE_CONTABIL"))
    public LoteContabil getLoteAdLancamentos() {
        return this.loteAdLancamentos;
    }

    public void setLoteAdLancamentos(LoteContabil loteAdLancamentos) {
        this.loteAdLancamentos = loteAdLancamentos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LANC_CONT_ADIC_DOC_FINANC", foreignKey=@ForeignKey(name="FK_TITULO_LANC_DOC_FINANC"))
    public LancContAdicDocFinanceiro getLancContAdicDocFinanc() {
        return this.lancContAdicDocFinanc;
    }

    public void setLancContAdicDocFinanc(LancContAdicDocFinanceiro lancContAdicDocFinanc) {
        this.lancContAdicDocFinanc = lancContAdicDocFinanc;
    }

    @JoinColumn(nullable=true, name="ID_ADIANTAMENTO_VIAGEM", foreignKey=@ForeignKey(name="FK_TITULO_AD_VIAGEM"))
    @OneToOne(targetEntity=AdiantamentoViagem.class, fetch=FetchType.LAZY)
    public AdiantamentoViagem getAdiantamentoViagem() {
        return this.adiantamentoViagem;
    }

    public void setAdiantamentoViagem(AdiantamentoViagem adiantamentoViagem) {
        this.adiantamentoViagem = adiantamentoViagem;
    }

    @Column(name="VALOR_DESP_BANC_PAGA", precision=15, scale=2)
    public Double getValorDespBancPaga() {
        return this.valorDespBancPaga;
    }

    public void setValorDespBancPaga(Double valorDespBancPaga) {
        this.valorDespBancPaga = valorDespBancPaga;
    }

    @OneToMany(mappedBy="titulo", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<TituloRepresentante> getRepresentantes() {
        return this.representantes;
    }

    public void setRepresentantes(List<TituloRepresentante> representantes) {
        this.representantes = representantes;
    }

    @JoinColumn(name="ID_FATURA_TITULOS", foreignKey=@ForeignKey(name="FK_TITULO_FAT_TITULOS"))
    @ManyToOne(fetch=FetchType.LAZY)
    public FaturaTitulos getFaturaTitulos() {
        return this.faturaTitulos;
    }

    public void setFaturaTitulos(FaturaTitulos faturaTitulos) {
        this.faturaTitulos = faturaTitulos;
    }

    @OneToMany(mappedBy="titulo", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<LogTituloCnab> getLogTituloCnab() {
        return this.logTituloCnab;
    }

    public void setLogTituloCnab(List<LogTituloCnab> logTituloCnab) {
        this.logTituloCnab = logTituloCnab;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FECHAMENTO_PERIODO", foreignKey=@ForeignKey(name="FK_TITULO_FECH_PER_FOLHA"))
    public FechamentoPeriodo getFechamentoFolha() {
        return this.fechamentoFolha;
    }

    public void setFechamentoFolha(FechamentoPeriodo fechamentoFolha) {
        this.fechamentoFolha = fechamentoFolha;
    }

    @Column(name="CODIGO_BARRAS", length=100)
    public String getCodigoDeBarras() {
        return this.codigoDeBarras;
    }

    public void setCodigoDeBarras(String codigoDeBarras) {
        this.codigoDeBarras = codigoDeBarras;
    }

    @Column(name="DESCONTO_FINANCEIRO", precision=15, scale=2)
    public Double getDescontoFinanceiro() {
        return this.descontoFinanceiro;
    }

    public void setDescontoFinanceiro(Double descontoFinanceiro) {
        this.descontoFinanceiro = descontoFinanceiro;
    }

    @JoinColumn(name="ID_ADIANTAMENTO_VIAGEM_FECHAM", foreignKey=@ForeignKey(name="FK_TITULO_ADIANT_VIAGEM_FECHAM"))
    @OneToOne(targetEntity=AdiantamentoViagem.class, fetch=FetchType.LAZY)
    public AdiantamentoViagem getAdiantamentoViagemFechamento() {
        return this.adiantamentoViagemFechamento;
    }

    public void setAdiantamentoViagemFechamento(AdiantamentoViagem adiantamentoViagemFechamento) {
        this.adiantamentoViagemFechamento = adiantamentoViagemFechamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GERACAO_TITULOS", foreignKey=@ForeignKey(name="FK_TITULO_GER_TITULOS"))
    public GeracaoTitulos getGeracaoTitulos() {
        return this.geracaoTitulos;
    }

    public void setGeracaoTitulos(GeracaoTitulos geracaoTitulos) {
        this.geracaoTitulos = geracaoTitulos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONFIGURACAO_CNAB", foreignKey=@ForeignKey(name="FK_TITULO_CONF_CNAB"))
    public ConfiguracaoCnab getConfiguracaoCnab() {
        return this.configuracaoCnab;
    }

    public void setConfiguracaoCnab(ConfiguracaoCnab configuracaoCnab) {
        this.configuracaoCnab = configuracaoCnab;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TITULOS_FOLHA", foreignKey=@ForeignKey(name="FK_TITULO_GERACAO_FOLHA"))
    public GeracaoTitulosFolhaPagamento getTitulosFolha() {
        return this.titulosFolha;
    }

    public void setTitulosFolha(GeracaoTitulosFolhaPagamento titulosFolha) {
        this.titulosFolha = titulosFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_CONTRATO_LOCACAO", foreignKey=@ForeignKey(name="FK_TITULO_NOTA_CONT_LOCACAO"))
    public NotaContratoLocacao getNotaContratoLocacao() {
        return this.notaContratoLocacao;
    }

    public void setNotaContratoLocacao(NotaContratoLocacao notaContratoLocacao) {
        this.notaContratoLocacao = notaContratoLocacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PEDIDO_COMERCIO", foreignKey=@ForeignKey(name="FK_TITULO_PED_COM"))
    public PedidoComercio getPedidoComercio() {
        return this.pedidoComercio;
    }

    public void setPedidoComercio(PedidoComercio pedidoComercio) {
        this.pedidoComercio = pedidoComercio;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTRATO_LOCACAO", foreignKey=@ForeignKey(name="FK_TITULO_CONTRATO_LOC"))
    public ContratoLocacao getContratoLocacao() {
        return this.contratoLocacao;
    }

    public void setContratoLocacao(ContratoLocacao contratoLocacao) {
        this.contratoLocacao = contratoLocacao;
    }

    @Column(name="NUMERO_PARCELAS")
    public Short getNumeroParcelas() {
        return this.numeroParcelas;
    }

    public void setNumeroParcelas(Short numeroParcelas) {
        this.numeroParcelas = numeroParcelas;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SITUACAO_TITULO", foreignKey=@ForeignKey(name="FK_TITULO_SITUACAO_TITULO"))
    public SituacaoTitulo getSituacaoTitulo() {
        return this.situacaoTitulo;
    }

    public void setSituacaoTitulo(SituacaoTitulo situacaoTitulo) {
        this.situacaoTitulo = situacaoTitulo;
    }

    @JoinColumn(name="ID_ARQUIVO_DOC", foreignKey=@ForeignKey(name="FK_TITULO_ARQ_DOCUMENTO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ArquivamentoDoc getArquivoDoc() {
        return this.arquivoDoc;
    }

    public void setArquivoDoc(ArquivamentoDoc arquivoDoc) {
        this.arquivoDoc = arquivoDoc;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CART_COBRANCA_DESTINO", foreignKey=@ForeignKey(name="FK_TITULO_CART_COBR_DESTINO"))
    public CarteiraCobranca getCartCobrancaDestino() {
        return this.cartCobrancaDestino;
    }

    public void setCartCobrancaDestino(CarteiraCobranca cartCobrancaDestino) {
        this.cartCobrancaDestino = cartCobrancaDestino;
    }

    @Column(name="PERC_MULTA", precision=15, scale=2)
    public Double getPercMulta() {
        return this.percMulta;
    }

    public void setPercMulta(Double percMulta) {
        this.percMulta = percMulta;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VENCIMENTO_BASE")
    public Date getDataVencimentoBase() {
        return this.dataVencimentoBase;
    }

    public void setDataVencimentoBase(Date dataVencimentoBase) {
        this.dataVencimentoBase = dataVencimentoBase;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_APURACAO_LOCACAO_CONTRATO", foreignKey=@ForeignKey(name="FK_TITULO_APUR_LOC_CONTRATO"))
    public ApuracaoLocacaoContrato getApuracaoLocacaoContrato() {
        return this.apuracaoLocacaoContrato;
    }

    public void setApuracaoLocacaoContrato(ApuracaoLocacaoContrato apuracaoLocacaoContrato) {
        this.apuracaoLocacaoContrato = apuracaoLocacaoContrato;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LANCAMENTO_COOPERADO", foreignKey=@ForeignKey(name="FK_TITULO_LANC_COOPERADO"))
    public LancamentoEventoCooperado getLancamentoCooperado() {
        return this.lancamentoCooperado;
    }

    public void setLancamentoCooperado(LancamentoEventoCooperado lancamentoCooperado) {
        this.lancamentoCooperado = lancamentoCooperado;
    }

    @Column(name="VALOR_DESP_BANCARIA_EMBUTIDA", precision=15, scale=2)
    public Double getValorDespesaBancariaEmbutida() {
        return this.valorDespesaBancariaEmbutida;
    }

    public void setValorDespesaBancariaEmbutida(Double valorDespesaBancariaEmbutida) {
        this.valorDespesaBancariaEmbutida = valorDespesaBancariaEmbutida;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RENEGOCIACAO_TITULOS", foreignKey=@ForeignKey(name="FK_TITULO_RENEGOCIACAO_TITULO"))
    public RenegociacaoTitulos getRenegociacaoTitulos() {
        return this.renegociacaoTitulos;
    }

    public void setRenegociacaoTitulos(RenegociacaoTitulos renegociacaoTitulos) {
        this.renegociacaoTitulos = renegociacaoTitulos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COMPENSACAO_CHEQUE_TERC", foreignKey=@ForeignKey(name="FK_TITULO_COMP_CHEQUE_TERC"))
    public CompensacaoChequeTerceiros getCompensacaoChequeTerceiros() {
        return this.compensacaoChequeTerceiros;
    }

    public void setCompensacaoChequeTerceiros(CompensacaoChequeTerceiros compensacaoChequeTerceiros) {
        this.compensacaoChequeTerceiros = compensacaoChequeTerceiros;
    }

    @JoinColumn(name="ID_CTE", foreignKey=@ForeignKey(name="FK_TITULO_CTE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Cte getCte() {
        return this.cte;
    }

    public void setCte(Cte cte) {
        this.cte = cte;
    }

    @Column(name="VALOR_ADICIONAL", precision=15, scale=2)
    public Double getValorAdicional() {
        return this.valorAdicional;
    }

    public void setValorAdicional(Double valorAdicional) {
        this.valorAdicional = valorAdicional;
    }

    @Column(name="LINHA_DIGITAVEL", length=48)
    public String getLinhaDigitavel() {
        return this.linhaDigitavel;
    }

    public void setLinhaDigitavel(String linhaDigitavel) {
        this.linhaDigitavel = linhaDigitavel;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CANC_ANTEC_TITULOS", foreignKey=@ForeignKey(name="FK_TITULO_CANC_ANTEC_TIT"))
    public CancAntecTitulos getCancAntecTitulos() {
        return this.cancAntecTitulos;
    }

    public void setCancAntecTitulos(CancAntecTitulos cancAntecTitulos) {
        this.cancAntecTitulos = cancAntecTitulos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DEVOL_VENDAS", foreignKey=@ForeignKey(name="FK_TITULO_DEVOL_VENDAS"))
    public DevolucaoVendas getDevolucaoVendas() {
        return this.devolucaoVendas;
    }

    public void setDevolucaoVendas(DevolucaoVendas devolucaoVendas) {
        this.devolucaoVendas = devolucaoVendas;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RETORNO_CNAB", foreignKey=@ForeignKey(name="FK_TITULO_RETORNO_CNAB"))
    public RetornoCnabCobranca getRetornoCnabCobranca() {
        return this.retornoCnabCobranca;
    }

    public void setRetornoCnabCobranca(RetornoCnabCobranca retornoCnabCobranca) {
        this.retornoCnabCobranca = retornoCnabCobranca;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DEVOL_PED_COMERCIO", foreignKey=@ForeignKey(name="FK_TITULO_DEVOL_PED_COMERCIO"))
    public DevolucaoPedComercio getDevolucaoPedComercio() {
        return this.devolucaoPedComercio;
    }

    public void setDevolucaoPedComercio(DevolucaoPedComercio devolucaoPedComercio) {
        this.devolucaoPedComercio = devolucaoPedComercio;
    }

    @JoinColumn(name="ID_INF_PAG_NF_PROPRIA", foreignKey=@ForeignKey(name="FK_TITULO_INF_PAG_NF_PROPRIA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public InfPagamentoNfPropria getInfPagamentoNfPropria() {
        return this.infPagamentoNfPropria;
    }

    public void setInfPagamentoNfPropria(InfPagamentoNfPropria infPagamentoNfPropria) {
        this.infPagamentoNfPropria = infPagamentoNfPropria;
    }

    @JoinColumn(name="ID_INF_PAG_NF_TERCEIROS", foreignKey=@ForeignKey(name="FK_TITULO_INF_PAG_NF_TERC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public InfPagamentoNfTerceiros getInfPagamentoNfTerceiros() {
        return this.infPagamentoNfTerceiros;
    }

    public void setInfPagamentoNfTerceiros(InfPagamentoNfTerceiros infPagamentoNfTerceiros) {
        this.infPagamentoNfTerceiros = infPagamentoNfTerceiros;
    }

    @JoinColumn(name="ID_ITEM_DISTRIB_SOBRA_COOPERADO", foreignKey=@ForeignKey(name="FK_TITULO_ITEM_DISTR_SOBRA_COOP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ItemDistribuicaoSobraCooperado getItemDistribuicaoSobraCooperado() {
        return this.itemDistribuicaoSobraCooperado;
    }

    public void setItemDistribuicaoSobraCooperado(ItemDistribuicaoSobraCooperado itemDistribuicaoSobraCooperado) {
        this.itemDistribuicaoSobraCooperado = itemDistribuicaoSobraCooperado;
    }

    @Column(nullable=true, name="LACRE_CONECTIVIDADE_SOCIAL", length=20)
    public String getLacreConectividadeSocial() {
        return this.lacreConectividadeSocial;
    }

    public void setLacreConectividadeSocial(String lacreConectividadeSocial) {
        this.lacreConectividadeSocial = lacreConectividadeSocial;
    }

    @Column(nullable=true, name="IDENTIFICADOR_FGTS", length=20)
    public String getIdentificadorFGTS() {
        return this.identificadorFGTS;
    }

    public void setIdentificadorFGTS(String identificadorFGTS) {
        this.identificadorFGTS = identificadorFGTS;
    }

    @Column(name="CODIGO_RECEITA_FEDERAL", length=20)
    public String getCodigoReceitaFederal() {
        return this.codigoReceitaFederal;
    }

    public void setCodigoReceitaFederal(String codigoReceitaFederal) {
        this.codigoReceitaFederal = codigoReceitaFederal;
    }

    @JoinColumn(name="ID_INF_PAG_PEDIDO", foreignKey=@ForeignKey(name="FK_TITULO_INF_PAG_PEDIDO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public InfPagamentoPedido getInfPagamentoPedido() {
        return this.infPagamentoPedido;
    }

    public void setInfPagamentoPedido(InfPagamentoPedido infPagamentoPedido) {
        this.infPagamentoPedido = infPagamentoPedido;
    }

    @Column(name="CAPTURAR_ID_FGTS")
    public Short getCapturarIdFgts() {
        return this.capturarIdFgts;
    }

    public void setCapturarIdFgts(Short capturarIdFgts) {
        this.capturarIdFgts = capturarIdFgts;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SACADOR_AVALISTA", foreignKey=@ForeignKey(name="FK_TITULO_SACADOR_AVALISTA"))
    public Pessoa getSacadorAvalista() {
        return this.sacadorAvalista;
    }

    public void setSacadorAvalista(Pessoa sacadorAvalista) {
        this.sacadorAvalista = sacadorAvalista;
    }

    @OneToMany(mappedBy="titulo", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<TituloPisCofins> getTituloPisCofins() {
        return this.tituloPisCofins;
    }

    public void setTituloPisCofins(List<TituloPisCofins> tituloPisCofins) {
        this.tituloPisCofins = tituloPisCofins;
    }

    @JoinColumn(name="ID_NFCE_PAGAMENTO", foreignKey=@ForeignKey(name="FK_TITULO_NFCE_PAGAMENTO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public NFCePagamento getNfcePagamento() {
        return this.nfcePagamento;
    }

    public void setNfcePagamento(NFCePagamento nfcePagamento) {
        this.nfcePagamento = nfcePagamento;
    }

    @JoinColumn(name="ID_NFCE_CONTROLE_CAIXA", foreignKey=@ForeignKey(name="FK_TITULO_NFCE_CTRL_CX_FISCAL"))
    @OneToOne(targetEntity=NFCeControleCaixa.class, fetch=FetchType.LAZY)
    public NFCeControleCaixa getNfCeControleCaixa() {
        return this.nfCeControleCaixa;
    }

    public void setNfCeControleCaixa(NFCeControleCaixa nfCeControleCaixa) {
        this.nfCeControleCaixa = nfCeControleCaixa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENTRADA_SAIDA")
    public Date getDataEntradaSaida() {
        return this.dataEntradaSaida;
    }

    public void setDataEntradaSaida(Date dataEntrada) {
        if (this.dataEntradaSaida == null) {
            this.dataEntradaSaida = this.dataCompetencia;
        }
        if (this.dataEntradaSaida == null) {
            this.dataEntradaSaida = this.dataEmissao;
        }
        this.dataEntradaSaida = dataEntrada;
    }

    @Column(name="VALOR_TAXA_CARTAO", precision=15, scale=2)
    public Double getValorTaxaCartao() {
        return this.valorTaxaCartao;
    }

    public void setValorTaxaCartao(Double vlrTaxaCartao) {
        this.valorTaxaCartao = vlrTaxaCartao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_TITULO_MEIO_PAGAMENTO"))
    public MeioPagamento getMeioPagamento() {
        return this.meioPagamento;
    }

    public void setMeioPagamento(MeioPagamento meioPagamento) {
        this.meioPagamento = meioPagamento;
    }

    @Column(name="CONTABILIZAR")
    public Short getContabilizar() {
        return this.contabilizar;
    }

    public void setContabilizar(Short contabilizar) {
        this.contabilizar = contabilizar;
    }

    @OneToMany(mappedBy="titulo", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<LogCobrancaTitulos> getLogCobrancaTitulos() {
        return this.logCobrancaTitulos;
    }

    public void setLogCobrancaTitulos(List<LogCobrancaTitulos> logCobrancaTitulos) {
        this.logCobrancaTitulos = logCobrancaTitulos;
    }

    @Column(name="NR_DOC_ORIGEM_MANUAL", length=20)
    public String getNrDocOrigemManual() {
        return this.nrDocOrigemManual;
    }

    public void setNrDocOrigemManual(String nrDocOrigemManual) {
        this.nrDocOrigemManual = nrDocOrigemManual;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COTACAO_MOEDA", foreignKey=@ForeignKey(name="FK_TITULO_COTACAO_MOEDA"))
    public CotacaoMoeda getCotacaoMoeda() {
        return this.cotacaoMoeda;
    }

    public void setCotacaoMoeda(CotacaoMoeda cotacaoMoeda) {
        this.cotacaoMoeda = cotacaoMoeda;
    }

    @Column(name="VALOR_OUTRA_MOEDA", precision=15, scale=2)
    public Double getValorOutraMoeda() {
        return this.valorOutraMoeda;
    }

    public void setValorOutraMoeda(Double valorOutraMoeda) {
        this.valorOutraMoeda = valorOutraMoeda;
    }

    @Column(name="SERIAL_FOR_SINC", length=100)
    public String getSerialForSinc() {
        return this.serialForSinc;
    }

    public void setSerialForSinc(String serialForSinc) {
        this.serialForSinc = serialForSinc;
    }

    @JoinColumn(name="ID_APUR_TITULOS_CARTAO_CRED_DEB", foreignKey=@ForeignKey(name="FK_TITULO_AP_TIT_CART_DEB_CRED"))
    @OneToOne(targetEntity=ApuracaoTitulosCartaoDebCred.class, fetch=FetchType.LAZY)
    public ApuracaoTitulosCartaoDebCred getApuracaoTitulosCartaoDebCred() {
        return this.apuracaoTitulosCartaoDebCred;
    }

    public void setApuracaoTitulosCartaoDebCred(ApuracaoTitulosCartaoDebCred apuracaoTitulosCartaoDebCred) {
        this.apuracaoTitulosCartaoDebCred = apuracaoTitulosCartaoDebCred;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_LANC_EVT_COOPERADO", foreignKey=@ForeignKey(name="FK_TITULO_LOTE_LANC_EVT_COOP"))
    public LoteLancamentoEventoCooperado getLoteLancamentoCooperado() {
        return this.loteLancamentoCooperado;
    }

    public void setLoteLancamentoCooperado(LoteLancamentoEventoCooperado loteLancamentoCooperado) {
        this.loteLancamentoCooperado = loteLancamentoCooperado;
    }

    @JoinColumn(name="ID_ITEM_OUTROS_TIT_FOLHA", foreignKey=@ForeignKey(name="FK_TITULO_ITEM_OUT_TIT_FOLHA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ItemOutrosTitulosFolha getGeracaoOutrosTitulosFolha() {
        return this.geracaoOutrosTitulosFolha;
    }

    public void setGeracaoOutrosTitulosFolha(ItemOutrosTitulosFolha geracaoOutrosTitulosFolha) {
        this.geracaoOutrosTitulosFolha = geracaoOutrosTitulosFolha;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_PESSOA", foreignKey=@ForeignKey(name="FK_TITULO_CLASSIF_PESSOA"))
    public ClassificacaoClientes getClassificacaoPessoa() {
        return this.classificacaoPessoa;
    }

    public void setClassificacaoPessoa(ClassificacaoClientes classificacaoPessoa) {
        this.classificacaoPessoa = classificacaoPessoa;
    }

    @OneToMany(mappedBy="titulo", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<TipoValoresTitulosTitulos> getTipoValoresTitulosTitulos() {
        return this.tipoValoresTitulosTitulos;
    }

    public void setTipoValoresTitulosTitulos(List<TipoValoresTitulosTitulos> tipoValoresTitulosTitulos) {
        this.tipoValoresTitulosTitulos = tipoValoresTitulosTitulos;
    }

    @OneToMany(mappedBy="tituloAntecipado", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CupomDesconto> getCupomDesconto() {
        return this.cupomDesconto;
    }

    public void setCupomDesconto(List<CupomDesconto> cupomDesconto) {
        this.cupomDesconto = cupomDesconto;
    }

    @Column(name="TIPO_CHAVE_PIX")
    public Short getTipoChavePix() {
        return this.tipoChavePix;
    }

    public void setTipoChavePix(Short tipoChavePix) {
        this.tipoChavePix = tipoChavePix;
    }

    @Column(name="CHAVE_PIX", length=77)
    public String getChavePix() {
        return this.chavePix;
    }

    public void setChavePix(String chavePix) {
        this.chavePix = chavePix;
    }

    @Column(name="CODIGO_QR_CODE", length=32)
    public String getCodigoQrCode() {
        return this.codigoQrCode;
    }

    public void setCodigoQrCode(String codigoQrCode) {
        this.codigoQrCode = codigoQrCode;
    }
}

