/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.GrupoUnidFederativaRelUF;
import com.touchcomp.basementor.model.vo.Pais;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="UF")
public class UnidadeFederativa
implements InterfaceVO {
    private Long identificador;
    private String sigla;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private String descricao;
    private String codIbge;
    private Pais pais;
    private List<GrupoUnidFederativaRelUF> grupoUnidFederativaRel = new ArrayList<GrupoUnidFederativaRelUF>();

    @Id
    @Column(nullable=false, name="ID_UF")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_UF")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, unique=true, name="SIGLA", length=2)
    public String getSigla() {
        return this.sigla;
    }

    @Column(nullable=false, unique=true, name="COD_IBGE", length=2)
    public String getCodIbge() {
        return this.codIbge;
    }

    @Column(nullable=false, name="DESCRICAO", length=80)
    public String getDescricao() {
        return this.descricao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PAIS", foreignKey=@ForeignKey(name="FK_UF_PAIS"))
    public Pais getPais() {
        return this.pais;
    }

    public void setIdentificador(Long idUnidadeFederativa) {
        this.identificador = idUnidadeFederativa;
    }

    public void setSigla(String sigla) {
        this.sigla = sigla;
    }

    public void setCodIbge(String codIbge) {
        this.codIbge = codIbge;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setPais(Pais pais) {
        this.pais = pais;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getSigla() != null && this.getSigla().equalsIgnoreCase("EX") ? ToolBaseMethodsVO.toString((String)"{0} - {1} / {2}", (Object[])new Object[]{this.getSigla(), this.getDescricao(), this.getPais() != null ? this.getPais().getDescricao() : this.getPais()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getSigla()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @OneToMany(mappedBy="unidadeFederativa")
    public List<GrupoUnidFederativaRelUF> getGrupoUnidFederativaRel() {
        return this.grupoUnidFederativaRel;
    }

    public void setGrupoUnidFederativaRel(List<GrupoUnidFederativaRelUF> grupoUnidFederativaRel) {
        this.grupoUnidFederativaRel = grupoUnidFederativaRel;
    }
}

