/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.certificado;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.NFCeOpcoes;
import com.touchcomp.basementor.model.vo.TipoEmissaoNFe;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class ConfigCertificateNFCe
extends NFeConfig {
    private final NFCeOpcoes opcoes;
    private KeyStore keyStoreCertificado = null;
    private KeyStore keyStoreCadeia = null;
    private final UnidadeFederativa unidadeFederativa;
    private final ConfiguracaoCertificado configuracaoCertificado;
    private final TipoEmissaoNFe tipoEmissaoNFe;

    public ConfigCertificateNFCe(UnidadeFederativa unidadeFederativa, NFCeOpcoes opcoes, TipoEmissaoNFe tipoEmissaoNFe) {
        this.unidadeFederativa = unidadeFederativa;
        this.configuracaoCertificado = opcoes.getConfiguracaoCertificado();
        this.opcoes = opcoes;
        this.tipoEmissaoNFe = tipoEmissaoNFe;
    }

    public Integer getCodigoSegurancaContribuinteID() {
        return Integer.valueOf(ToolString.onlyNumbers((String)this.opcoes.getIdentificadorCSCContrib()));
    }

    public String getCodigoSegurancaContribuinte() {
        return this.opcoes.getCodigoCSCContrib();
    }

    public String getCertificadoSenha() {
        return this.configuracaoCertificado.getSenha();
    }

    public String getCadeiaCertificadosSenha() {
        return "touchcompKeyStore";
    }

    public DFUnidadeFederativa getCUF() {
        return DFUnidadeFederativa.valueOfCodigo((String)this.unidadeFederativa.getCodIbge());
    }

    public KeyStore getCertificadoKeyStore() throws KeyStoreException {
        if (this.keyStoreCertificado == null) {
            if (this.configuracaoCertificado.getArquivoPFX() == null) {
                throw new KeyStoreException(MessagesBaseMentor.getErrorMsg((String)"E.GEN.000059", (Object[])new Object[0]));
            }
            this.keyStoreCertificado = KeyStore.getInstance("PKCS12");
            try (ByteArrayInputStream certificadoStream = new ByteArrayInputStream(this.configuracaoCertificado.getArquivoPFX());){
                this.keyStoreCertificado.load(certificadoStream, this.getCertificadoSenha().toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                this.keyStoreCadeia = null;
                TLogger.get(((Object)((Object)this)).getClass()).error((Throwable)e);
                throw new KeyStoreException(MessagesBaseMentor.getErrorMsg((String)"E.GEN.000059", (Object[])new Object[]{e.getMessage()}));
            }
        }
        return this.keyStoreCertificado;
    }

    public KeyStore getCadeiaCertificadosKeyStore() throws KeyStoreException {
        if (this.keyStoreCadeia == null) {
            if (this.configuracaoCertificado.getArquivoJKS() == null) {
                throw new KeyStoreException(MessagesBaseMentor.getErrorMsg((String)"E.GEN.000058", (Object[])new Object[0]));
            }
            this.keyStoreCadeia = KeyStore.getInstance("JKS");
            try (ByteArrayInputStream cadeia = new ByteArrayInputStream(this.configuracaoCertificado.getArquivoJKS());){
                this.keyStoreCadeia.load(cadeia, this.getCadeiaCertificadosSenha().toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                this.keyStoreCadeia = null;
                TLogger.get(((Object)((Object)this)).getClass()).error((Throwable)e);
                throw new KeyStoreException(MessagesBaseMentor.getErrorMsg((String)"E.GEN.000058", (Object[])new Object[]{e.getMessage()}));
            }
        }
        return this.keyStoreCadeia;
    }

    public DFAmbiente getAmbiente() {
        if (ToolMethods.isWithData((Number)this.opcoes.getTipoAmbiente())) {
            return DFAmbiente.valueOfCodigo((String)String.valueOf(this.opcoes.getTipoAmbiente()));
        }
        throw new RuntimeException("Primeiro cadastre o Tipo de Ambiente em Op\u00e7\u00f5es NFCe");
    }

    public NFTipoEmissao getTipoEmissao() {
        if (ToolMethods.isEquals((Object)this.tipoEmissaoNFe.getCodigo(), (Object)3)) {
            throw new RuntimeException("Tipo Emissao SCAN descontinuado pela SEFAZ. Utilize SVCAN ou SVCRS.");
        }
        if (ToolMethods.isEquals((Object)this.tipoEmissaoNFe.getCodigo(), (Object)4)) {
            return NFTipoEmissao.CONTINGENCIA_EPEC;
        }
        if (ToolMethods.isEquals((Object)this.tipoEmissaoNFe.getCodigo(), (Object)6)) {
            return NFTipoEmissao.CONTINGENCIA_SVCAN;
        }
        if (ToolMethods.isEquals((Object)this.tipoEmissaoNFe.getCodigo(), (Object)7)) {
            return NFTipoEmissao.CONTINGENCIA_SVCRS;
        }
        if (ToolMethods.isEquals((Object)this.tipoEmissaoNFe.getCodigo(), (Object)5)) {
            return NFTipoEmissao.CONTINGENCIA_FSDA;
        }
        return NFTipoEmissao.EMISSAO_NORMAL;
    }

    public int getSoTimeoutEmMillis() {
        if (this.opcoes.getTimeoutConexao() != null && this.opcoes.getTimeoutConexao() > 0) {
            return this.opcoes.getTimeoutConexao() * 1000;
        }
        return super.getTimeoutRequisicaoEmMillis();
    }
}

