/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.components;

import com.touchcomp.basementor.constants.enums.reinf.EnumConstRelReinfTipoAmbiente;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfLoteEventos;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfClienteWebservice;
import com.touchcomp.basementorclientwebservices.reinf.ConstantsNamespace;
import com.touchcomp.basementorclientwebservices.reinf.DocFactoryEventosReinf;
import com.touchcomp.basementorclientwebservices.reinf.SignatureXmlReinf;
import com.touchcomp.basementorclientwebservices.reinf.modellote.envioloteeventos.v1_04_00.Evento;
import com.touchcomp.basementorclientwebservices.reinf.modellote.v2_01_02.envioloteeventosassincrono.v1_00_00.Reinf2;
import com.touchcomp.basementorclientwebservices.reinf.modellote.v2_01_02.envioloteeventosassincrono.v1_00_00.TArquivoReinf;
import com.touchcomp.basementorclientwebservices.reinf.modellote.v2_01_02.envioloteeventosassincrono.v1_00_00.TIdeContribuinte;
import com.touchcomp.basementorclientwebservices.reinf.tools.ToolReinf;
import com.touchcomp.basementorclientwebservices.reinf.webservices.producao.ConsultasReinfStub;
import com.touchcomp.basementorclientwebservices.reinf.webservices.producao.RecepcaoLoteReinfStub;
import com.touchcomp.basementorclientwebservices.reinf.webservices.restrito.ConsultasReinfStub;
import com.touchcomp.basementorclientwebservices.reinf.webservices.restrito.RecepcaoLoteReinfStub;
import com.touchcomp.basementorexceptions.exceptions.impl.assinaturaxml.ExceptionAssinaturaXML;
import com.touchcomp.basementorexceptions.exceptions.impl.axis.ExceptionAxis;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jaxb.ExceptionJaxb;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionInvalidXML;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.EnumReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.ExceptionReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.hashmd5.ToolHashMD5;
import com.touchcomp.basementortools.tools.jaxb.ToolJaxb;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.webserviceclient.ToolRESTWebServiceClient;
import com.touchcomp.basementorxml.model.XMLEventoEsocial;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLEventoEsocial;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.databinding.types.UnsignedByte;
import org.jdom2.Element;
import org.springframework.stereotype.Component;

@Component
public class DocReinfBase {
    public void validarXMLLoteEventos(ReinfLoteEventos loteEventos, R1000 opcoesReinf) throws ExceptionReinf, ExceptionIO, ExceptionJDom, ExceptionInvalidXML, ExceptionJaxb {
        for (ReinfEvento evento : loteEventos.getEventos()) {
            Evento reinf = DocFactoryEventosReinf.getEvento(evento, opcoesReinf);
            String xml = ToolJaxb.toXMl((Object)reinf, (boolean)true);
            ToolJdom.validateXMLAgaintsSchema((String)xml, (InputStream)DocFactoryEventosReinf.getXSD(evento));
        }
    }

    public String salvarXml(ReinfEvento evento, R1000 opcoesReinf) throws ExceptionReinf, ExceptionIO, ExceptionJDom, ExceptionInvalidXML, ExceptionJaxb {
        Evento esocial = DocFactoryEventosReinf.getEvento(evento, opcoesReinf);
        String xml = ToolJaxb.toXMl((Object)esocial, (boolean)true);
        return xml;
    }

    public String salvarXmlLoteEventos(Reinf2 enviarLoteEventos, R1000 opcoesReinf) throws ExceptionReinf, ExceptionIO, ExceptionJDom, ExceptionInvalidXML, ExceptionJaxb, ExceptionCertificado, ExceptionAssinaturaXML {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        sb.append("<Reinf xmlns=\"http://www.reinf.esocial.gov.br/schemas/envioLoteEventosAssincrono/v1_00_00\">");
        sb.append("<ideContribuinte>");
        sb.append("<tpInsc>");
        sb.append("1");
        sb.append("</tpInsc>");
        sb.append("<nrInsc>");
        sb.append("12345678");
        sb.append("</nrInsc>");
        sb.append("</ideContribuinte>");
        sb.append("</evento>");
        sb.append("</eventos>");
        sb.append("</envioLoteEventos></Reinf>");
        String xml = sb.toString();
        xml = xml.replace("ns2:", "");
        xml = xml.replace(":ns2", "");
        System.out.println("teste");
        return xml;
    }

    public String gerarHashXMLEvento(ReinfPreEvento preEvento, R1000 opcoeEsocial) throws ExceptionReinf, ExceptionJaxb {
        TArquivoReinf evt = this.buildEvento(null, opcoeEsocial);
        String xml = ToolJaxb.toXMl((Object)evt);
        return ToolHashMD5.gerarHashXMLEvento((String)xml);
    }

    public void enviarLoteEventos(ReinfLoteEventos loteEventos, R1000 opcoes) throws ExceptionReinf, ExceptionJaxb, ExceptionCertificado, ExceptionAssinaturaXML, ExceptionIO, ExceptionAxis, ExceptionJDom {
        CertificadoConfClienteWebservice.configure(opcoes.getConfiguracaoCertificado());
        Reinf2 enviarLoteEventos = this.buildEnviarLoteEventos(loteEventos, opcoes);
        String xml = this.montarXml(enviarLoteEventos);
        this.backupToFile(xml, this.getPathEnvioLotes(loteEventos));
        String result = "";
        try {
            ByteArrayInputStream cert = new ByteArrayInputStream(opcoes.getConfiguracaoCertificado().getArquivoPFX());
            String retorno = loteEventos.getIdentificacaoAmbiente().getCodigo().equals(EnumConstRelReinfTipoAmbiente.AMBIENTE_NORMAL.value) ? ToolRESTWebServiceClient.createServicePostSSL((String)"https://reinf.receita.economia.gov.br/recepcao/lotes", (String)xml, null, (InputStream)cert, (String)opcoes.getConfiguracaoCertificado().getSenha()) : ToolRESTWebServiceClient.createServicePostSSL((String)"https://pre-reinf.receita.economia.gov.br/recepcao/lotes", (String)xml, null, (InputStream)cert, (String)opcoes.getConfiguracaoCertificado().getSenha());
            Element reinf = ToolJdom.getRootElement((String)retorno);
            reinf.getChildren();
            Element retornoEnvioLoteEventos = reinf.getChild("retornoLoteEventosAssincrono", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE);
            retornoEnvioLoteEventos.getChildText("status");
            Element status = retornoEnvioLoteEventos.getChild("status", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE);
            loteEventos.setCodStatusEnvio(Long.valueOf(status.getChildText("cdResposta", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE)));
            Element dadosRecepcaoLote = retornoEnvioLoteEventos.getChild("dadosRecepcaoLote", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE);
            String numeroProtocolo = dadosRecepcaoLote.getChildText("protocoloEnvio", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE);
            loteEventos.setNumeroProtEnvio(numeroProtocolo);
            result = loteEventos.getIdentificacaoAmbiente().getCodigo().equals(EnumConstRelReinfTipoAmbiente.AMBIENTE_NORMAL.value) ? ToolRESTWebServiceClient.createServiceGetSSL((String)("https://reinf.receita.economia.gov.br/consulta/lotes/" + numeroProtocolo), null, (InputStream)new ByteArrayInputStream(opcoes.getConfiguracaoCertificado().getArquivoPFX()), (String)opcoes.getConfiguracaoCertificado().getSenha()) : ToolRESTWebServiceClient.createServiceGetSSL((String)("https://pre-reinf.receita.economia.gov.br/consulta/lotes/" + numeroProtocolo), null, (InputStream)new ByteArrayInputStream(opcoes.getConfiguracaoCertificado().getArquivoPFX()), (String)opcoes.getConfiguracaoCertificado().getSenha());
        }
        catch (ExceptionWebService ex) {
            Logger.getLogger(DocReinfBase.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println("\n\n\nXML:" + xml);
        this.setStatusLote(result, loteEventos);
    }

    public KeyStore getCadeiaCertificadosKeyStore(R1000 opcoes) throws KeyStoreException {
        KeyStore keyStoreCadeia = KeyStore.getInstance("JKS");
        try (ByteArrayInputStream cadeia = new ByteArrayInputStream(opcoes.getConfiguracaoCertificado().getArquivoJKS());){
            keyStoreCadeia.load(cadeia, opcoes.getConfiguracaoCertificado().getSenha().toCharArray());
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            keyStoreCadeia = null;
            throw new KeyStoreException("Nao foi possivel montar o KeyStore com o certificado", e);
        }
        return keyStoreCadeia;
    }

    public KeyStore getCertificadoKeyStore(R1000 opcoes) throws KeyStoreException {
        try {
            KeyStore keyStoreCertificado = KeyStore.getInstance("PKCS12");
            keyStoreCertificado.load(new ByteArrayInputStream(opcoes.getConfiguracaoCertificado().getArquivoJKS()), opcoes.getConfiguracaoCertificado().getSenha().toCharArray());
            return keyStoreCertificado;
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreException("Nao foi possivel montar o KeyStore com a cadeia de certificados", e);
        }
    }

    private File getPathEnvioLotes(ReinfLoteEventos lote) {
        return new File(ToolFile.getUserDir() + "/reinf/envio/" + lote.getIdentificador() + "-env.xml");
    }

    private File getPathRetornoEnvioLotes(ReinfLoteEventos lote) {
        return new File(ToolFile.getUserDir() + "/reinf/retorno/" + lote.getIdentificador() + "-ret-env.xml");
    }

    private File getPathEnvioConsultaEnvioLotes(ReinfLoteEventos lote) {
        return new File(ToolFile.getUserDir() + "/reinf/consulta/" + lote.getIdentificador() + "-cons.xml");
    }

    private File getPathRetornoEnvioConsultaLotes(ReinfLoteEventos lote) {
        return new File(ToolFile.getUserDir() + "/reinf/consulta/" + lote.getIdentificador() + "-ret-cons.xml");
    }

    public void consultaLoteEventosEsocial(ReinfLoteEventos loteEventos, R1000 opcoes) throws ExceptionReinf, ExceptionJaxb, ExceptionCertificado, ExceptionAssinaturaXML, ExceptionIO, ExceptionAxis, ExceptionJDom {
        try {
            String result;
            CertificadoConfClienteWebservice.configure(opcoes.getConfiguracaoCertificado());
            if (loteEventos.getIdentificacaoAmbiente().getCodigo().equals(EnumConstRelReinfTipoAmbiente.AMBIENTE_NORMAL.value)) {
                result = ToolRESTWebServiceClient.createServiceGetSSL((String)("https://reinf.receita.economia.gov.br/consulta/lotes/" + loteEventos.getNumeroProtEnvio()), null, (InputStream)new ByteArrayInputStream(opcoes.getConfiguracaoCertificado().getArquivoPFX()), (String)opcoes.getConfiguracaoCertificado().getSenha());
                this.setStatusLote(result, loteEventos);
            } else {
                result = ToolRESTWebServiceClient.createServiceGetSSL((String)("https://pre-reinf.receita.economia.gov.br/consulta/lotes/" + loteEventos.getNumeroProtEnvio()), null, (InputStream)new ByteArrayInputStream(opcoes.getConfiguracaoCertificado().getArquivoPFX()), (String)opcoes.getConfiguracaoCertificado().getSenha());
                this.setStatusLote(result, loteEventos);
            }
            this.backupToFile(result, this.getPathRetornoEnvioConsultaLotes(loteEventos));
        }
        catch (ExceptionWebService ex) {
            Logger.getLogger(DocReinfBase.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String sendLoteEventosProducao(String xml) throws AxisFault, RemoteException, XMLStreamException {
        RecepcaoLoteReinfStub r = new RecepcaoLoteReinfStub();
        RecepcaoLoteReinfStub.ReceberLoteEventos rr = new RecepcaoLoteReinfStub.ReceberLoteEventos();
        RecepcaoLoteReinfStub.LoteEventos_type0 t = new RecepcaoLoteReinfStub.LoteEventos_type0();
        OMElement el = AXIOMUtil.stringToOM((String)xml);
        t.setExtraElement(el);
        t.getExtraElement().toString();
        rr.setLoteEventos(t);
        RecepcaoLoteReinfStub.ReceberLoteEventosResponse resp = r.receberLoteEventos(rr);
        return resp.getReceberLoteEventosResult().getExtraElement().toString();
    }

    private String sendLotesProducaoRestrita(String xml) throws AxisFault, RemoteException, XMLStreamException {
        com.touchcomp.basementorclientwebservices.reinf.webservices.restrito.RecepcaoLoteReinfStub r = new com.touchcomp.basementorclientwebservices.reinf.webservices.restrito.RecepcaoLoteReinfStub();
        RecepcaoLoteReinfStub.ReceberLoteEventos rr = new RecepcaoLoteReinfStub.ReceberLoteEventos();
        RecepcaoLoteReinfStub.LoteEventos_type0 t = new RecepcaoLoteReinfStub.LoteEventos_type0();
        OMElement el = AXIOMUtil.stringToOM((String)xml);
        t.setExtraElement(el);
        rr.setLoteEventos(t);
        RecepcaoLoteReinfStub.ReceberLoteEventosResponse resp = r.receberLoteEventos(rr);
        return resp.getReceberLoteEventosResult().getExtraElement().toString();
    }

    private Reinf2 buildEnviarLoteEventos(ReinfLoteEventos loteEvt, R1000 opcoes) throws ExceptionReinf {
        Reinf2 envio = new Reinf2();
        Reinf2.EnvioLoteEventos lote = new Reinf2.EnvioLoteEventos();
        lote.setIdeContribuinte(this.getIdeContribuinte(opcoes));
        Reinf2.EnvioLoteEventos.Eventos eventos = new Reinf2.EnvioLoteEventos.Eventos();
        for (ReinfEvento evt : loteEvt.getEventos()) {
            eventos.getEvento().add(this.buildEvento(evt, opcoes));
        }
        lote.setEventos(eventos);
        envio.setEnvioLoteEventos(lote);
        return envio;
    }

    private TArquivoReinf buildEvento(ReinfEvento evt, R1000 opcoesReinf) throws ExceptionReinf {
        TArquivoReinf t = new TArquivoReinf();
        Evento ev = DocFactoryEventosReinf.getEvento(evt, opcoesReinf);
        t.setAny(ev);
        t.setId(evt.getIdTagEventoReinf());
        return t;
    }

    private Evento buildEventoAntigo(ReinfPreEvento evt, R1000 opcoesReinf) throws ExceptionReinf {
        Evento ev = DocFactoryEventosReinf.getEvento(evt, opcoesReinf);
        ev.setId(evt.getReinfEvento().getIdTagEventoReinf());
        return ev;
    }

    private void setStatusLote(String result, ReinfLoteEventos loteEventos) throws ExceptionJDom, ExceptionIO {
        Element reinf = ToolJdom.getRootElement((String)result, (ToolJdom.EnumToolJdomEncoding)ToolJdom.EnumToolJdomEncoding.UTF_8);
        Element retornoEnvioLoteEventos = reinf.getChild("retornoLoteEventosAssincrono", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE);
        Element status = retornoEnvioLoteEventos.getChild("status", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE);
        loteEventos.setCodStatusEnvio(Long.valueOf(status.getChildText("cdResposta", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE)));
        StringBuilder sb = new StringBuilder();
        sb.append("Lote: ");
        sb.append(status.getChildText("descResposta", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE));
        sb.append("\n\n\n");
        if (loteEventos.getCodStatusEnvio() != 1L) {
            Element retornoEventos = retornoEnvioLoteEventos.getChild("retornoEventos", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE);
            List eventos = retornoEventos.getChildren("evento", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE);
            for (Element evento : eventos) {
                String id = evento.getAttributeValue("Id");
                for (ReinfEvento eventoLote : loteEventos.getEventos()) {
                    if (!eventoLote.getIdTagEventoReinf().equals(id)) continue;
                    Element retornoEvento = evento.getChild("retornoEvento", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE_TOTAL);
                    retornoEvento.getChildren();
                    if (loteEventos.getTipoEvento().getIdentificador() < 16L && loteEventos.getTipoEvento().getIdentificador() != 14L) {
                        String statusEvento;
                        List ocorrencias;
                        Element ideStatus;
                        Element evtRetorno;
                        reinfEvento = retornoEvento.getChild("Reinf", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA);
                        boolean versaoSimplificadaV2 = false;
                        if (ToolMethods.isNull((Object)reinfEvento).booleanValue()) {
                            reinfEvento = retornoEvento.getChild("Reinf", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1);
                            versaoSimplificadaV2 = true;
                        }
                        if (versaoSimplificadaV2) {
                            evtRetorno = reinfEvento.getChild("evtTotalContrib", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1);
                            ideRecRetorno = evtRetorno.getChild("ideRecRetorno", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1);
                            ideStatus = ideRecRetorno.getChild("ideStatus", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1);
                            ocorrencias = ideStatus.getChildren("regOcorrs", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1);
                            statusEvento = ideStatus.getChildText("cdRetorno", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1);
                        } else {
                            evtRetorno = reinfEvento.getChild("evtTotal", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA);
                            ideRecRetorno = evtRetorno.getChild("ideRecRetorno", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA);
                            ideStatus = ideRecRetorno.getChild("ideStatus", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA);
                            ocorrencias = ideStatus.getChildren("regOcorrs", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA);
                            statusEvento = ideStatus.getChildText("cdRetorno", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA);
                        }
                        Long idStatus = Long.valueOf(statusEvento);
                        String descStatus = versaoSimplificadaV2 ? ideStatus.getChildText("descRetorno", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1) : ideStatus.getChildText("descRetorno", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA);
                        eventoLote.setStatus(idStatus);
                        eventoLote.setDescricaoStatus(descStatus);
                        sb.append("Evento: ");
                        sb.append(id);
                        sb.append("\nStatus: ");
                        sb.append(idStatus);
                        sb.append("\nDescricao: ");
                        sb.append(descStatus);
                        if (idStatus.equals(1L) && ocorrencias != null) {
                            for (Element ocorr : ocorrencias) {
                                sb.append("\n");
                                if (versaoSimplificadaV2) {
                                    sb.append("Codigo: ").append(ocorr.getChildText("codResp", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1)).append("\n");
                                    sb.append("Descricao Erro: ").append(ocorr.getChildText("dscResp", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1)).append("\n");
                                    sb.append("Local Erro: ").append(ocorr.getChildText("localErroAviso", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1)).append("\n");
                                    continue;
                                }
                                sb.append("Codigo: ").append(ocorr.getChildText("codResp", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA)).append("\n");
                                sb.append("Descricao Erro: ").append(ocorr.getChildText("dscResp", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA)).append("\n");
                                sb.append("Local Erro: ").append(ocorr.getChildText("localErroAviso", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA)).append("\n");
                            }
                        }
                        if (eventoLote.getStatus().equals(0L)) {
                            String nrRecibo = versaoSimplificadaV2 ? evtRetorno.getChild("infoRecEv", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1).getChildText("nrRecArqBase", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1) : evtRetorno.getChild("infoRecEv", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA).getChildText("nrRecArqBase", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA);
                            eventoLote.setNrRecibo(nrRecibo);
                            sb.append("\nNr Recibo: ");
                            sb.append(nrRecibo);
                            String dataProcess = versaoSimplificadaV2 ? evtRetorno.getChild("infoRecEv", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1).getChildText("dhProcess", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1) : evtRetorno.getChild("infoRecEv", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA).getChildText("dhProcess", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA);
                            eventoLote.setDataHoraProcessamento(dataProcess);
                            if (eventoLote.getPreEvento().getTipoEventoReinf().getCodigo().equals("R-2098")) {
                                eventoLote.getPreEvento().getR2099().setPeriodoFechado(Short.valueOf((short)0));
                            } else if (eventoLote.getPreEvento().getTipoEventoReinf().getCodigo().equals("R-2099")) {
                                eventoLote.getPreEvento().getR2099().setPeriodoFechado(Short.valueOf((short)1));
                            }
                        } else if (eventoLote.getStatus().equals(2L)) {
                            dataProcess = versaoSimplificadaV2 ? evtRetorno.getChild("infoRecEv", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1).getChildText("dhProcess", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1) : evtRetorno.getChild("infoRecEv", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA).getChildText("dhProcess", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA);
                            eventoLote.setDataHoraProcessamento(dataProcess);
                            String nrProt = versaoSimplificadaV2 ? evtRetorno.getChild("infoRecEv", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1).getChildText("nrProtEntr", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA_V1) : evtRetorno.getChild("infoRecEv", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA).getChildText("nrProtEntr", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE_VERSAO_SIMPLIFICADA);
                            eventoLote.setNumeroProtocolo(nrProt);
                            eventoLote.getReinfLoteEventos().setNumeroProtEnvio(nrProt);
                        }
                    } else {
                        reinfEvento = retornoEvento.getChild("Reinf", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
                        Element evtRetorno = reinfEvento.getChild("evtRet", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
                        Element ideRecRetorno = evtRetorno.getChild("ideRecRetorno", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
                        Element ideStatus = ideRecRetorno.getChild("ideStatus", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
                        List ocorrencias = ideStatus.getChildren("regOcorrs", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
                        String statusEvento = ideStatus.getChildText("cdRetorno", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
                        Long idStatus = Long.valueOf(statusEvento);
                        String descStatus = ideStatus.getChildText("descRetorno", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
                        eventoLote.setStatus(idStatus);
                        eventoLote.setDescricaoStatus(descStatus);
                        sb.append("Evento: ");
                        sb.append(id);
                        sb.append("\nStatus: ");
                        sb.append(idStatus);
                        sb.append("\nDescricao: ");
                        sb.append(descStatus);
                        if (idStatus.equals(1L) && ocorrencias != null) {
                            for (Element ocorr : ocorrencias) {
                                sb.append("\n");
                                sb.append("Codigo: ").append(ocorr.getChildText("codResp", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE)).append("\n");
                                sb.append("Descricao Erro: ").append(ocorr.getChildText("dscResp", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE)).append("\n");
                                sb.append("Local Erro: ").append(ocorr.getChildText("localErroAviso", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE)).append("\n");
                            }
                        }
                        if (eventoLote.getStatus().equals(0L)) {
                            String nrRecibo = evtRetorno.getChild("infoRecEv", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE).getChildText("nrRecArqBase", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
                            eventoLote.setNrRecibo(nrRecibo);
                            sb.append("\nNr Recibo: ");
                            sb.append(nrRecibo);
                            dataProcess = evtRetorno.getChild("infoRecEv", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE).getChildText("dhProcess", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
                            eventoLote.setDataHoraProcessamento(dataProcess);
                            if (eventoLote.getPreEvento().getTipoEventoReinf().getCodigo().equals("R-2098")) {
                                eventoLote.getPreEvento().getR2099().setPeriodoFechado(Short.valueOf((short)0));
                            } else if (eventoLote.getPreEvento().getTipoEventoReinf().getCodigo().equals("R-2099")) {
                                eventoLote.getPreEvento().getR2099().setPeriodoFechado(Short.valueOf((short)1));
                            }
                        } else if (eventoLote.getStatus().equals(2L)) {
                            String dataProcess = evtRetorno.getChild("infoRecEv", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE).getChildText("dhProcess", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
                            eventoLote.setDataHoraProcessamento(dataProcess);
                            String nrProt = evtRetorno.getChild("infoRecEv", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE).getChildText("nrProtEntr", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
                            eventoLote.setNumeroProtocolo(nrProt);
                            eventoLote.getReinfLoteEventos().setNumeroProtEnvio(nrProt);
                        }
                    }
                    sb.append("\n\n");
                }
            }
        }
        loteEventos.setDescricaoEnvio(sb.toString());
    }

    private void setStatusConsultaLote(String result, ReinfLoteEventos loteEventos) throws ExceptionJDom, ExceptionReinf, ExceptionIO {
        Element infoTotalContrib;
        Element reinf = ToolJdom.getRootElement((String)result);
        Element evtTotalContrib = reinf.getChild("evtTotalContrib", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
        ReinfEvento eventoLote = (ReinfEvento)loteEventos.getEventos().get(0);
        StringBuilder sb = new StringBuilder();
        sb.append("LOTE: ");
        List eventos = evtTotalContrib.getChildren("ideRecRetorno", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
        for (Element evento : eventos) {
            List ocorrencias;
            Element ideStatus = evento.getChild("ideStatus", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
            Long codStatus = Long.valueOf(ideStatus.getChildText("cdRetorno", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE));
            String descStatus = ideStatus.getChildText("descRetorno", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
            sb.append("\n Status: ").append(codStatus).append(" - ").append(descStatus);
            eventoLote.setStatus(codStatus);
            eventoLote.setDescricaoStatus(descStatus);
            if (!codStatus.equals(1L) || (ocorrencias = ideStatus.getChildren("regOcorrs", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE)) == null) continue;
            for (Element ocorr : ocorrencias) {
                sb.append("\n");
                sb.append("Codigo: ").append(ocorr.getChildText("codResp", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE)).append("\n");
                sb.append("Descricao Erro: ").append(ocorr.getChildText("dscResp", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE)).append("\n");
                sb.append("Tipo: ").append(ocorr.getChildText("tpOcorr", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE)).append("\n");
                sb.append("Local Erro: ").append(ocorr.getChildText("localErroAviso", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE)).append("\n");
            }
        }
        Element infoRecEv = evtTotalContrib.getChild("infoRecEv", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
        if (infoRecEv != null) {
            String dataProcess = infoRecEv.getChildText("dhProcess", ConstantsNamespace.NAMESPACE_RETORNO_ENVIO_LOTE_TOTAL);
            eventoLote.setDataHoraProcessamento(dataProcess);
        }
        if ((infoTotalContrib = evtTotalContrib.getChild("infoTotalContrib", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE)) != null && eventoLote.getStatus().equals(0L)) {
            String nrRecibo = infoTotalContrib.getChildText("nrRecArqBase", ConstantsNamespace.NAMESPACE_RETORNO_CONSULTA_LOTE);
            eventoLote.setNrRecibo(nrRecibo);
            sb.append("\nNr Recibo: ");
            sb.append(nrRecibo);
            eventoLote.getPreEvento().getR2099().setPeriodoFechado(Short.valueOf((short)1));
        }
        loteEventos.setDescricaoEnvio(sb.toString());
    }

    private void backupToFile(String xml, File pathEnvioLotes) throws ExceptionIO {
        if (xml != null) {
            ToolFile.writeStringInFile((String)pathEnvioLotes.getAbsolutePath(), (String)xml);
        }
    }

    private ReinfEvento getEvento(ReinfLoteEventos loteEventos, String id) throws ExceptionReinf {
        Optional<ReinfEvento> evento = loteEventos.getEventos().stream().filter(evt -> evt.getIdTagEventoReinf() != null && evt.getIdTagEventoReinf().equals(id)).findFirst();
        if (evento.isPresent()) {
            return evento.get();
        }
        throw new ExceptionReinf(EnumReinf.ID_RETORNADO_REINF_NAO_EXISTE_LOTE, new Object[]{id, loteEventos});
    }

    public String montarXml(Reinf2 enviarLoteEventos) throws ExceptionJaxb, ExceptionCertificado, ExceptionAssinaturaXML, ExceptionIO {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        sb.append("<Reinf xmlns=\"http://www.reinf.esocial.gov.br/schemas/envioLoteEventosAssincrono/v1_00_00\">");
        sb.append("<envioLoteEventos>");
        sb.append("<ideContribuinte>");
        sb.append("<tpInsc>");
        sb.append(enviarLoteEventos.getEnvioLoteEventos().getIdeContribuinte().getTpInsc());
        sb.append("</tpInsc>");
        sb.append("<nrInsc>");
        sb.append(enviarLoteEventos.getEnvioLoteEventos().getIdeContribuinte().getNrInsc());
        sb.append("</nrInsc>");
        sb.append("</ideContribuinte>");
        sb.append("<eventos>");
        for (TArquivoReinf evento : enviarLoteEventos.getEnvioLoteEventos().getEventos().getEvento()) {
            String id = evento.getId();
            evento.setId(null);
            String ev = ToolJaxb.toXMl((Object)evento.getAny());
            ev = ev.substring("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>".length());
            sb.append("<evento Id=\"" + id + "\">");
            ev = ev.replace("xmlns=\"http://www.reinf.esocial.gov.br/schemas/envioLoteEventos/v1_05_01\"", "");
            sb.append(ev);
            sb.append("</evento>");
            evento.setId(id);
        }
        sb.append("</eventos>");
        sb.append("</envioLoteEventos></Reinf>");
        String xml = sb.toString();
        xml = xml.replace("ns2:", "");
        xml = xml.replace(":ns2", "");
        xml = SignatureXmlReinf.assinarXML(xml);
        return xml;
    }

    private void salvarXml(String temp, String id) {
        ServiceXMLEventoEsocial serviceXmlEsocial = (ServiceXMLEventoEsocial)ConfApplicationContext.getBean(ServiceXMLEventoEsocial.class);
        XMLEventoEsocial xml = serviceXmlEsocial.getOrCreateByChave(id);
        xml.setConteudoXML(temp);
        serviceXmlEsocial.saveOrUpdate((Object)xml);
    }

    private void salvarAprovacao(Element evento) {
        ServiceXMLEventoEsocial serviceXmlEsocial = (ServiceXMLEventoEsocial)ConfApplicationContext.getBean(ServiceXMLEventoEsocial.class);
        XMLEventoEsocial xml = serviceXmlEsocial.getOrCreateByChave(evento.getAttributeValue("Id"));
        xml.setConteudoAprovacao(ToolJdom.toXml((Element)evento));
        serviceXmlEsocial.saveOrUpdate((Object)xml);
    }

    private String sendConsultaLoteEventos(ReinfLoteEventos loteEventos) throws AxisFault, XMLStreamException, RemoteException, ExceptionReinf {
        ConsultasReinfStub r = new ConsultasReinfStub();
        ConsultasReinfStub.ConsultaResultadoFechamento2099 rr = new ConsultasReinfStub.ConsultaResultadoFechamento2099();
        ReinfEvento evento = (ReinfEvento)loteEventos.getEventos().get(0);
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(evento.getPreEvento().getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        rr.setTpInsc(new UnsignedByte(tipoInscricao));
        rr.setNrInsc(ToolReinf.getNrInscricaoEmpresa(evento.getPreEvento().getEmpresa()));
        rr.setNumeroProtocoloFechamento(loteEventos.getNumeroProtEnvio());
        ConsultasReinfStub.ConsultaResultadoFechamento2099Response resp = r.consultaResultadoFechamento2099(rr);
        return resp.getConsultaResultadoFechamento2099Result().getExtraElement().toString();
    }

    private String sendConsultaLoteEventosRestrito(ReinfLoteEventos loteEventos) throws AxisFault, XMLStreamException, RemoteException, ExceptionReinf {
        com.touchcomp.basementorclientwebservices.reinf.webservices.restrito.ConsultasReinfStub r = new com.touchcomp.basementorclientwebservices.reinf.webservices.restrito.ConsultasReinfStub();
        ConsultasReinfStub.ConsultaResultadoFechamento2099 rr = new ConsultasReinfStub.ConsultaResultadoFechamento2099();
        ReinfEvento evento = (ReinfEvento)loteEventos.getEventos().get(0);
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(evento.getPreEvento().getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        rr.setTpInsc(new UnsignedByte(tipoInscricao));
        rr.setNrInsc(ToolReinf.getNrInscricaoEmpresa(evento.getPreEvento().getEmpresa()));
        rr.setNumeroProtocoloFechamento(loteEventos.getNumeroProtEnvio());
        ConsultasReinfStub.ConsultaResultadoFechamento2099Response resp = r.consultaResultadoFechamento2099(rr);
        String teste = resp.getConsultaResultadoFechamento2099Result().getExtraElement().toString();
        System.out.println("\n\n");
        System.out.println(teste);
        return teste;
    }

    private TIdeContribuinte getIdeContribuinte(R1000 opcoes) throws ExceptionReinf {
        TIdeContribuinte empregador = new TIdeContribuinte();
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(opcoes.getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        empregador.setTpInsc(Byte.parseByte(tipoInscricao));
        empregador.setNrInsc(ToolReinf.getNrInscricaoEmpresa(opcoes.getEmpresa()));
        return empregador;
    }
}

