/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.cotacaomoedabancocentral;

import com.touchcomp.basementorclientwebservices.cotacaomoedabancocentral.BCBCliente;
import com.touchcomp.basementorclientwebservices.cotacaomoedabancocentral.SafeDateFormat;
import com.touchcomp.basementorlogger.TLogger;
import java.io.PrintStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ClienteBCB
extends BCBCliente {
    private static final TLogger logger = TLogger.get(ClienteBCB.class);
    private XMLInputFactory inputFactory;
    private SafeDateFormat dateFormat;
    private static ClienteBCB instance;
    public static final String BAD_ENTITY = "&([^;\\W]*([^;\\w]|$))";
    public static final String FIX_BAD_ENTITY = "&amp;$1";

    public static ClienteBCB getInstance() {
        if (instance == null) {
            instance = new ClienteBCB();
        }
        return instance;
    }

    private ClienteBCB() {
        try {
            this.inputFactory = XMLInputFactory.newInstance();
            this.inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            this.inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        }
        catch (FactoryConfigurationError e) {
            logger.error(e.toString());
        }
        this.dateFormat = new SafeDateFormat();
    }

    public String extraiResumo(String xml) {
        StringBuilder sb = null;
        if (xml != null) {
            String separator = ": ";
            sb = new StringBuilder();
            try {
                XMLStreamReader rd = this.inputFactory.createFilteredReader(this.inputFactory.createXMLStreamReader(new StringReader(xml.replaceAll(BAD_ENTITY, FIX_BAD_ENTITY))), new ExcludeFilter(this, "resposta", "SERIE"));
                do {
                    sb.append(rd.getLocalName()).append(": ").append(rd.getElementText()).append(NEWLINE);
                    rd.next();
                } while (!rd.getLocalName().equals("DATA"));
                do {
                    sb.append(rd.getLocalName()).append(": ");
                    rd.next();
                    sb.append(rd.getElementText());
                    rd.next();
                    sb.append('/').append(rd.getElementText());
                    rd.next();
                    sb.append('/').append(rd.getElementText());
                    rd.next();
                    sb.append(NEWLINE);
                    rd.next();
                } while (!rd.getLocalName().equals("VALOR"));
                sb.append(rd.getLocalName()).append(": ").append(rd.getElementText());
                rd.close();
            }
            catch (XMLStreamException e) {
                logger.error(e.toString());
            }
        }
        return sb != null ? sb.toString() : null;
    }

    public VO extraiUltimoValor(String xml) {
        VO vo = null;
        if (xml != null) {
            try {
                XMLStreamReader rd = this.inputFactory.createFilteredReader(this.inputFactory.createXMLStreamReader(new StringReader(xml.replaceAll(BAD_ENTITY, FIX_BAD_ENTITY))), new ExcludeFilter(this, "resposta", "SERIE", "NOME", "PERIODICIDADE", "UNIDADE"));
                String sCodigo = rd.getElementText();
                rd.next();
                String[] sDatas = new String[]{null, null};
                int j = 0;
                do {
                    rd.next();
                    char[] buf = new char[10];
                    int pos = 0;
                    for (int i = 0; i < 3; ++i) {
                        char[] s = rd.getElementText().toCharArray();
                        rd.next();
                        System.arraycopy(s, 0, buf, pos, s.length);
                        pos += s.length;
                        if (i >= 2) continue;
                        buf[pos++] = 47;
                    }
                    sDatas[j++] = new String(buf, 0, pos);
                    rd.next();
                } while (!rd.getLocalName().equals("VALOR"));
                String sValor = rd.getElementText();
                rd.close();
                vo = new VO(this, sCodigo, sDatas[0], sDatas[1], sValor);
            }
            catch (XMLStreamException e) {
                logger.error(e.toString());
            }
        }
        return vo;
    }

    public VO[][] extraiSeries(String xml) {
        ArrayList<VO[]> LISTA = new ArrayList<VO[]>();
        if (xml != null) {
            try {
                ArrayList<VO> lista = new ArrayList<VO>();
                XMLStreamReader rd = this.inputFactory.createFilteredReader(this.inputFactory.createXMLStreamReader(new StringReader(xml)), new ExcludeFilter(this, "SERIES", "ITEM", "BLOQUEADO"));
                do {
                    String sCodigo = rd.getAttributeValue(null, "ID");
                    while (rd.next() == 1 && rd.getLocalName().equals("DATA")) {
                        String[] sDatas = new String[]{null, null};
                        int j = 0;
                        while (!rd.getLocalName().equals("VALOR")) {
                            sDatas[j] = this.dateFormat.complete(rd.getElementText());
                            rd.next();
                            ++j;
                        }
                        String sValor = rd.getElementText();
                        if (sValor.length() <= 0) continue;
                        VO vo = new VO(this, sCodigo, sDatas[0], sDatas[1], sValor);
                        lista.add(vo);
                    }
                    VO[] array = lista.toArray(new VO[lista.size()]);
                    lista.clear();
                    LISTA.add(array);
                    rd.next();
                } while (rd.isStartElement() && rd.getLocalName().equals("SERIE"));
                rd.close();
            }
            catch (XMLStreamException e) {
                logger.error(e.toString());
            }
        }
        VO[][] array = (VO[][])LISTA.toArray((T[])new VO[LISTA.size()][]);
        LISTA.clear();
        return array;
    }

    public VO extraiValor(long codigo, String data) {
        VO[] array;
        VO v = null;
        String xml = this.getValoresSeriesXML(new long[]{codigo}, data, data);
        if (xml != null && (array = this.extraiSeries(xml)[0]).length > 0) {
            v = array[0];
        }
        return v;
    }

    public static void main(String[] args) {
        PrintStream out = System.out;
        int n = args.length;
        if (n == 0) {
            out.format("%nPossiveis argumentos:%n%n", new Object[0]);
            out.println("  (1): codigo");
            out.println("  (2): codigo data");
            out.println("  (3): codigo(s) data_inicial data_final");
            out.format("%nFormatos de datas:%n%n", new Object[0]);
            out.println("  (1): dd/MM/aaaa");
            out.println("  (2): MM/aaaa");
            out.format("%nO formato (2) equivale a 01/MM/aaaa%n%n", new Object[0]);
        } else {
            String noDataToPrint = "No data to print.";
            String invalidDate = "Erro: Data invalida.";
            ClienteBCB c = new ClienteBCB();
            if (n == 1) {
                long codigo = Long.parseLong(args[0]);
                String xml = c.getUltimoValorXML(codigo);
                if (xml != null) {
                    String text = c.extraiResumo(xml);
                    out.println(text);
                } else {
                    out.println("No data to print.");
                }
            } else if (n == 2) {
                long codigo = Long.parseLong(args[0]);
                String data = args[1].replaceAll("^(\\d\\d?/\\d{4})$", "1/$1");
                if (c.dateFormat.isValid(data)) {
                    VO w = c.extraiValor(codigo, data);
                    if (w != null) {
                        out.println(w.toString());
                    } else {
                        out.println("No data to print.");
                    }
                } else {
                    out.println("Erro: Data invalida.");
                }
            } else {
                long[] codigos = new long[n - 2];
                for (int i = 0; i < n - 2; ++i) {
                    codigos[i] = Long.parseLong(args[i]);
                }
                String data_ini = args[n - 2].replaceAll("^(\\d\\d?/\\d{4})$", "1/$1");
                String data_fim = args[n - 1].replaceAll("^(\\d\\d?/\\d{4})$", "1/$1");
                if (c.dateFormat.isValid(data_ini) && c.dateFormat.isValid(data_fim)) {
                    String xml = c.getValoresSeriesXML(codigos, data_ini, data_fim);
                    if (xml != null) {
                        VO[][] series = c.extraiSeries(xml);
                        int k = 0;
                        for (long codigo : codigos) {
                            int rank;
                            if (1 < ++k) {
                                out.println();
                            }
                            for (rank = 0; rank < codigos.length && (series[rank].length == 0 || series[rank][0].getCodigo() != codigo); ++rank) {
                            }
                            if (rank < codigos.length) {
                                for (VO v : series[rank]) {
                                    out.println(v.toString());
                                }
                                continue;
                            }
                            out.format("%03d: %s%n", codigo, "No data to print.");
                        }
                    } else {
                        out.println("No data to print.");
                    }
                } else {
                    out.println("Erro: Data invalida.");
                    System.exit(1);
                }
            }
        }
    }

    private class ExcludeFilter
    implements StreamFilter {
        private String[] tagNames;

        public ExcludeFilter(ClienteBCB clienteBCB, String ... names) {
            this.tagNames = names;
            Arrays.sort(this.tagNames);
        }

        @Override
        public boolean accept(XMLStreamReader rd) {
            return rd.hasName() && Arrays.binarySearch(this.tagNames, rd.getLocalName()) < 0;
        }
    }

    public class VO {
        protected long codigo;
        protected Date data;
        protected Date dataFim;
        protected BigDecimal valor;
        public static final String fmt3 = "%1$03d %2$td/%2$tm/%2$tY %3$7.4f";
        public static final String fmt4 = "%1$03d %2$td/%2$tm/%2$tY %3$td/%3$tm/%3$tY %4$7.4f";

        public VO(ClienteBCB this$0, String sCodigo, String sData, String sDataFim, String sValor) {
            this.codigo = Long.parseLong(sCodigo);
            try {
                this.data = this$0.dateFormat.parse(sData);
                if (sDataFim != null) {
                    this.dataFim = this$0.dateFormat.parse(sDataFim);
                }
            }
            catch (ParseException e) {
                logger.error(e.toString());
            }
            if (sValor.indexOf(46) >= 0 && sValor.indexOf(44) >= 0) {
                sValor = sValor.replaceAll("\\.", "");
            }
            this.valor = new BigDecimal(sValor.replace(',', '.'));
        }

        public VO(ClienteBCB this$0, String sCodigo, String sData, String sValor) {
            this(this$0, sCodigo, sData, null, sValor);
        }

        public long getCodigo() {
            return this.codigo;
        }

        public Date getData() {
            return this.data;
        }

        public Date getDataFim() {
            return this.dataFim;
        }

        public BigDecimal getValor() {
            return this.valor;
        }

        public String toString() {
            return this.dataFim == null ? String.format(fmt3, this.codigo, this.data, this.valor) : String.format(fmt4, this.codigo, this.data, this.dataFim, this.valor);
        }
    }
}

