/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.cte.cte;

import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaInfoCTeAnulacao;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNota;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaEndereco;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaEnderecoEmitente;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfo;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoAutorizacaoDownload;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeComplementar;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoDestinatario;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoEmitente;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoExpedidorCarga;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoIdentificacao;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoIdentificacaoTomadorServico4;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoRecebedorCarga;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoRemetente;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoResponsavelTecnico;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoValorPrestacaoServico;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoValorPrestacaoServicoComponentesValorPrestacao;
import com.fincatto.documentofiscal.utils.DFPersister;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.cte.sefaz.ConstCTeFinalidade;
import com.touchcomp.basementor.constants.enums.cte.sefaz.ConstCTeIndicadorTomador;
import com.touchcomp.basementor.constants.enums.cte.sefaz.ConstCTeModal;
import com.touchcomp.basementor.constants.enums.cte.sefaz.ConstCTeProcessoEmissao;
import com.touchcomp.basementor.constants.enums.cte.sefaz.ConstCTeRetirada;
import com.touchcomp.basementor.constants.enums.cte.sefaz.ConstCTeTipoEmissao;
import com.touchcomp.basementor.constants.enums.cte.sefaz.ConstCTeTipoImpressao;
import com.touchcomp.basementor.constants.enums.cte.sefaz.ConstCTeTipoServico;
import com.touchcomp.basementor.constants.enums.cte.sefaz.ConstCTeTomadorServico;
import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementorclientwebservices.UtilMethods;
import com.touchcomp.basementorclientwebservices.cte.cte.WebCTeDadosComplementares;
import com.touchcomp.basementorclientwebservices.cte.cte.WebCTeImpostos;
import com.touchcomp.basementorclientwebservices.cte.cte.WebCTeNormal;
import com.touchcomp.basementorclientwebservices.cte.model.env.CTNota;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.LinkedList;
import java.util.List;

public class WebCTe {
    WebCTeDadosComplementares webComplementares = new WebCTeDadosComplementares();
    WebCTeImpostos webImpostos = new WebCTeImpostos();
    WebCTeNormal webCTeNormal = new WebCTeNormal();

    public CTNota readXML(String xml) throws Exception {
        try {
            CTeNota nota = (CTeNota)new DFPersister().read(CTeNota.class, xml);
            return this.convertCTe(nota);
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
    }

    public CTNota convertCTe(CTeNota cte) {
        if (cte == null || cte.getCteNotaInfo() == null) {
            return null;
        }
        CTeNotaInfo info = cte.getCteNotaInfo();
        CTNota ct = new CTNota();
        ct.setAutorizacaoDownload(this.getAutorizadoDownload(info.getAutorizacaoDownload()));
        ct.setChaveCTe(info.getChaveAcesso());
        ct.setCteComplementar(this.getCTeComplementar((CTeNotaInfoCTeComplementar)info.getCteComplementar().get(0)));
        ct.setDestinatario(this.getDestinatario(info.getDestinatario()));
        ct.setEmitente(this.getEmitente(info.getEmitente()));
        ct.setExpedidorCarga(this.getExpedidor(info.getExpedidorCarga()));
        ct.setIdentificacao(this.getIdentificacao(info.getIdentificacao()));
        ct.setIdentificador(info.getIdentificador());
        ct.setInformacaoResposavelTecnico(this.getRespTecnico(info.getInformacaoResposavelTecnico()));
        ct.setRecebedorCarga(this.getRecebedor(info.getRecebedorCarga()));
        ct.setRemetente(this.getRemetente(info.getRemetente()));
        ct.setValorPrestacaoServico(this.getValores(info.getValorPrestacaoServico()));
        ct.setVersao(info.getVersao());
        return ct;
    }

    List<CTNota.AutorizacaoDownload> getAutorizadoDownload(List<CTeNotaInfoAutorizacaoDownload> aux) {
        LinkedList<CTNota.AutorizacaoDownload> ret = new LinkedList<CTNota.AutorizacaoDownload>();
        if (aux == null) {
            return ret;
        }
        for (CTeNotaInfoAutorizacaoDownload a : aux) {
            CTNota.AutorizacaoDownload i = new CTNota.AutorizacaoDownload();
            if (ToolMethods.isStrWithData((String)a.getCnpj())) {
                i.setCnpjCpf(a.getCnpj());
            } else {
                i.setCnpjCpf(a.getCpf());
            }
            ret.add(i);
        }
        return ret;
    }

    CTNota.CTeAnulacao getCTeAnulacao(CTeNotaInfoCTeAnulacao aux) {
        if (aux == null) {
            return null;
        }
        CTNota.CTeAnulacao a = new CTNota.CTeAnulacao();
        a.setChave(aux.getChave());
        a.setDataEmissao(aux.getDataEmissao());
        return a;
    }

    CTNota.CTeComplementar getCTeComplementar(CTeNotaInfoCTeComplementar aux) {
        if (aux == null) {
            return null;
        }
        CTNota.CTeComplementar a = new CTNota.CTeComplementar();
        a.setChave(aux.getChave());
        return a;
    }

    CTNota.Destinatario getDestinatario(CTeNotaInfoDestinatario aux) {
        if (aux == null) {
            return null;
        }
        CTNota.Destinatario a = new CTNota.Destinatario();
        if (ToolMethods.isStrWithData((String)aux.getCnpj())) {
            a.setCnpjCpf(aux.getCnpj());
        } else {
            a.setCnpjCpf(aux.getCpf());
        }
        a.setEmail(aux.getEmail());
        a.setEndereco(this.getEndereco(aux.getEndereco()));
        a.setInscricaoEstadual(aux.getInscricaoEstadual());
        a.setInscricaoSuframa(aux.getInscricaoSuframa());
        a.setRazaoSocial(aux.getRazaoSocial());
        a.setTelefone(aux.getTelefone());
        return a;
    }

    CTNota.CTNotaEndereco getEndereco(CTeNotaEndereco aux) {
        if (aux == null) {
            return null;
        }
        CTNota.CTNotaEndereco a = new CTNota.CTNotaEndereco();
        a.setBairro(aux.getBairro());
        a.setCep(aux.getCep());
        a.setCodigoMunicipio(aux.getCodigoMunicipio());
        if (aux.getCodigoPais() != null) {
            a.setCodigoPais(aux.getCodigoPais().getCodigo().toString());
        }
        a.setComplemento(aux.getComplemento());
        a.setDescricaoMunicipio(aux.getDescricaoMunicipio());
        a.setDescricaoPais(aux.getDescricaoPais());
        a.setLogradouro(aux.getLogradouro());
        a.setNumero(aux.getNumero());
        a.setSiglaUF(aux.getSiglaUF());
        return a;
    }

    CTNota.Emitente.CTNotaEnderecoEmitente getEndereco(CTeNotaEnderecoEmitente aux) {
        if (aux == null) {
            return null;
        }
        CTNota.Emitente.CTNotaEnderecoEmitente a = new CTNota.Emitente.CTNotaEnderecoEmitente();
        a.setBairro(aux.getBairro());
        a.setCep(aux.getCep());
        a.setCodigoMunicipio(aux.getCodigoMunicipio());
        a.setComplemento(aux.getComplemento());
        a.setDescricaoMunicipio(aux.getDescricaoMunicipio());
        a.setLogradouro(aux.getLogradouro());
        a.setNumero(aux.getNumero());
        a.setSiglaUF(aux.getSiglaUF());
        a.setTelefone(aux.getTelefone());
        return a;
    }

    CTNota.Emitente getEmitente(CTeNotaInfoEmitente aux) {
        if (aux == null) {
            return null;
        }
        CTNota.Emitente a = new CTNota.Emitente();
        a.setCnpj(aux.getCnpj());
        a.setEndereco(this.getEndereco(aux.getEnderEmit()));
        a.setInscricaoEstadual(aux.getInscricaoEstadual());
        a.setInscricaoEstadualST(aux.getInscricaoEstadualST());
        a.setNomeFantasia(aux.getNomeFantasia());
        a.setRazaoSocial(aux.getRazaoSocial());
        return a;
    }

    CTNota.ExpedidorCarga getExpedidor(CTeNotaInfoExpedidorCarga aux) {
        if (aux == null) {
            return null;
        }
        CTNota.ExpedidorCarga a = new CTNota.ExpedidorCarga();
        if (ToolMethods.isStrWithData((String)aux.getCnpj())) {
            a.setCnpjCpf(aux.getCnpj());
        } else {
            a.setCnpjCpf(aux.getCpf());
        }
        a.setEmail(aux.getEmail());
        a.setEndereco(this.getEndereco(aux.getEndereco()));
        a.setInscricaoEstadual(aux.getInscricaoEstadual());
        a.setRazaoSocial(aux.getRazaoSocial());
        a.setTelefone(aux.getTelefone());
        return a;
    }

    CTNota.Identificacao getIdentificacao(CTeNotaInfoIdentificacao aux) {
        if (aux == null) {
            return null;
        }
        CTNota.Identificacao a = new CTNota.Identificacao();
        if (aux.getAmbiente() != null) {
            a.setAmbiente(ConstAmbiente.valueOfCodigo((String)aux.getAmbiente().getCodigo()));
        }
        a.setCfop(aux.getCfop());
        a.setCodigoMunicipioEnvio(aux.getCodigoMunicipioEnvio());
        a.setCodigoMunicipioFim(aux.getCodigoMunicipioFim());
        a.setCodigoMunicipioInicio(aux.getCodigoMunicipioInicio());
        a.setCodigoNumerico(aux.getCodigoNumerico());
        if (aux.getCodigoUF() != null) {
            a.setCodigoUF(EnumConstUF.valueOfCodigoIbge((String)aux.getCodigoUF().getCodigoIbge()));
        }
        a.setDataContingencia(aux.getDataContingencia());
        a.setDataEmissao(aux.getDataEmissao());
        a.setDescricaoMunicipioEnvio(aux.getDescricaoMunicipioEnvio());
        a.setDescricaoMunicipioFim(aux.getDescricaoMunicipioFim());
        a.setDescricaoMunicipioInicio(aux.getDescricaoMunicipioInicio());
        a.setDetalheRetira(aux.getDetalheRetira());
        a.setDigitoVerificador(aux.getDigitoVerificador());
        if (aux.getFinalidade() != null) {
            a.setFinalidade(ConstCTeFinalidade.valueOfCodigo((String)aux.getFinalidade().getCodigo()));
        }
        if (aux.getIndIEToma() != null) {
            a.setIndIEToma(ConstCTeIndicadorTomador.valueOfCodigo((String)aux.getIndIEToma().getCodigo()));
        }
        a.setIndicadorGlobalizado(aux.getIndicadorGlobalizado());
        a.setJustificativa(aux.getJustificativa());
        if (aux.getModalidadeFrete() != null) {
            a.setModalidadeFrete(ConstCTeModal.valueOfCodigo((String)aux.getModalidadeFrete().getCodigo()));
        }
        if (aux.getModelo() != null) {
            a.setModelo(EnumConstModDocFiscal.get((Object)aux.getModelo().getCodigo()));
        }
        a.setNaturezaOperacao(aux.getNaturezaOperacao());
        a.setNumero(aux.getNumero());
        if (aux.getProcessoEmissao() != null) {
            a.setProcessoEmissao(ConstCTeProcessoEmissao.valueOfCodigo((String)aux.getProcessoEmissao().getCodigo()));
        }
        if (aux.getRetira() != null) {
            a.setRetira(ConstCTeRetirada.valueOfCodigo((String)aux.getRetira().getCodigo()));
        }
        a.setSerie(aux.getSerie());
        a.setSiglaUFEnvio(aux.getSiglaUFEnvio());
        a.setSiglaUfFim(aux.getSiglaUfFim());
        a.setSiglaUfInicio(aux.getSiglaUfInicio());
        if (aux.getTipoEmissao() != null) {
            a.setTipoEmissao(ConstCTeTipoEmissao.valueOfCodigo((String)aux.getTipoEmissao().getCodigo()));
        }
        if (aux.getTipoImpressao() != null) {
            a.setTipoImpressao(ConstCTeTipoImpressao.valueOfCodigo((String)aux.getTipoImpressao().getCodigo()));
        }
        if (aux.getTipoServico() != null) {
            a.setTipoServico(ConstCTeTipoServico.valueOfCodigo((String)aux.getTipoServico().getCodigo()));
        }
        if (aux.getTomadorServico3() != null && aux.getTomadorServico3().getTomadorServico() != null) {
            a.setTomadorServico3(ConstCTeTomadorServico.valueOfCodigo((String)aux.getTomadorServico3().getTomadorServico().getCodigo()));
        }
        a.setTomadorServico4(this.getTomador4(aux.getTomadorServico4()));
        a.setVersaoProcessoEmissao(aux.getVersaoProcessoEmissao());
        return a;
    }

    CTNota.CTTomadorServico4 getTomador4(CTeNotaInfoIdentificacaoTomadorServico4 aux) {
        if (aux == null) {
            return null;
        }
        CTNota.CTTomadorServico4 a = new CTNota.CTTomadorServico4();
        if (ToolMethods.isStrWithData((String)aux.getCnpj())) {
            a.setCnpjCpf(aux.getCnpj());
        } else {
            a.setCnpjCpf(aux.getCpf());
        }
        a.setEmail(aux.getEmail());
        a.setEnderTomadorServico(this.getEndereco(aux.getEnderTomadorServico()));
        a.setInscricaoEstadual(aux.getInscricaoEstadual());
        a.setNomeFantasia(aux.getNomeFantasia());
        a.setRazaoSocial(aux.getRazaoSocial());
        a.setTelefone(aux.getTelefone());
        if (aux.getTomadorServico() != null) {
            a.setTomadorServico(ConstCTeIndicadorTomador.valueOfCodigo((String)aux.getTomadorServico().getCodigo()));
        }
        return a;
    }

    CTNota.ResponsavelTecnico getRespTecnico(CTeNotaInfoResponsavelTecnico aux) {
        if (aux == null) {
            return null;
        }
        CTNota.ResponsavelTecnico a = new CTNota.ResponsavelTecnico();
        a.setCnpj(aux.getCnpj());
        a.setContatoNome(aux.getContatoNome());
        a.setEmail(aux.getEmail());
        a.setHashCSRT(aux.getHashCSRT());
        a.setIdCSRT(aux.getIdCSRT());
        a.setTelefone(aux.getTelefone());
        return a;
    }

    CTNota.RecebedorCarga getRecebedor(CTeNotaInfoRecebedorCarga aux) {
        if (aux == null) {
            return null;
        }
        CTNota.RecebedorCarga a = new CTNota.RecebedorCarga();
        if (ToolMethods.isStrWithData((String)aux.getCnpj())) {
            a.setCnpjCpf(aux.getCnpj());
        } else {
            a.setCnpjCpf(aux.getCpf());
        }
        a.setEmail(aux.getEmail());
        a.setEndereco(this.getEndereco(aux.getEndereco()));
        a.setInscricaoEstadual(aux.getInscricaoEstadual());
        a.setRazaoSocial(aux.getRazaoSocial());
        a.setTelefone(aux.getTelefone());
        return a;
    }

    CTNota.Remetente getRemetente(CTeNotaInfoRemetente aux) {
        if (aux == null) {
            return null;
        }
        CTNota.Remetente a = new CTNota.Remetente();
        if (ToolMethods.isStrWithData((String)aux.getCnpj())) {
            a.setCnpjCpf(aux.getCnpj());
        } else {
            a.setCnpjCpf(aux.getCpf());
        }
        a.setEmail(aux.getEmail());
        a.setEndereco(this.getEndereco(aux.getEndereco()));
        a.setInscricaoEstadual(aux.getInscricaoEstadual());
        a.setNomeFantasia(aux.getNomeFantasia());
        a.setRazaoSocial(aux.getRazaoSocial());
        a.setTelefone(aux.getTelefone());
        return a;
    }

    CTNota.ValorPrestacaoServico getValores(CTeNotaInfoValorPrestacaoServico aux) {
        if (aux == null) {
            return null;
        }
        CTNota.ValorPrestacaoServico a = new CTNota.ValorPrestacaoServico();
        a.setComponentesValorPrestacao(this.getComponentes(aux.getComponentesValorPrestacao()));
        a.setValorReceber(UtilMethods.valueOfDouble(aux.getValorReceber()));
        a.setValorTotalPrestacaoServico(UtilMethods.valueOfDouble(aux.getValorTotalPrestacaoServico()));
        return a;
    }

    List<CTNota.ValorPrestacaoServico.Componentes> getComponentes(List<CTeNotaInfoValorPrestacaoServicoComponentesValorPrestacao> aux) {
        LinkedList<CTNota.ValorPrestacaoServico.Componentes> ret = new LinkedList<CTNota.ValorPrestacaoServico.Componentes>();
        if (aux == null) {
            return ret;
        }
        for (CTeNotaInfoValorPrestacaoServicoComponentesValorPrestacao i : aux) {
            CTNota.ValorPrestacaoServico.Componentes a = new CTNota.ValorPrestacaoServico.Componentes();
            a.setNomeComponente(i.getNomeComponente());
            a.setValorComponente(UtilMethods.valueOfDouble(i.getValorComponente()));
            ret.add(a);
        }
        return ret;
    }
}

