/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtaltcontrato;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocTreinamentoColaborador;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcontratual.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcontratual.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcontratual.v_s_01_03_00.TAprend;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcontratual.v_s_01_03_00.THorContratual;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcontratual.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcontratual.v_s_01_03_00.TIdeEventoTrab;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcontratual.v_s_01_03_00.TIdeVinculo;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcontratual.v_s_01_03_00.TLocalTrabGeral;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcontratual.v_s_01_03_00.TRemuneracao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcontratual.v_s_01_03_00.TSSimNao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtaltcontratual.v_s_01_03_00.TTreiCap;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public class ImpEvtAltContrato
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial root = this.getFact().createESocial();
        root.setEvtAltContratual(this.getEvtAlteracaoContratual(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtAltContratual getEvtAlteracaoContratual(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtAltContratual evt = this.getFact().createESocialEvtAltContratual();
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEmpregador(this.getEmpregador(opcoes));
        evt.setIdeEvento(this.getTiCadastro(preEvento.getEsocEvento(), opcoes));
        evt.setIdeVinculo(this.getVinculo(preEvento));
        evt.setAltContratual(this.getAlteracaoContrato(preEvento));
        return evt;
    }

    private TIdeEmpregador getEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoTrab getTiCadastro(EsocEvento esocEvento, OpcoesESocial opcoes) {
        TIdeEventoTrab tiTrab = this.getFact().createTIdeEventoTrab();
        tiTrab.setTpAmb(Byte.parseByte(esocEvento.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (esocEvento.getPreEvento().getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(esocEvento.getPreEvento().getNumeroReciboRetificado());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        return tiTrab;
    }

    private TIdeVinculo getVinculo(EsocPreEvento preEvento) {
        Colaborador colaborador = preEvento.getColaborador();
        TIdeVinculo vinculo = this.getFact().createTIdeVinculo();
        vinculo.setCpfTrab(ToolString.refina((String)colaborador.getPessoa().getComplemento().getCnpj()));
        vinculo.setMatricula(colaborador.getNumeroRegistroESocial());
        return vinculo;
    }

    private ESocial.EvtAltContratual.AltContratual getAlteracaoContrato(EsocPreEvento preEvento) throws ExceptionEsocial {
        ESocial.EvtAltContratual.AltContratual alt = this.getFact().createESocialEvtAltContratualAltContratual();
        if (preEvento.getColaboradorSalario() == null) {
            alt.setDtAlteracao(ToolEsocial.converteData(preEvento.getDataInicioVal()));
            if (preEvento.getObservacoes() != null && preEvento.getObservacoes().length() > 1) {
                alt.setDscAlt(preEvento.getObservacoes());
            }
        } else {
            alt.setDtAlteracao(ToolEsocial.converteData(preEvento.getColaboradorSalario().getPeriodo()));
            if (preEvento.getObservacoes() != null && preEvento.getObservacoes().length() > 1) {
                alt.setDscAlt(preEvento.getObservacoes());
            }
        }
        alt.setVinculo(this.getVinculoColaborador(preEvento.getColaborador(), preEvento));
        return alt;
    }

    private ESocial.EvtAltContratual.AltContratual.Vinculo getVinculoColaborador(Colaborador colaborador, EsocPreEvento preEvento) throws ExceptionEsocial {
        ESocial.EvtAltContratual.AltContratual.Vinculo vinculo = this.getFact().createESocialEvtAltContratualAltContratualVinculo();
        vinculo.setTpRegPrev(Byte.parseByte(colaborador.getRegimePrevidenciario().getCodigo()));
        vinculo.setInfoContrato(this.getInfoContrato(preEvento));
        vinculo.setInfoRegimeTrab(this.getInfoRegimeTrab(preEvento.getColaborador()));
        return vinculo;
    }

    private ESocial.EvtAltContratual.AltContratual.Vinculo.InfoRegimeTrab getInfoRegimeTrab(Colaborador colaborador) throws ExceptionEsocial {
        ESocial.EvtAltContratual.AltContratual.Vinculo.InfoRegimeTrab infoCeletista = this.getFact().createESocialEvtAltContratualAltContratualVinculoInfoRegimeTrab();
        infoCeletista.setInfoCeletista(this.getInfoCeletista(colaborador));
        return infoCeletista;
    }

    private ESocial.EvtAltContratual.AltContratual.Vinculo.InfoRegimeTrab.InfoCeletista getInfoCeletista(Colaborador colaborador) throws ExceptionEsocial {
        ESocial.EvtAltContratual.AltContratual.Vinculo.InfoRegimeTrab.InfoCeletista info = this.getFact().createESocialEvtAltContratualAltContratualVinculoInfoRegimeTrabInfoCeletista();
        if (colaborador.getRegimeJornadaTrabalho() == null) {
            throw new ExceptionEsocial("Colaborador: " + colaborador.toString() + " Sem Regime de Jornada Informado");
        }
        info.setTpRegJor(Byte.parseByte(colaborador.getRegimeJornadaTrabalho().getCodigo()));
        if (colaborador.getNaturezaAtividade() == null) {
            throw new ExceptionEsocial("Colaborador: " + colaborador.toString() + " Sem Natureza de Atividade Informado");
        }
        info.setNatAtividade(Byte.parseByte(colaborador.getNaturezaAtividade().getCodigo()));
        if (colaborador.getSindicato() != null && colaborador.getSindicato().getMesDataBase() != null) {
            info.setDtBase(Byte.valueOf(String.valueOf(colaborador.getSindicato().getMesDataBase())));
        }
        if (colaborador.getSindicato() != null) {
            info.setCnpjSindCategProf(ToolString.refina((String)colaborador.getSindicato().getCnpjSindicato()));
        }
        if (colaborador.getEstabelecimento() != null && colaborador.getEsocCategoriaTrabalhador().getCodigo().equals("103")) {
            info.setAprend(this.getAprend(colaborador));
        }
        return info;
    }

    private TAprend getAprend(Colaborador colaborador) {
        TAprend aprendiz = this.getFact().createTAprend();
        aprendiz.setIndAprend(Byte.parseByte("1"));
        aprendiz.setCnpjEntQual(ToolString.refina((String)colaborador.getEstabelecimento().getEmpresa().getPessoa().getComplemento().getCnpj()));
        return aprendiz;
    }

    private ESocial.EvtAltContratual.AltContratual.Vinculo.InfoContrato getInfoContrato(EsocPreEvento preEvento) throws ExceptionEsocial {
        Colaborador colaborador = preEvento.getColaborador();
        ESocial.EvtAltContratual.AltContratual.Vinculo.InfoContrato tDados = this.getFact().createESocialEvtAltContratualAltContratualVinculoInfoContrato();
        tDados.setCBOCargo(ToolString.refina((String)colaborador.getFuncao().getCbo().getCodigo()));
        tDados.setNmCargo(ToolString.clearSpecialCharacXML((String)colaborador.getFuncao().getDescricao()));
        tDados.setCodCateg(new BigInteger(colaborador.getEsocCategoriaTrabalhador().getCodigo()));
        tDados.setRemuneracao(this.getRemuneracao(colaborador, preEvento));
        tDados.setDuracao(this.getDuracao(colaborador, preEvento));
        tDados.setLocalTrabalho(this.getLocalTrabalho(colaborador));
        tDados.setHorContratual(this.getHorarioTrabalho(colaborador));
        if (!colaborador.getTreinamentos().isEmpty()) {
            for (EsocTreinamentoColaborador t : colaborador.getTreinamentos()) {
                tDados.getTreiCap().add(this.createTreinamento(t));
            }
        }
        return tDados;
    }

    private TTreiCap createTreinamento(EsocTreinamentoColaborador t) {
        TTreiCap tt = this.getFact().createTTreiCap();
        tt.setCodTreiCap(new BigInteger(t.getEsocTreinamento().getCodigo()));
        return tt;
    }

    private TRemuneracao getRemuneracao(Colaborador colaborador, EsocPreEvento preEvento) {
        TRemuneracao r = this.getFact().createTRemuneracao();
        r.setUndSalFixo(Byte.parseByte(colaborador.getTipoSalario().getCodigoEsocial()));
        if (colaborador.getTipoSalario().getCodigoEsocial().equals("7")) {
            r.setDscSalVar(colaborador.getDescricaoSalario());
            r.setVrSalFx(new BigDecimal(0));
        } else {
            Double valorSalario = preEvento.getSalarioColaborador();
            r.setVrSalFx(ToolFormatter.arrredondarNumeroBigDecimal((Double)valorSalario, (int)2));
        }
        return r;
    }

    private ESocial.EvtAltContratual.AltContratual.Vinculo.InfoContrato.Duracao getDuracao(Colaborador colaborador, EsocPreEvento preEvento) {
        ESocial.EvtAltContratual.AltContratual.Vinculo.InfoContrato.Duracao duracao = this.getFact().createESocialEvtAltContratualAltContratualVinculoInfoContratoDuracao();
        if (colaborador.getPrimeiraDataExperiencia() == null && colaborador.getSegundaDataExperiencia() == null) {
            duracao.setTpContr(Byte.parseByte("1"));
            return duracao;
        }
        if (colaborador.getPrimeiraDataExperiencia() != null && colaborador.getPrimeiraDataExperiencia().after(new Date())) {
            duracao.setTpContr(Byte.parseByte("2"));
            duracao.setDtTerm(ToolEsocial.converteData(colaborador.getPrimeiraDataExperiencia()));
        } else if (colaborador.getSegundaDataExperiencia() != null && colaborador.getSegundaDataExperiencia().after(new Date())) {
            duracao.setTpContr(Byte.parseByte("2"));
            duracao.setDtTerm(ToolEsocial.converteData(colaborador.getSegundaDataExperiencia()));
        } else {
            duracao.setTpContr(Byte.parseByte("1"));
        }
        return duracao;
    }

    private TSSimNao getSimOrNao(Short campo) {
        if (campo.equals((short)1)) {
            return TSSimNao.S;
        }
        return TSSimNao.N;
    }

    private ESocial.EvtAltContratual.AltContratual.Vinculo.InfoContrato.LocalTrabalho getLocalTrabalho(Colaborador colaborador) throws ExceptionEsocial {
        ESocial.EvtAltContratual.AltContratual.Vinculo.InfoContrato.LocalTrabalho local = this.getFact().createESocialEvtAltContratualAltContratualVinculoInfoContratoLocalTrabalho();
        local.setLocalTrabGeral(this.getLocalTrabalhoGeral(colaborador));
        return local;
    }

    private THorContratual getHorarioTrabalho(Colaborador colaborador) throws ExceptionEsocial {
        THorContratual h = this.getFact().createTHorContratual();
        if (!colaborador.getEsocCategoriaTrabalhador().getCodigo().equals("111")) {
            h.setQtdHrsSem(new BigDecimal(colaborador.getJornadaSemanal()));
        }
        if (colaborador.getHorarioTrabalho().getEsocCadastroHorario().getTipoJornada().getCodigo() == null) {
            throw new ExceptionEsocial("Colaborador: " + colaborador.toString() + " sem a informa\u00e7\u00e3o do Tipo de Jornada em seu horario");
        }
        h.setTpJornada(Byte.parseByte(colaborador.getHorarioTrabalho().getEsocCadastroHorario().getTipoJornada().getCodigo()));
        h.setTmpParc(Byte.parseByte(colaborador.getHorarioTrabalho().getEsocCadastroHorario().getEsocTipoContrato().getCodigo()));
        h.setHorNoturno(this.getSimOrNao(colaborador.getHorarioTrabalho().getEsocCadastroHorario().getPossuiHoraNoturna()));
        h.setDscJorn(ToolString.clearSpecialCharacXML((String)colaborador.getHorarioTrabalho().getDescricao().toUpperCase()));
        return h;
    }

    private TLocalTrabGeral getLocalTrabalhoGeral(Colaborador colaborador) throws ExceptionEsocial {
        TLocalTrabGeral l = this.getFact().createTLocalTrabGeral();
        if (colaborador.getEstabelecimento() == null) {
            throw new ExceptionEsocial("Colaborador: " + colaborador.toString() + " Sem Estabelecimento Informado.");
        }
        if (colaborador.getEstabelecimento().getInformarDadosCAEPF().equals((short)0)) {
            l.setTpInsc(Byte.parseByte("1"));
            l.setNrInsc(ToolString.refina((String)colaborador.getEstabelecimento().getEmpresa().getPessoa().getComplemento().getCnpj()));
        } else {
            l.setTpInsc(Byte.parseByte("4"));
            l.setNrInsc(ToolString.refina((String)colaborador.getEstabelecimento().getEmpresa().getPessoa().getComplemento().getCodCei()));
        }
        return l;
    }
}

