/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtcat;

import com.touchcomp.basementor.model.vo.EsocCadastroMedicoResponsavel;
import com.touchcomp.basementor.model.vo.EsocCatAgenteCausador;
import com.touchcomp.basementor.model.vo.EsocCatAtestado;
import com.touchcomp.basementor.model.vo.EsocCatPartesAtingidas;
import com.touchcomp.basementor.model.vo.EsocComunicadoAcidTrab;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtcat.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtcat.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtcat.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtcat.v_s_01_03_00.TIdeEventoTrab;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtcat.v_s_01_03_00.TIdeVinculoSst;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtcat.v_s_01_03_00.TSSimNao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtcat.v_s_01_03_00.TSUf;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ImpEvtCat
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        EsocComunicadoAcidTrab pre = preEvento.getCat();
        ESocial root = this.getFact().createESocial();
        root.setEvtCAT(this.getEvtCat(pre, preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtCAT getEvtCat(EsocComunicadoAcidTrab pre, EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtCAT evt = this.getFact().createESocialEvtCAT();
        evt.setIdeEmpregador(this.getEmpregador(opcoes));
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEvento(this.getIdeEvento(preEvento, opcoes));
        evt.setIdeVinculo(this.getVinculoColaborador(pre));
        evt.setCat(this.getCat(pre, preEvento, opcoes));
        return evt;
    }

    private TIdeEmpregador getEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoTrab getIdeEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) {
        TIdeEventoTrab cadastro = this.getFact().createTIdeEventoTrab();
        cadastro.setTpAmb(Byte.parseByte(preEvento.getEsocEvento().getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        cadastro.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        cadastro.setIndRetif(Byte.parseByte("1"));
        return cadastro;
    }

    private TIdeVinculoSst getVinculoColaborador(EsocComunicadoAcidTrab pre) {
        TIdeVinculoSst evt = this.getFact().createTIdeVinculoSst();
        evt.setCpfTrab(pre.getColaborador().getPessoa().getComplemento().getCnpj());
        evt.setMatricula(pre.getColaborador().getNumeroRegistroESocial());
        return evt;
    }

    private ESocial.EvtCAT.Cat getCat(EsocComunicadoAcidTrab pre, EsocPreEvento preEvento, OpcoesESocial opcoes) {
        ESocial.EvtCAT.Cat cat = this.getFact().createESocialEvtCATCat();
        Timestamp dataAcidente = pre.getDataHoraAcidente();
        cat.setDtAcid(ToolEsocial.converteData(dataAcidente));
        cat.setTpAcid(Byte.parseByte(pre.getTipoAcidenteTrabalho().getCodigo()));
        Calendar calHorasAcidente = ToolDate.getCalendar((Date)pre.getDataHoraAcidente());
        Integer horas = calHorasAcidente.get(11);
        Integer minutos = calHorasAcidente.get(12);
        String horaAcidente = (String)(horas > 9 ? horas.toString() : "0" + horas.toString()) + (String)(minutos > 9 ? minutos.toString() : "0" + minutos.toString());
        cat.setHrAcid(horaAcidente);
        Calendar calHorasTrabalhadas = ToolDate.getCalendar((Date)pre.getHorasTrabAcid());
        Integer horasAntesAcidente = calHorasTrabalhadas.get(11);
        Integer minutosAntesAcidente = calHorasTrabalhadas.get(12);
        String horaAntesAcidente = (String)(horasAntesAcidente > 9 ? horasAntesAcidente.toString() : "0" + horasAntesAcidente.toString()) + (String)(minutosAntesAcidente > 9 ? minutosAntesAcidente.toString() : "0" + minutosAntesAcidente.toString());
        cat.setHrsTrabAntesAcid(horaAntesAcidente);
        cat.setTpCat(Byte.parseByte(pre.getTipoCat().getCodigo()));
        cat.setIndCatObito(this.getSimOrNao(pre.getObito()));
        if (pre.getDataObito() != null) {
            cat.setDtObito(ToolEsocial.converteData(pre.getDataObito()));
        }
        cat.setIndComunPolicia(this.getSimOrNao(pre.getComunicadoAutoridades()));
        cat.setCodSitGeradora(new BigInteger(pre.getCodSitGeradoraAcidTrabalho().getCodigo()));
        cat.setIniciatCAT(Byte.parseByte(pre.getEmissorCat().getCodigo()));
        cat.setParteAtingida(this.getParteAntigida(pre.getPartesAtingidas()));
        cat.setObsCAT(pre.getObservacaoCat());
        cat.setLocalAcidente(this.getLocalAcidente(pre));
        cat.setAgenteCausador(this.getAgenteCausador(pre));
        if (pre.getAtestado() != null) {
            cat.setAtestado(this.getAtestado(pre.getAtestado()));
        }
        if (pre.getCatOrigem() != null && pre.getCatOrigem().length() > 1) {
            cat.setCatOrigem(this.getCatOrigem(pre.getCatOrigem()));
        }
        cat.setHouveAfast(this.getSimOrNao(pre.getAtestado().getIndicativoAfastamento()));
        cat.setUltDiaTrab(ToolEsocial.converteData(pre.getAtestado().getDataHoraAtend()));
        return cat;
    }

    private TSSimNao getSimOrNao(Short campo) {
        if (campo.equals((short)1)) {
            return TSSimNao.S;
        }
        return TSSimNao.N;
    }

    private ESocial.EvtCAT.Cat.LocalAcidente getLocalAcidente(EsocComunicadoAcidTrab pre) {
        ESocial.EvtCAT.Cat.LocalAcidente local = this.getFact().createESocialEvtCATCatLocalAcidente();
        local.setTpLocal(Byte.parseByte(pre.getTipoLocalAcidente().getCodigo()));
        local.setDscLocal(pre.getEspecifLocalAcidente());
        local.setTpLograd(pre.getTipoLogradouro().getSigla());
        local.setDscLograd(pre.getPessoaLocalAcidente().getEndereco().getLogradouro());
        local.setNrLograd(pre.getPessoaLocalAcidente().getEndereco().getNumero());
        local.setComplemento("complemento ");
        local.setBairro(pre.getPessoaLocalAcidente().getEndereco().getBairro());
        local.setCep(ToolString.refina((String)pre.getPessoaLocalAcidente().getEndereco().getCep()));
        local.setCodMunic(new BigInteger(pre.getPessoaLocalAcidente().getEndereco().getCidade().getCodIbgeCompleto()));
        local.setUf(this.getUf(pre.getPessoaLocalAcidente().getEndereco().getCidade().getUf().getSigla()));
        local.setIdeLocalAcid(this.getIdeLocal(pre.getPessoaLocalAcidente()));
        return local;
    }

    private TSUf getUf(String sigla) {
        return TSUf.fromValue(sigla);
    }

    private ESocial.EvtCAT.Cat.LocalAcidente.IdeLocalAcid getIdeLocal(Pessoa pessoaLocalAcidente) {
        ESocial.EvtCAT.Cat.LocalAcidente.IdeLocalAcid ide = this.getFact().createESocialEvtCATCatLocalAcidenteIdeLocalAcid();
        ide.setTpInsc(Byte.parseByte("1"));
        ide.setNrInsc(ToolString.refina((String)pessoaLocalAcidente.getComplemento().getCnpj()));
        return ide;
    }

    private ESocial.EvtCAT.Cat.AgenteCausador getAgenteCausador(EsocComunicadoAcidTrab pre) {
        ESocial.EvtCAT.Cat.AgenteCausador agenteCausador = this.getFact().createESocialEvtCATCatAgenteCausador();
        agenteCausador.setCodAgntCausador(new BigInteger(((EsocCatAgenteCausador)pre.getAgentesCausadores().get(0)).getAgenteCausador().getCodigo()));
        return agenteCausador;
    }

    private ESocial.EvtCAT.Cat.Atestado getAtestado(EsocCatAtestado atestado) {
        ESocial.EvtCAT.Cat.Atestado at = this.getFact().createESocialEvtCATCatAtestado();
        at.setDtAtendimento(ToolEsocial.converteData(atestado.getDataHoraAtend()));
        Calendar holAtt = ToolDate.getCalendar((Date)atestado.getDataHoraAtend());
        Integer horasAntesAcidente = holAtt.get(11);
        Integer minutosAntesAcidente = holAtt.get(12);
        String horaAntesAcidente = (String)(horasAntesAcidente > 9 ? horasAntesAcidente.toString() : "0" + horasAntesAcidente.toString()) + (String)(minutosAntesAcidente > 9 ? minutosAntesAcidente.toString() : "0" + minutosAntesAcidente.toString());
        at.setHrAtendimento(horaAntesAcidente);
        at.setIndInternacao(this.getSimOrNao(atestado.getIndicativoInternacao()));
        at.setDurTrat(new BigInteger(atestado.getDuracaoTratamento().toString()));
        at.setIndAfast(this.getSimOrNao(atestado.getIndicativoAfastamento()));
        at.setDscLesao(new BigInteger(atestado.getNaturezaLesao().getCodigo()));
        at.setDscCompLesao(atestado.getDescCompLesao());
        at.setDiagProvavel(atestado.getDiagProvavel());
        at.setCodCID(atestado.getCodigoCid());
        at.setObservacao(atestado.getObservacao());
        at.setEmitente(this.getEmitente(atestado.getMedicoEmitente()));
        return at;
    }

    private ESocial.EvtCAT.Cat.Atestado.Emitente getEmitente(EsocCadastroMedicoResponsavel medico) {
        ESocial.EvtCAT.Cat.Atestado.Emitente emitente = this.getFact().createESocialEvtCATCatAtestadoEmitente();
        emitente.setNmEmit(ToolString.clearSpecialCharacXML((String)medico.getPessoa().getNome()));
        emitente.setIdeOC(Byte.parseByte(medico.getEsocOrgaoClasse().getCodigo()));
        emitente.setNrOC(medico.getNumeroOrgaoClasse());
        emitente.setUfOC(this.getUf(medico.getUfOrgaoClasse().getSigla()));
        return emitente;
    }

    private ESocial.EvtCAT.Cat.CatOrigem getCatOrigem(String catOrigem) {
        ESocial.EvtCAT.Cat.CatOrigem origem2 = this.getFact().createESocialEvtCATCatCatOrigem();
        origem2.setNrRecCatOrig(catOrigem);
        return origem2;
    }

    private ESocial.EvtCAT.Cat.ParteAtingida getParteAntigida(List<EsocCatPartesAtingidas> partesAtingidas) {
        ESocial.EvtCAT.Cat.ParteAtingida p = this.getFact().createESocialEvtCATCatParteAtingida();
        Iterator<EsocCatPartesAtingidas> iterator = partesAtingidas.iterator();
        if (iterator.hasNext()) {
            EsocCatPartesAtingidas partesAtingida = iterator.next();
            p.setCodParteAting(new BigInteger(partesAtingida.getParteAtigida().getCodigo()));
            p.setLateralidade(Byte.parseByte(partesAtingida.getLateralidade().getCodigo()));
            return p;
        }
        return p;
    }
}

