/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtcontinter;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ConvocacaoContratoIntermitente;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.InfoHorarioTrabalho;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtconvinterm.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtconvinterm.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtconvinterm.TEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtconvinterm.TIdeEveTrab;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v02_05_00.evtconvinterm.TIdeVinculoNisObrig;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigInteger;

public class ImpEvtConvInter
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial root = this.getFact().createESocial();
        root.setEvtConvInterm(this.getConvocacao(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtConvInterm getConvocacao(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtConvInterm evt = this.getFact().createESocialEvtConvInterm();
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEmpregador(this.getIdEmpregador(opcoes));
        evt.setIdeEvento(this.getIdEvento(opcoes, preEvento.getEsocEvento()));
        evt.setIdeVinculo(this.getIdVinculo(preEvento));
        evt.setInfoConvInterm(this.getInfoConvocacao(preEvento));
        return evt;
    }

    private TEmpregador getIdEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TEmpregador tEmpregador = this.getFact().createTEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEveTrab getIdEvento(OpcoesESocial opcoes, EsocEvento esocEvento) {
        TIdeEveTrab tiTrab = this.getFact().createTIdeEveTrab();
        tiTrab.setTpAmb(Byte.parseByte(esocEvento.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (esocEvento.getPreEvento().getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(esocEvento.getPreEvento().getNumeroReciboRetificado());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        return tiTrab;
    }

    private TIdeVinculoNisObrig getIdVinculo(EsocPreEvento preEvento) {
        ConvocacaoContratoIntermitente vo = preEvento.getConvocacao();
        TIdeVinculoNisObrig ti = this.getFact().createTIdeVinculoNisObrig();
        ti.setCpfTrab(ToolString.refina((String)vo.getColaborador().getPessoa().getComplemento().getCnpj()));
        ti.setMatricula(vo.getColaborador().getNumeroRegistroESocial());
        ti.setNisTrab(ToolString.refina((String)vo.getColaborador().getNumeroPis()));
        return ti;
    }

    private ESocial.EvtConvInterm.InfoConvInterm getInfoConvocacao(EsocPreEvento preEvento) {
        ConvocacaoContratoIntermitente vo = preEvento.getConvocacao();
        ESocial.EvtConvInterm.InfoConvInterm info = this.getFact().createESocialEvtConvIntermInfoConvInterm();
        info.setCodConv(this.completaZerosEsq(vo.getIdentificador().toString(), 2));
        info.setDtInicio(ToolEsocial.converteData(vo.getDataInicio()));
        info.setDtFim(ToolEsocial.converteData(vo.getDataFinal()));
        info.setDtPrevPgto(ToolEsocial.converteData(vo.getDataPagamento()));
        info.setJornada(this.getJornada(vo));
        info.setLocalTrab(this.getLocal(vo));
        return info;
    }

    private ESocial.EvtConvInterm.InfoConvInterm.Jornada getJornada(ConvocacaoContratoIntermitente vo) {
        ESocial.EvtConvInterm.InfoConvInterm.Jornada j = this.getFact().createESocialEvtConvIntermInfoConvIntermJornada();
        Colaborador colaborador = vo.getColaborador();
        if (colaborador.getHorarioTrabalho().getEsocCadastroHorario().getTipoJornada().getCodigo().equals("9")) {
            j.setDscJornada(colaborador.getHorarioTrabalho().getEsocCadastroHorario().getDescricaoEscalaDiferenciada());
        } else if (ToolMethods.isEquals((Object)colaborador.getHorarioTrabalho().getEsocCadastroHorario().getTipoJornada().getCodigo(), (Object)"9")) {
            for (InfoHorarioTrabalho infoHorario : colaborador.getHorarioTrabalho().getEsocCadastroHorario().getListaHorario()) {
                if (!infoHorario.getFolga().equals((short)0)) continue;
                j.setCodHorContrat(infoHorario.getCodigoEsocial());
                break;
            }
        } else {
            j.setCodHorContrat(colaborador.getHorarioTrabalho().getEsocCadastroHorario().getInfoHorario().getCodigoEsocial());
        }
        return j;
    }

    private ESocial.EvtConvInterm.InfoConvInterm.LocalTrab getLocal(ConvocacaoContratoIntermitente vo) {
        ESocial.EvtConvInterm.InfoConvInterm.LocalTrab l = this.getFact().createESocialEvtConvIntermInfoConvIntermLocalTrab();
        l.setIndLocal(Byte.parseByte(vo.getLocal().getCodigo()));
        if (vo.getLocal().getCodigo().equals("1")) {
            l.setLocalTrabInterm(this.getLocalIntermitente(vo.getPessoa()));
        }
        return l;
    }

    private ESocial.EvtConvInterm.InfoConvInterm.LocalTrab.LocalTrabInterm getLocalIntermitente(Pessoa p) {
        ESocial.EvtConvInterm.InfoConvInterm.LocalTrab.LocalTrabInterm l = this.getFact().createESocialEvtConvIntermInfoConvIntermLocalTrabLocalTrabInterm();
        l.setBairro(ToolString.clearInvalidUTF8Char((String)p.getEndereco().getBairro()));
        l.setCep(ToolString.clearInvalidUTF8Char((String)p.getEndereco().getCep()));
        l.setCodMunic(new BigInteger(p.getEndereco().getCidade().getCodIbgeCompleto()));
        if (p.getEndereco().getComplemento() != null && p.getEndereco().getComplemento().length() > 0) {
            l.setComplem(ToolString.clearInvalidUTF8Char((String)p.getEndereco().getComplemento()));
        }
        l.setDscLograd(ToolString.clearInvalidUTF8Char((String)p.getEndereco().getLogradouro()));
        l.setNrLograd(p.getEndereco().getNumero());
        l.setTpLograd("R");
        l.setUf(p.getEndereco().getCidade().getUf().getSigla());
        return l;
    }
}

