/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evtmonitoramento;

import com.touchcomp.basementor.model.vo.EsocCadastroMedicoResponsavel;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocMonSaudeDadosExame;
import com.touchcomp.basementor.model.vo.EsocMonitoramentoSaude;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtmonit.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtmonit.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtmonit.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtmonit.v_s_01_03_00.TIdeEventoTrab;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtmonit.v_s_01_03_00.TIdeVinculoSst;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtmonit.v_s_01_03_00.TSUf;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.string.ToolString;

public class ImpEvtMonitoramento
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        EsocMonitoramentoSaude mon = preEvento.getMonitoramento();
        ESocial root = this.getFact().createESocial();
        root.setEvtMonit(this.getEvtMonitoramentto(mon, opcoes, preEvento));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtMonit getEvtMonitoramentto(EsocMonitoramentoSaude pre, OpcoesESocial opcoes, EsocPreEvento preEvento) throws ExceptionEsocial {
        ESocial.EvtMonit evt = this.getFact().createESocialEvtMonit();
        evt.setIdeEmpregador(this.getEmpregador(opcoes));
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEvento(this.getIdeEvento(preEvento, opcoes));
        evt.setIdeVinculo(this.getVinculoColaborador(pre));
        evt.setExMedOcup(this.getExMed(pre));
        return evt;
    }

    private TIdeEmpregador getEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoTrab getIdeEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) {
        TIdeEventoTrab cadastro = this.getFact().createTIdeEventoTrab();
        cadastro.setTpAmb(Byte.parseByte(preEvento.getEsocEvento().getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        cadastro.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        if (preEvento.getEventoRetificacao().equals((short)1)) {
            cadastro.setIndRetif(Byte.parseByte("2"));
            cadastro.setNrRecibo(preEvento.getNumeroReciboRetificado());
        } else {
            cadastro.setIndRetif(Byte.parseByte("1"));
        }
        return cadastro;
    }

    private TIdeVinculoSst getVinculoColaborador(EsocMonitoramentoSaude pre) {
        TIdeVinculoSst evt = this.getFact().createTIdeVinculoSst();
        evt.setCpfTrab(pre.getColaborador().getPessoa().getComplemento().getCnpj());
        evt.setMatricula(pre.getColaborador().getNumeroRegistroESocial());
        return evt;
    }

    private ESocial.EvtMonit.ExMedOcup getExMed(EsocMonitoramentoSaude pre) {
        ESocial.EvtMonit.ExMedOcup ex = this.getFact().createESocialEvtMonitExMedOcup();
        ex.setTpExameOcup(Byte.parseByte(pre.getEsocTipoExameOcupacional().getCodigo()));
        ex.setAso(this.getAso(pre));
        if (pre.getMedicoResponsavelPcmso() != null) {
            ex.setRespMonit(this.getResp(pre.getMedicoResponsavelPcmso()));
        }
        return ex;
    }

    private ESocial.EvtMonit.ExMedOcup.Aso getAso(EsocMonitoramentoSaude pre) {
        ESocial.EvtMonit.ExMedOcup.Aso aso = this.getFact().createESocialEvtMonitExMedOcupAso();
        aso.setDtAso(ToolEsocial.converteData(pre.getDataEmissaoAso()));
        aso.setResAso(Byte.valueOf(pre.getEsocResultadoAso().getCodigo()));
        for (EsocMonSaudeDadosExame esoc : pre.getEsocMonSaudeDadosExame()) {
            aso.getExame().add(this.getExame(esoc));
        }
        aso.setMedico(this.getMedico(pre.getEsocCadastroMedicoResponsavel()));
        return aso;
    }

    private ESocial.EvtMonit.ExMedOcup.Aso.Exame getExame(EsocMonSaudeDadosExame esoc) {
        ESocial.EvtMonit.ExMedOcup.Aso.Exame exame = this.getFact().createESocialEvtMonitExMedOcupAsoExame();
        exame.setDtExm(ToolEsocial.converteData(esoc.getDataExame()));
        exame.setProcRealizado(esoc.getEsocProcedimentosDiagnosticos().getCodigo());
        if (!esoc.getObservacao().isEmpty() && esoc.getObservacao().length() > 1) {
            exame.setObsProc(esoc.getObservacao());
        }
        exame.setOrdExame(Byte.valueOf(esoc.getEsocOrdemExame().getCodigo()));
        return exame;
    }

    private ESocial.EvtMonit.ExMedOcup.Aso.Medico getMedico(EsocCadastroMedicoResponsavel medResp) {
        ESocial.EvtMonit.ExMedOcup.Aso.Medico medico = this.getFact().createESocialEvtMonitExMedOcupAsoMedico();
        medico.setNmMed(ToolString.clearSpecialCharacXML((String)medResp.getPessoa().getNome()));
        medico.setNrCRM(ToolString.refina((String)medResp.getNumeroOrgaoClasse()));
        medico.setUfCRM(this.getUf(medResp.getUfOrgaoClasse()));
        return medico;
    }

    private TSUf getUf(UnidadeFederativa ufOrgaoClasse) {
        return TSUf.fromValue(ufOrgaoClasse.getSigla());
    }

    private ESocial.EvtMonit.ExMedOcup.RespMonit getResp(EsocCadastroMedicoResponsavel medico) {
        ESocial.EvtMonit.ExMedOcup.RespMonit resp = this.getFact().createESocialEvtMonitExMedOcupRespMonit();
        resp.setNmResp(ToolString.clearSpecialCharacXML((String)medico.getPessoa().getNome()));
        resp.setNrCRM(medico.getNumeroOrgaoClasse());
        resp.setUfCRM(this.getUf(medico.getUfOrgaoClasse()));
        return resp;
    }
}

