/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evttablotacao;

import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.model.vo.EsocCadastroLotacaoTributaria;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttablotacao.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttablotacao.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttablotacao.v_s_01_03_00.TDadosLotacao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttablotacao.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttablotacao.v_s_01_03_00.TIdeEventoEvtTab;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttablotacao.v_s_01_03_00.TIdeLotacao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttablotacao.v_s_01_03_00.TNovaValidade;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.math.BigInteger;
import java.util.Date;

public class ImpEvtTabLotacao
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        EsocCadastroLotacaoTributaria lotacao = preEvento.getLotacaoTrbutaria();
        ESocial root = this.getFact().createESocial();
        root.setEvtTabLotacao(this.getTabLotacao(lotacao, preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtTabLotacao getTabLotacao(EsocCadastroLotacaoTributaria lotacao, EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtTabLotacao evtTabLotacao = this.getFact().createESocialEvtTabLotacao();
        evtTabLotacao.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evtTabLotacao.setIdeEmpregador(this.getIdEmpregador(opcoes));
        evtTabLotacao.setIdeEvento(this.getIdEvento(opcoes, preEvento));
        evtTabLotacao.setInfoLotacao(this.getInfoLotacao(lotacao, preEvento));
        return evtTabLotacao;
    }

    private TIdeEmpregador getIdEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoEvtTab getIdEvento(OpcoesESocial opcoes, EsocPreEvento esoc) {
        TIdeEventoEvtTab cadastro = this.getFact().createTIdeEventoEvtTab();
        cadastro.setTpAmb(Byte.parseByte(esoc.getEsocEvento().getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        cadastro.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private ESocial.EvtTabLotacao.InfoLotacao getInfoLotacao(EsocCadastroLotacaoTributaria lotacao, EsocPreEvento preEvento) throws ExceptionEsocial {
        ESocial.EvtTabLotacao.InfoLotacao info = this.getFact().createESocialEvtTabLotacaoInfoLotacao();
        if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value) {
            info.setInclusao(this.getInclusao(lotacao, preEvento));
        } else if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value) {
            info.setAlteracao(this.getAlteracao(lotacao, preEvento));
        } else if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_EXLUSAO.value) {
            info.setExclusao(this.getExclusao(lotacao, preEvento));
        }
        return info;
    }

    private ESocial.EvtTabLotacao.InfoLotacao.Inclusao getInclusao(EsocCadastroLotacaoTributaria lotacao, EsocPreEvento preEvento) throws ExceptionEsocial {
        ESocial.EvtTabLotacao.InfoLotacao.Inclusao inclusao = this.getFact().createESocialEvtTabLotacaoInfoLotacaoInclusao();
        inclusao.setIdeLotacao(this.getTiLotacao(lotacao, preEvento));
        inclusao.setDadosLotacao(this.getDadosLotacao(lotacao));
        return inclusao;
    }

    private TIdeLotacao getTiLotacao(EsocCadastroLotacaoTributaria lotacao, EsocPreEvento preEvento) {
        TIdeLotacao tiLotacao = this.getFact().createTIdeLotacao();
        tiLotacao.setCodLotacao(lotacao.getCodigo());
        tiLotacao.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataInicioVal()));
        if (preEvento.getDataFimVal() != null) {
            tiLotacao.setFimValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataFimVal()));
        }
        return tiLotacao;
    }

    private TDadosLotacao getDadosLotacao(EsocCadastroLotacaoTributaria lotacao) throws ExceptionEsocial {
        TDadosLotacao dados = this.getFact().createTDadosLotacao();
        dados.setTpLotacao(lotacao.getTipoLotacao().getCodigo());
        if (!(lotacao.getTipoLotacao().getCodigo().equals("01") || lotacao.getTipoLotacao().getCodigo().equals("21") || lotacao.getTipoLotacao().getCodigo().equals("24") || lotacao.getTipoLotacao().getCodigo().equals("90"))) {
            dados.setTpInsc(Byte.valueOf("1"));
            dados.setNrInsc(lotacao.getPessoa().getComplemento().getCnpj());
        }
        dados.setFpasLotacao(this.getFpas(lotacao));
        return dados;
    }

    private TDadosLotacao.FpasLotacao getFpas(EsocCadastroLotacaoTributaria lotacao) {
        TDadosLotacao.FpasLotacao fpas = this.getFact().createTDadosLotacaoFpasLotacao();
        fpas.setCodTercs(lotacao.getCodigoTerceiros());
        fpas.setFpas(new BigInteger(lotacao.getCodigoFpas()));
        if (lotacao.getTabelaProcesso() != null) {
            fpas.setCodTercsSusp(lotacao.getCodigoTerceirosSuspensoAglutinado());
            fpas.setInfoProcJudTerceiros(this.getProcessoTerceiros(lotacao));
        }
        return fpas;
    }

    private ESocial.EvtTabLotacao.InfoLotacao.Alteracao getAlteracao(EsocCadastroLotacaoTributaria lotacao, EsocPreEvento preEvento) throws ExceptionEsocial {
        ESocial.EvtTabLotacao.InfoLotacao.Alteracao alteracao = this.getFact().createESocialEvtTabLotacaoInfoLotacaoAlteracao();
        alteracao.setDadosLotacao(this.getDadosLotacao(lotacao));
        alteracao.setIdeLotacao(this.getTiLotacaoAlteracao(lotacao, preEvento));
        alteracao.setNovaValidade(this.getNovaValidade(preEvento));
        return alteracao;
    }

    private TNovaValidade getNovaValidade(EsocPreEvento preEvento) {
        TNovaValidade validade = this.getFact().createTNovaValidade();
        validade.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataInicioVal()));
        if (preEvento.getDataFimVal() != null) {
            validade.setFimValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataFimVal()));
        }
        return validade;
    }

    private ESocial.EvtTabLotacao.InfoLotacao.Exclusao getExclusao(EsocCadastroLotacaoTributaria lotacao, EsocPreEvento preEvento) {
        ESocial.EvtTabLotacao.InfoLotacao.Exclusao exclusao = this.getFact().createESocialEvtTabLotacaoInfoLotacaoExclusao();
        exclusao.setIdeLotacao(this.getTiLotacao(lotacao, preEvento));
        return exclusao;
    }

    private TIdeLotacao getTiLotacaoAlteracao(EsocCadastroLotacaoTributaria lotacao, EsocPreEvento preEvento) {
        TIdeLotacao tiLotacao = this.getFact().createTIdeLotacao();
        tiLotacao.setCodLotacao(lotacao.getCodigo());
        tiLotacao.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getEventoAnterior().getDataInicioVal()));
        if (preEvento.getDataFimVal() != null) {
            tiLotacao.setFimValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataFimVal()));
        }
        return tiLotacao;
    }

    private TDadosLotacao.FpasLotacao.InfoProcJudTerceiros getProcessoTerceiros(EsocCadastroLotacaoTributaria lotacao) {
        int indice;
        TDadosLotacao.FpasLotacao.InfoProcJudTerceiros infoProc = this.getFact().createTDadosLotacaoFpasLotacaoInfoProcJudTerceiros();
        String codigoTerceiro = lotacao.getCodigoTerceirosSuspenso();
        do {
            indice = codigoTerceiro.indexOf("/");
            String temp = codigoTerceiro.substring(0, indice);
            infoProc.getProcJudTerceiro().add(this.processoJudicial(lotacao, temp));
        } while ((codigoTerceiro = codigoTerceiro.substring(indice + 1, codigoTerceiro.length())).contains("/"));
        return infoProc;
    }

    private TDadosLotacao.FpasLotacao.InfoProcJudTerceiros.ProcJudTerceiro processoJudicial(EsocCadastroLotacaoTributaria lotacao, String temp) {
        TDadosLotacao.FpasLotacao.InfoProcJudTerceiros.ProcJudTerceiro proc = this.getFact().createTDadosLotacaoFpasLotacaoInfoProcJudTerceirosProcJudTerceiro();
        proc.setCodSusp(new BigInteger(lotacao.getTabelaProcesso().getCodigoIndicativoSuspencao()));
        proc.setCodTerc(temp);
        proc.setNrProcJud(lotacao.getTabelaProcesso().getNumeroProcesso());
        return proc;
    }
}

