/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evttabrubricas;

import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.impl.EsocialEvento;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttabrubrica.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttabrubrica.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttabrubrica.v_s_01_03_00.TDadosRubrica;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttabrubrica.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttabrubrica.v_s_01_03_00.TIdeEventoEvtTab;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttabrubrica.v_s_01_03_00.TIdeRubrica;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttabrubrica.v_s_01_03_00.TNovaValidade;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.math.BigInteger;
import java.util.Date;

public class ImpEvtTabRubricas
extends DocEsocialBaseImpl {
    @Override
    public EsocialEvento getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public EsocialEvento getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        TipoCalculoEvento tipoCalculo = preEvento.getTipoCalculo();
        ESocial root = this.getFact().createESocial();
        root.setEvtTabRubrica(this.getEvtRubrica(tipoCalculo, opcoes, preEvento));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtTabRubrica getEvtRubrica(TipoCalculoEvento tipoCalculo, OpcoesESocial opcoes, EsocPreEvento preEvento) throws ExceptionEsocial {
        ESocial.EvtTabRubrica evtRubrica = this.getFact().createESocialEvtTabRubrica();
        evtRubrica.setIdeEmpregador(this.getIdEmpregador(opcoes));
        evtRubrica.setIdeEvento(this.getIdEvento(opcoes, preEvento.getEsocEvento()));
        evtRubrica.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evtRubrica.setInfoRubrica(this.getInfoRubrica(tipoCalculo, preEvento));
        return evtRubrica;
    }

    private TIdeEmpregador getIdEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador empregador = this.getFact().createTIdeEmpregador();
        empregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        empregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return empregador;
    }

    private TIdeEventoEvtTab getIdEvento(OpcoesESocial opcoes, EsocEvento e) {
        TIdeEventoEvtTab cadastro = this.getFact().createTIdeEventoEvtTab();
        cadastro.setTpAmb(Byte.parseByte(e.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        cadastro.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private ESocial.EvtTabRubrica.InfoRubrica getInfoRubrica(TipoCalculoEvento tipoCalculo, EsocPreEvento preEvento) {
        ESocial.EvtTabRubrica.InfoRubrica infoRubrica = this.getFact().createESocialEvtTabRubricaInfoRubrica();
        if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value) {
            infoRubrica.setInclusao(this.getInclusao(tipoCalculo, preEvento));
        } else if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value) {
            infoRubrica.setAlteracao(this.getAlteracao(tipoCalculo, preEvento));
        } else if (preEvento.getTipoEvento() == EnumEsocialTipoEvento.TIPO_EVENTO_EXLUSAO.value) {
            infoRubrica.setExclusao(this.getExclusao(tipoCalculo, preEvento));
        }
        return infoRubrica;
    }

    private ESocial.EvtTabRubrica.InfoRubrica.Inclusao getInclusao(TipoCalculoEvento tipoCalculo, EsocPreEvento preEvento) {
        ESocial.EvtTabRubrica.InfoRubrica.Inclusao inclusao = this.getFact().createESocialEvtTabRubricaInfoRubricaInclusao();
        inclusao.setIdeRubrica(this.getIdeRubrica(tipoCalculo, preEvento));
        inclusao.setDadosRubrica(this.getDadosRubrica(tipoCalculo));
        return inclusao;
    }

    private TIdeRubrica getIdeRubrica(TipoCalculoEvento tipoCalculo, EsocPreEvento preEvento) {
        TIdeRubrica tiRubrica = this.getFact().createTIdeRubrica();
        if (tipoCalculo.getEvento().getInformarCodigoEsocial().equals((short)0)) {
            tiRubrica.setCodRubr(tipoCalculo.getEvento().getCodigo().toString());
            tiRubrica.setIdeTabRubr(tipoCalculo.getEvento().getIdentificador().toString());
        } else {
            tiRubrica.setCodRubr(tipoCalculo.getEvento().getCodigoEsocial());
            tiRubrica.setIdeTabRubr(tipoCalculo.getEvento().getIdeTabelaRubrica());
        }
        tiRubrica.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataInicioVal()));
        return tiRubrica;
    }

    private TIdeRubrica getIdeRubricaAlteracao(TipoCalculoEvento tipoCalculo, EsocPreEvento preEvento) {
        TIdeRubrica tiRubrica = this.getFact().createTIdeRubrica();
        tiRubrica.setCodRubr(tipoCalculo.getEvento().getCodigo().toString());
        tiRubrica.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getEventoAnterior().getDataInicioVal()));
        if (preEvento.getDataFimVal() != null) {
            tiRubrica.setFimValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataFimVal()));
        }
        tiRubrica.setIdeTabRubr(tipoCalculo.getEvento().getIdentificador().toString());
        return tiRubrica;
    }

    private TDadosRubrica getDadosRubrica(TipoCalculoEvento tipoCalculo) {
        TDadosRubrica dadosRubrica = this.getFact().createTDadosRubrica();
        dadosRubrica.setDscRubr(this.clearInvalidUTF8Char(tipoCalculo.getEvento().getDescricao().toUpperCase()));
        dadosRubrica.setNatRubr(new BigInteger(tipoCalculo.getEsocRubricasFolhaPagamento().getCodigo().toString()));
        dadosRubrica.setTpRubr(Byte.parseByte(tipoCalculo.getEsocTipoRubrica().getCodigo()));
        dadosRubrica.setCodIncCP(tipoCalculo.getEsocRubricaPrevidencia().getCodigo());
        dadosRubrica.setCodIncFGTS(tipoCalculo.getEsocRubricaFgts().getCodigo());
        dadosRubrica.setCodIncIRRF(new BigInteger(tipoCalculo.getEsocRubricaIrrf().getCodigo()));
        if (tipoCalculo.getEsocRubricaPisPasep() != null) {
            dadosRubrica.setCodIncPisPasep(tipoCalculo.getEsocRubricaPisPasep().getCodigo());
        }
        return dadosRubrica;
    }

    private ESocial.EvtTabRubrica.InfoRubrica.Alteracao getAlteracao(TipoCalculoEvento tipoCalculo, EsocPreEvento preEvento) {
        ESocial.EvtTabRubrica.InfoRubrica.Alteracao alteracao = this.getFact().createESocialEvtTabRubricaInfoRubricaAlteracao();
        alteracao.setDadosRubrica(this.getDadosRubrica(tipoCalculo));
        alteracao.setIdeRubrica(this.getIdeRubricaAlteracao(tipoCalculo, preEvento));
        if (preEvento.getDataInicioVal() != null) {
            alteracao.setNovaValidade(this.getNovaValidade(preEvento));
        }
        return alteracao;
    }

    private TNovaValidade getNovaValidade(EsocPreEvento preEvento) {
        TNovaValidade validade = this.getFact().createTNovaValidade();
        validade.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataInicioVal()));
        return validade;
    }

    private ESocial.EvtTabRubrica.InfoRubrica.Exclusao getExclusao(TipoCalculoEvento tipoCalculo, EsocPreEvento preEvento) {
        ESocial.EvtTabRubrica.InfoRubrica.Exclusao exclusao = this.getFact().createESocialEvtTabRubricaInfoRubricaExclusao();
        exclusao.setIdeRubrica(this.getIdeRubrica(tipoCalculo, preEvento));
        return exclusao;
    }
}

