/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evttransferenciadesligamento;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.TransferenciaColaborador;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.TIdeEventoTrabIndGuia;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.TIdeVinculo;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtdeslig.v_s_01_03_00.TSSimNao;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.string.ToolString;

public class ImpEvtTransferenciaDesligamento
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial root = this.getFact().createESocial();
        root.setEvtDeslig(this.getEvtDesligamento(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtDeslig getEvtDesligamento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtDeslig evt = this.getFact().createESocialEvtDeslig();
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEmpregador(this.geEmpregador(opcoes));
        evt.setIdeEvento(this.getIdEvento(preEvento.getEsocEvento(), opcoes));
        evt.setIdeVinculo(this.getVinculo(preEvento.getTransferenciaColaborador()));
        evt.setInfoDeslig(this.getInfoDesligamento(preEvento));
        return evt;
    }

    private TIdeEmpregador geEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoTrabIndGuia getIdEvento(EsocEvento esocEvento, OpcoesESocial opcoes) {
        TIdeEventoTrabIndGuia tiTrab = this.getFact().createTIdeEventoTrabIndGuia();
        tiTrab.setTpAmb(Byte.parseByte(esocEvento.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (esocEvento.getPreEvento().getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(esocEvento.getPreEvento().getNumeroReciboRetificado());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        return tiTrab;
    }

    private TIdeVinculo getVinculo(TransferenciaColaborador t) {
        Colaborador colaborador = t.getColaborador();
        TIdeVinculo vinculo = this.getFact().createTIdeVinculo();
        vinculo.setCpfTrab(ToolString.refina((String)colaborador.getPessoa().getComplemento().getCnpj()));
        vinculo.setMatricula(ToolString.refina((String)t.getMatriculaAnterior()));
        return vinculo;
    }

    private ESocial.EvtDeslig.InfoDeslig getInfoDesligamento(EsocPreEvento preEvento) {
        TransferenciaColaborador t = preEvento.getTransferenciaColaborador();
        ESocial.EvtDeslig.InfoDeslig desligamento = this.getFact().createESocialEvtDesligInfoDeslig();
        desligamento.setMtvDeslig(t.getEsocMotivoDesligamento().getCodigo());
        desligamento.setDtDeslig(ToolEsocial.converteData(t.getDataTransferencia()));
        desligamento.setIndPagtoAPI(TSSimNao.N);
        desligamento.setPensAlim(Byte.valueOf("0"));
        if (t.getObservacao() != null && t.getObservacao().length() > 0) {
            desligamento.getObservacoes().add(this.createObservacao(t.getObservacao()));
        }
        desligamento.setSucessaoVinc(this.getSucessaoVinculo(t.getEmpresaNova()));
        return desligamento;
    }

    private ESocial.EvtDeslig.InfoDeslig.Observacoes createObservacao(String observacao) {
        ESocial.EvtDeslig.InfoDeslig.Observacoes ob = this.getFact().createESocialEvtDesligInfoDesligObservacoes();
        ob.setObservacao(observacao);
        return ob;
    }

    private ESocial.EvtDeslig.InfoDeslig.SucessaoVinc getSucessaoVinculo(Empresa empresaNova) {
        ESocial.EvtDeslig.InfoDeslig.SucessaoVinc sucessao = this.getFact().createESocialEvtDesligInfoDesligSucessaoVinc();
        sucessao.setTpInsc(Byte.parseByte("1"));
        sucessao.setNrInsc(ToolString.refina((String)empresaNova.getPessoa().getComplemento().getCnpj()));
        return sucessao;
    }
}

