/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.ponto.communication.cargo;

import com.touchcomp.basementorclientwebservices.ponto.communication.PontoBaseCommunication;
import com.touchcomp.basementorclientwebservices.ponto.communication.cargo.WebServicePontoCargo;
import com.touchcomp.basementorclientwebservices.ponto.constants.EnumConstSistemaPonto;
import com.touchcomp.basementorclientwebservices.ponto.model.cargo.DTOPontoCargo;
import com.touchcomp.basementorclientwebservices.ponto.model.cargo.result.tangerino.DTOResultCargoTangerino;
import com.touchcomp.basementorclientwebservices.ponto.model.cargo.result.tangerino.DTOResultListCargosTangerino;
import com.touchcomp.basementorclientwebservices.ponto.transformer.impl.TangerinoTransform;
import com.touchcomp.basementorexceptions.exceptions.impl.integracaoponto.ExceptionIntegracaoPontoEletronico;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import java.util.ArrayList;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class WebServicePontoCargoTangerino
extends PontoBaseCommunication
implements WebServicePontoCargo {
    @Override
    public void register(DTOPontoCargo dto) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionInvalidData, ExceptionIO {
        if (WebServicePontoCargoTangerino.isNotNull((Object)dto).booleanValue()) {
            TangerinoTransform builder = (TangerinoTransform)this.getBuilder(EnumConstSistemaPonto.TANGERINO);
            this.sendPost(builder.cargo(dto), "https://employer.tangerino.com.br/job-role/register");
        }
    }

    public DTOResultListCargosTangerino listAll() throws ExceptionWebService, ExceptionIntegracaoPontoEletronico, ExceptionInvalidData, ExceptionIO {
        String result = this.sendGet("https://employer.tangerino.com.br/job-role/find-all");
        return (DTOResultListCargosTangerino)this.readJson(result, DTOResultListCargosTangerino.class);
    }

    public DTOResultCargoTangerino list(Long id) throws ExceptionWebService, ExceptionIntegracaoPontoEletronico, ExceptionInvalidData, ExceptionIO {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("externalId", String.valueOf(id)));
        String result = this.sendGet("https://employer.tangerino.com.br/job-role/find", params);
        return (DTOResultCargoTangerino)this.readJson(result, DTOResultCargoTangerino.class);
    }

    @Override
    public void delete(Long id) throws ExceptionWebService, ExceptionIntegracaoPontoEletronico, ExceptionInvalidData, ExceptionIO {
        String result = this.sendDelete("https://employer.tangerino.com.br/job-role", id);
    }
}

