/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.reinf.impl.evtinfocprb;

import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementor.model.vo.ReinfR2060;
import com.touchcomp.basementor.model.vo.ReinfR2060Ajuste;
import com.touchcomp.basementor.model.vo.ReinfR2060Item;
import com.touchcomp.basementorclientwebservices.reinf.DocReinfBaseImpl;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evtinfocprb.v2_01_02.ObjectFactory;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evtinfocprb.v2_01_02.Reinf;
import com.touchcomp.basementorclientwebservices.reinf.tools.ToolReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.ExceptionReinf;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ImplInfoCPRB
extends DocReinfBaseImpl {
    @Override
    public Reinf getRootEvento(ReinfEvento evento, R1000 opcoesReinf) throws ExceptionReinf {
        return this.getRootEvento(evento.getPreEvento(), opcoesReinf);
    }

    @Override
    public Reinf getRootEvento(ReinfPreEvento preEvento, R1000 opcoesReinf) throws ExceptionReinf {
        R1000 opcoes = opcoesReinf;
        Reinf root = this.getFact().createReinf();
        root.setEvtCPRB(this.getInfoCPRB(opcoes, preEvento));
        return root;
    }

    private Reinf.EvtCPRB getInfoCPRB(R1000 opcoes, ReinfPreEvento preEvento) throws ExceptionReinf {
        Reinf.EvtCPRB infoCPRB = this.getFact().createReinfEvtCPRB();
        infoCPRB.setIdeContri(this.getIdeContribuinte(opcoes));
        infoCPRB.setInfoCPRB(this.getInfoContrib(preEvento));
        infoCPRB.setId(preEvento.getReinfEvento().getIdTagEventoReinf());
        infoCPRB.setIdeEvento(this.getIdeEvento(preEvento.getReinfEvento()));
        return infoCPRB;
    }

    private Reinf.EvtCPRB.InfoCPRB getInfoContrib(ReinfPreEvento preEvento) {
        Reinf.EvtCPRB.InfoCPRB evento = this.getFact().createReinfEvtCPRBInfoCPRB();
        evento.setIdeEstab(this.getIdeEstabelecimento(preEvento));
        return evento;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private Reinf.EvtCPRB.IdeEvento getIdeEvento(ReinfEvento evt) {
        Reinf.EvtCPRB.IdeEvento cadastro = this.getFact().createReinfEvtCPRBIdeEvento();
        if (evt.getPreEvento().getEventoRetificacao() != null && evt.getPreEvento().getEventoRetificacao().equals((short)1)) {
            cadastro.setIndRetif((short)2);
            cadastro.setNrRecibo(evt.getPreEvento().getEventoAnterior().getReinfEvento().getNrRecibo().trim());
        } else {
            cadastro.setIndRetif((short)1);
        }
        cadastro.setTpAmb(Byte.parseByte(evt.getReinfLoteEventos().getIdentificacaoAmbiente().getCodigo().toString()));
        cadastro.setProcEmi(Byte.parseByte("1"));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        cadastro.setPerApur(ToolDate.formatDateAnoMes((Date)evt.getPreEvento().getR2060().getPeriodo()));
        return cadastro;
    }

    private Reinf.EvtCPRB.IdeContri getIdeContribuinte(R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtCPRB.IdeContri empregador = this.getFact().createReinfEvtCPRBIdeContri();
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(opcoes.getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        empregador.setTpInsc(Byte.parseByte(tipoInscricao));
        empregador.setNrInsc(ToolReinf.getNrInscricaoEmpresa(opcoes.getEmpresa()));
        return empregador;
    }

    private Reinf.EvtCPRB.InfoCPRB.IdeEstab getIdeEstabelecimento(ReinfPreEvento preEvento) {
        ReinfR2060 r = preEvento.getR2060();
        Reinf.EvtCPRB.InfoCPRB.IdeEstab ideEstab = this.getFact().createReinfEvtCPRBInfoCPRBIdeEstab();
        ideEstab.setTpInscEstab(Long.valueOf("1").shortValue());
        ideEstab.setNrInscEstab(r.getEmpresa().getPessoa().getComplemento().getCnpj());
        ideEstab.setVlrRecBrutaTotal(this.formatNumber(r.getValorReceitaBrutaTotal(), 2));
        ideEstab.setVlrCPApurTotal(this.formatNumber(r.getValorContribPrevTotal(), 2));
        ideEstab.setVlrCPRBSuspTotal(this.formatNumber(r.getValorContribPrevSuspensao(), 2));
        ideEstab.getTipoCod().addAll(this.getTipoCod(r.getItens()));
        return ideEstab;
    }

    private Collection<? extends Reinf.EvtCPRB.InfoCPRB.IdeEstab.TipoCod> getTipoCod(List<ReinfR2060Item> itens) {
        ArrayList<Reinf.EvtCPRB.InfoCPRB.IdeEstab.TipoCod> lista = new ArrayList<Reinf.EvtCPRB.InfoCPRB.IdeEstab.TipoCod>();
        for (ReinfR2060Item i : itens) {
            Reinf.EvtCPRB.InfoCPRB.IdeEstab.TipoCod tipoCod = this.getFact().createReinfEvtCPRBInfoCPRBIdeEstabTipoCod();
            tipoCod.setCodAtivEcon(i.getReinfCodAtividadeEconomica().getCodigo());
            tipoCod.setVlrRecBrutaAtiv(this.formatNumber(i.getValorReceitaBrutaAtiva(), 2));
            tipoCod.setVlrExcRecBruta(this.formatNumber(i.getValorReceitaBrutaExclusao(), 2));
            tipoCod.setVlrAdicRecBruta(this.formatNumber(i.getValorReceitaBrutaAdicional(), 2));
            tipoCod.setVlrBcCPRB(this.formatNumber(i.getValorBCContribPrev(), 2));
            tipoCod.setVlrCPRBapur(this.formatNumber(i.getValorContribPrev(), 2));
            tipoCod.getTipoAjuste().addAll(this.getTipoAjuste(i));
            lista.add(tipoCod);
        }
        return lista;
    }

    private Collection<? extends Reinf.EvtCPRB.InfoCPRB.IdeEstab.TipoCod.TipoAjuste> getTipoAjuste(ReinfR2060Item i) {
        ArrayList<Reinf.EvtCPRB.InfoCPRB.IdeEstab.TipoCod.TipoAjuste> lista = new ArrayList<Reinf.EvtCPRB.InfoCPRB.IdeEstab.TipoCod.TipoAjuste>();
        for (ReinfR2060Ajuste aj : i.getAjustes()) {
            Reinf.EvtCPRB.InfoCPRB.IdeEstab.TipoCod.TipoAjuste tipoAj = this.getFact().createReinfEvtCPRBInfoCPRBIdeEstabTipoCodTipoAjuste();
            tipoAj.setTpAjuste(aj.getTipoAjuste());
            tipoAj.setCodAjuste(Integer.valueOf(aj.getAjusteContribPrev().getCodigo()).shortValue());
            tipoAj.setDtAjuste(ToolDate.formatDateAnoMes((Date)aj.getDataAjuste()));
            tipoAj.setVlrAjuste(this.formatNumber(aj.getValorAjuste(), 2));
            tipoAj.setDescAjuste(aj.getDescricaoAjuste());
            lista.add(tipoAj);
        }
        return lista;
    }

    public String formatNumber(Number n) {
        DecimalFormat staticDecimal = new DecimalFormat();
        staticDecimal.setMaximumFractionDigits(2);
        staticDecimal.setMinimumFractionDigits(2);
        staticDecimal.setMinimumIntegerDigits(1);
        n = n == null ? (Number)0.0 : (Number)n;
        String st = staticDecimal.format(n);
        st = st.replaceAll("\\.", "");
        return st;
    }

    public String formatNumber(Number n, int fractionDigits) {
        DecimalFormat variableDecimal = new DecimalFormat();
        variableDecimal.setMinimumIntegerDigits(1);
        variableDecimal.setMaximumFractionDigits(fractionDigits);
        variableDecimal.setMinimumFractionDigits(fractionDigits);
        String st = variableDecimal.format(n);
        st = st.replaceAll("\\.", "");
        return st;
    }
}

