/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.reinf.impl.evtpagamentorendimentofisica;

import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemReinfNotas4010;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementorclientwebservices.reinf.DocReinfBaseImpl;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evt4010pagtobeneficiariopf.v2_01_02.ObjectFactory;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evt4010pagtobeneficiariopf.v2_01_02.Reinf;
import com.touchcomp.basementorclientwebservices.reinf.tools.ToolReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.ExceptionReinf;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.Date;

public class ImpEvt4010RendimentoFisica
extends DocReinfBaseImpl {
    @Override
    public Reinf getRootEvento(ReinfEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public Reinf getRootEvento(ReinfPreEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        Reinf reinf = this.getFact().createReinf();
        reinf.setEvtRetPF(this.getReinfPF(preEvento, opcoes));
        return reinf;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private Reinf.EvtRetPF getReinfPF(ReinfPreEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtRetPF evt = this.getFact().createReinfEvtRetPF();
        evt.setId(preEvento.getReinfEvento().getIdTagEventoReinf());
        evt.setIdeContri(this.getIdeContribuinte(opcoes));
        evt.setIdeEvento(this.getIdeEvento(preEvento.getReinfEvento()));
        evt.setIdeEstab(this.getEstabelecimento(preEvento));
        return evt;
    }

    private Reinf.EvtRetPF.IdeContri getIdeContribuinte(R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtRetPF.IdeContri empregador = this.getFact().createReinfEvtRetPFIdeContri();
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(opcoes.getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        empregador.setTpInsc(Byte.parseByte(tipoInscricao));
        empregador.setNrInsc(ToolReinf.getNrInscricaoEmpresa(opcoes.getEmpresa()));
        return empregador;
    }

    private Reinf.EvtRetPF.IdeEvento getIdeEvento(ReinfEvento evt) {
        Reinf.EvtRetPF.IdeEvento cadastro = this.getFact().createReinfEvtRetPFIdeEvento();
        if (evt.getPreEvento().getEventoRetificacao() != null && evt.getPreEvento().getEventoRetificacao().equals((short)1)) {
            cadastro.setIndRetif((short)2);
            cadastro.setNrRecibo(evt.getPreEvento().getEventoAnterior().getReinfEvento().getNrRecibo().trim());
        } else {
            cadastro.setIndRetif((short)1);
        }
        cadastro.setPerApur(ToolDate.formatDateAnoMes((Date)evt.getPreEvento().getItemReinf4010().getApuracaoReinf().getPeriodo()));
        cadastro.setTpAmb(Byte.parseByte(evt.getReinfLoteEventos().getIdentificacaoAmbiente().getCodigo().toString()));
        cadastro.setProcEmi(Byte.parseByte("1"));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private Reinf.EvtRetPF.IdeEstab getEstabelecimento(ReinfPreEvento preEvento) {
        Reinf.EvtRetPF.IdeEstab est = this.getFact().createReinfEvtRetPFIdeEstab();
        est.setTpInscEstab(Short.parseShort("1"));
        est.setNrInscEstab(preEvento.getItemReinf4010().getEmpresa().getPessoa().getComplemento().getCnpj());
        est.setIdeBenef(this.getIdentificadorBeneficario(preEvento));
        return est;
    }

    private Reinf.EvtRetPF.IdeEstab.IdeBenef getIdentificadorBeneficario(ReinfPreEvento preEvento) {
        Reinf.EvtRetPF.IdeEstab.IdeBenef ideBen = this.getFact().createReinfEvtRetPFIdeEstabIdeBenef();
        ideBen.setCpfBenef(preEvento.getItemReinf4010().getPessoa().getComplemento().getCnpj());
        for (ItemReinfNotas4010 itemNota : preEvento.getItemReinf4010().getItensNotas()) {
            boolean achou = false;
            for (Reinf.EvtRetPF.IdeEstab.IdeBenef.IdePgto idePgto : ideBen.getIdePgto()) {
                achou = this.existeNaturezaRendimento(idePgto, itemNota);
            }
            if (achou) continue;
            ideBen.getIdePgto().add(this.getIdePagamento(itemNota, itemNota.getNotaTerceiros()));
        }
        return ideBen;
    }

    private Reinf.EvtRetPF.IdeEstab.IdeBenef.IdePgto getIdePagamento(ItemReinfNotas4010 itemNota, NotaFiscalTerceiros nfe) {
        Reinf.EvtRetPF.IdeEstab.IdeBenef.IdePgto idePagamento = this.getFact().createReinfEvtRetPFIdeEstabIdeBenefIdePgto();
        idePagamento.setNatRend(((ItemNotaTerceiros)nfe.getItemNotaTerceiros().get(0)).getNaturezaRendimento().getCodigo());
        idePagamento.setObserv("OBSERVACAO");
        idePagamento.getInfoPgto().add(this.getInfoPagamento(itemNota));
        return idePagamento;
    }

    private Reinf.EvtRetPF.IdeEstab.IdeBenef.IdePgto.InfoPgto getInfoPagamento(ItemReinfNotas4010 itemNota) {
        Reinf.EvtRetPF.IdeEstab.IdeBenef.IdePgto.InfoPgto info = this.getFact().createReinfEvtRetPFIdeEstabIdeBenefIdePgtoInfoPgto();
        NotaFiscalTerceiros nfe = itemNota.getNotaTerceiros();
        info.setDtFG(ToolDate.formatDateAnoMesDia((Date)nfe.getDataEmissao()));
        info.setVlrRendBruto(this.getValor(nfe.getValoresNfTerceiros().getValorTotal()));
        info.setVlrRendTrib(this.getValor(nfe.getValoresNfTerceiros().getValorTotal()));
        info.setVlrIR(this.getValor(nfe.getValoresNfTerceiros().getValorIrrf()));
        return info;
    }

    private boolean existeNaturezaRendimento(Reinf.EvtRetPF.IdeEstab.IdeBenef.IdePgto idePgto, ItemReinfNotas4010 itemNota) {
        NotaFiscalTerceiros nfe = itemNota.getNotaTerceiros();
        String cod = ((ItemNotaTerceiros)nfe.getItemNotaTerceiros().get(0)).getNaturezaRendimento().getCodigo();
        for (Reinf.EvtRetPF.IdeEstab.IdeBenef.IdePgto.InfoPgto infoPgto : idePgto.getInfoPgto()) {
            if (!idePgto.getNatRend().equals(cod)) continue;
            idePgto.getInfoPgto().add(this.getInfoPagamento(itemNota));
            return true;
        }
        return false;
    }

    private String getValor(Double valorTotal) {
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        Integer inteira = valorTotal.intValue();
        Integer decimal = (int)Math.round((valorTotal - (double)valorTotal.intValue()) * 100.0);
        String numero = decimal.toString().length() == 1 ? inteira.toString() + ",0" + decimal.toString() : inteira.toString() + "," + decimal.toString();
        return numero;
    }
}

