/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.reinf.impl.evtpagamentorendimentofisica;

import com.touchcomp.basementor.model.vo.ItemReinf4040;
import com.touchcomp.basementor.model.vo.ItemReinfDeducao4010;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementorclientwebservices.reinf.DocReinfBaseImpl;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evt4010pagtobeneficiariopf.v2_01_02.ObjectFactory;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evt4010pagtobeneficiariopf.v2_01_02.Reinf;
import com.touchcomp.basementorclientwebservices.reinf.tools.ToolReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.ExceptionReinf;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;

public class ImpEvt4010RendimentoFisicaNaoIDE
extends DocReinfBaseImpl {
    @Override
    public Reinf getRootEvento(ReinfEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public Reinf getRootEvento(ReinfPreEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        Reinf reinf = this.getFact().createReinf();
        reinf.setEvtRetPF(this.getReinfPF(preEvento, opcoes));
        return reinf;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private Reinf.EvtRetPF getReinfPF(ReinfPreEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtRetPF evt = this.getFact().createReinfEvtRetPF();
        evt.setId(preEvento.getReinfEvento().getIdTagEventoReinf());
        evt.setIdeContri(this.getIdeContribuinte(opcoes));
        evt.setIdeEvento(this.getIdeEvento(preEvento.getReinfEvento()));
        evt.setIdeEstab(this.getEstabelecimento(preEvento));
        return evt;
    }

    private Reinf.EvtRetPF.IdeContri getIdeContribuinte(R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtRetPF.IdeContri empregador = this.getFact().createReinfEvtRetPFIdeContri();
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(opcoes.getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        empregador.setTpInsc(Byte.parseByte(tipoInscricao));
        empregador.setNrInsc(ToolReinf.getNrInscricaoEmpresa(opcoes.getEmpresa()));
        return empregador;
    }

    private Reinf.EvtRetPF.IdeEvento getIdeEvento(ReinfEvento evt) {
        Reinf.EvtRetPF.IdeEvento cadastro = this.getFact().createReinfEvtRetPFIdeEvento();
        if (evt.getPreEvento().getEventoRetificacao() != null && evt.getPreEvento().getEventoRetificacao().equals((short)1)) {
            cadastro.setIndRetif((short)2);
            cadastro.setNrRecibo(evt.getPreEvento().getEventoAnterior().getReinfEvento().getNrRecibo().trim());
        } else {
            cadastro.setIndRetif((short)1);
        }
        cadastro.setPerApur(ToolDate.formatDateAnoMes((Date)evt.getPreEvento().getItemReinf4040().getApuracaoReinf().getPeriodo()));
        cadastro.setTpAmb(Byte.parseByte(evt.getReinfLoteEventos().getIdentificacaoAmbiente().getCodigo().toString()));
        cadastro.setProcEmi(Byte.parseByte("1"));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private Reinf.EvtRetPF.IdeEstab getEstabelecimento(ReinfPreEvento preEvento) {
        Reinf.EvtRetPF.IdeEstab est = this.getFact().createReinfEvtRetPFIdeEstab();
        est.setTpInscEstab(Short.parseShort("1"));
        est.setNrInscEstab(preEvento.getItemReinf4040().getEmpresa().getPessoa().getComplemento().getCnpj());
        est.setIdeBenef(this.getIdentificadorBeneficario(preEvento));
        return est;
    }

    private Reinf.EvtRetPF.IdeEstab.IdeBenef getIdentificadorBeneficario(ReinfPreEvento preEvento) {
        Reinf.EvtRetPF.IdeEstab.IdeBenef ideBen = this.getFact().createReinfEvtRetPFIdeEstabIdeBenef();
        ideBen.setCpfBenef(ToolString.clearSpecialCharacXML((String)preEvento.getItemReinf4040().getCpf()));
        ideBen.getIdePgto().add(this.getIdePagamento(preEvento));
        return ideBen;
    }

    private Reinf.EvtRetPF.IdeEstab.IdeBenef.IdePgto getIdePagamento(ReinfPreEvento preEvento) {
        Reinf.EvtRetPF.IdeEstab.IdeBenef.IdePgto idePagamento = this.getFact().createReinfEvtRetPFIdeEstabIdeBenefIdePgto();
        idePagamento.setNatRend(preEvento.getItemReinf4040().getNaturezaRendimento().getCodigo());
        idePagamento.setObserv("OBSERVACAO");
        idePagamento.getInfoPgto().add(this.getInfoPagamento(preEvento.getItemReinf4040()));
        return idePagamento;
    }

    private Reinf.EvtRetPF.IdeEstab.IdeBenef.IdePgto.InfoPgto getInfoPagamento(ItemReinf4040 itemNota) {
        Reinf.EvtRetPF.IdeEstab.IdeBenef.IdePgto.InfoPgto info = this.getFact().createReinfEvtRetPFIdeEstabIdeBenefIdePgtoInfoPgto();
        info.setDtFG(ToolDate.formatDateAnoMesDia((Date)itemNota.getDataPagamento()));
        info.setVlrRendBruto(this.getValor(itemNota.getLiquido()));
        info.setVlrRendTrib(this.getValor(itemNota.getBaseIrrf()));
        info.setVlrIR(this.getValor(itemNota.getVlrIrrf()));
        for (ItemReinfDeducao4010 d : itemNota.getDeducoes()) {
            info.getDetDed().add(this.createDeducao(d));
        }
        return info;
    }

    private String getValor(Double valorTotal) {
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        Integer inteira = valorTotal.intValue();
        Integer decimal = (int)Math.round((valorTotal - (double)valorTotal.intValue()) * 100.0);
        String numero = decimal.toString().length() == 1 ? inteira.toString() + ",0" + decimal.toString() : inteira.toString() + "," + decimal.toString();
        return numero;
    }

    private Reinf.EvtRetPF.IdeEstab.IdeBenef.IdePgto.InfoPgto.DetDed createDeducao(ItemReinfDeducao4010 d) {
        Reinf.EvtRetPF.IdeEstab.IdeBenef.IdePgto.InfoPgto.DetDed dd = this.getFact().createReinfEvtRetPFIdeEstabIdeBenefIdePgtoInfoPgtoDetDed();
        dd.setIndTpDeducao(Short.parseShort(d.getTipoDeducao().getCodigo()));
        dd.setVlrDeducao(this.getValor(d.getVlrDeducao()));
        return dd;
    }
}

