/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.webreceita.v1.cultura;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceita;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v1.consultarelacao.WebReceitaRelacao;
import com.touchcomp.basementorclientwebservices.webreceita.v1.cultura.WebReceitaInterfaceCulturas;
import com.touchcomp.basementorclientwebservices.webreceita.v1.cultura.model.DTOConsultaCulturaProdResult;
import com.touchcomp.basementorclientwebservices.webreceita.v1.cultura.model.DTOCulturaResult;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementortools.tools.json.ToolJson;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.ResponseBody;
import org.springframework.stereotype.Component;
import retrofit2.Call;
import retrofit2.Response;

@Component
public class WebReceitaCultura
extends WebReceita {
    public DTOCulturaResult getCulturas(WebReceitaConfig config) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            WebReceitaInterfaceCulturas bookResource = (WebReceitaInterfaceCulturas)this.getRetrofit(config).create(WebReceitaInterfaceCulturas.class);
            Call<DTOCulturaResult> books = bookResource.getCulturas();
            Response res = books.execute();
            DTOCulturaResult ret = (DTOCulturaResult)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message()});
            }
            if (ret.getAviso() != null) {
                ret.setStatus(EnumConstantsMentorStatus.ERRO);
            } else {
                ret.setStatus(EnumConstantsMentorStatus.SUCESSO);
            }
            return ret;
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaCultura.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public List<DTOConsultaCulturaProdResult.Cultura> getCulturas(WebReceitaConfig config, String idProduto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            WebReceitaInterfaceCulturas bookResource = (WebReceitaInterfaceCulturas)this.getRetrofit(config).create(WebReceitaInterfaceCulturas.class);
            Call<ResponseBody> books = bookResource.getCulturas(idProduto);
            Response res = books.execute();
            if (res.body() == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message()});
            }
            String ret = ((ResponseBody)res.body()).string();
            if (ret == null || ret.contains("aviso")) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message() + ". Retorno: " + ret});
            }
            DTOConsultaCulturaProdResult aux = (DTOConsultaCulturaProdResult)ToolJson.readJson((String)ret, DTOConsultaCulturaProdResult.class);
            return aux != null ? aux.getCultura() : null;
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaRelacao.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }
}

