/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.webreceita.v2;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.touchcomp.basementorclientwebservices.webreceita.v2.alvos.WebReceitaPragasAlvosV2;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.web.ToolWebResponse;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class WebReceitaV2<T> {
    public static final String DATE_MASK = "yyyy-MM-dd";

    protected String prepareURL(String url, Object ... data) {
        return ToolString.formatMessage((String)url, (Object[])data);
    }

    protected <M> M buildAndGetOne(String url, String userToken, Class<M> to) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + userToken).method("GET", null).build();
            Response response = client.newCall(request).execute();
            ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse((Integer)response.code());
            if (!stat.isSuccessful()) {
                String msg = "";
                if (response.body() != null) {
                    msg = response.body().string();
                }
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{stat.getStatusCode() + "-" + stat.getMesssage() + ": " + msg});
            }
            String ret = response.body().string();
            if (ret == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{response.body()});
            }
            return WebReceitaV2.readJson(ret, to);
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaPragasAlvosV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    protected String buildAndGetString(String url, String userToken) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + userToken).method("GET", null).build();
            Response response = client.newCall(request).execute();
            ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse((Integer)response.code());
            if (!stat.isSuccessful()) {
                String msg = "";
                if (response.body() != null) {
                    msg = response.body().string();
                }
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{stat.getStatusCode() + "-" + stat.getMesssage() + ": " + msg});
            }
            String ret = response.body().string();
            if (ret == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{response.body()});
            }
            return ret;
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaPragasAlvosV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    protected byte[] buildAndGetBytes(String url, String userToken) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + userToken).method("GET", null).build();
            Response response = client.newCall(request).execute();
            ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse((Integer)response.code());
            if (!stat.isSuccessful()) {
                String msg = "";
                if (response.body() != null) {
                    msg = response.body().string();
                }
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{stat.getStatusCode() + "-" + stat.getMesssage() + ": " + msg});
            }
            byte[] ret = response.body().bytes();
            if (ret == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{response.body()});
            }
            return ret;
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaPragasAlvosV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    protected <M> List<M> buildAndGetList(String url, String userToken, Class<M> to) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + userToken).method("GET", null).build();
            Response response = client.newCall(request).execute();
            ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse((Integer)response.code());
            if (!stat.isSuccessful()) {
                String msg = "";
                if (response.body() != null) {
                    msg = response.body().string();
                }
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{stat.getStatusCode() + "-" + stat.getMesssage() + ": " + msg});
            }
            String ret = response.body().string();
            if (ret == null) {
                String msg = "";
                if (response.body() != null) {
                    msg = response.body().string();
                }
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{stat.getStatusCode() + "-" + stat.getMesssage() + ": " + msg});
            }
            return WebReceitaV2.readJsonList(ret, to);
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaPragasAlvosV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    protected <M> M putAndGetOne(String url, String userToken, Class<M> retClass, Object env) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)ToolJson.toJson((Object)env, (boolean)false));
            Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + userToken).method("PUT", body).build();
            Response response = client.newCall(request).execute();
            ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse((Integer)response.code());
            if (!stat.isSuccessful()) {
                String msg = "";
                if (response.body() != null) {
                    msg = response.body().string();
                }
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{stat.getStatusCode() + "-" + stat.getMesssage() + ": " + msg});
            }
            String ret = response.body().string();
            if (ret == null) {
                String msg = "";
                if (response.body() != null) {
                    msg = response.body().string();
                }
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{stat.getStatusCode() + "-" + stat.getMesssage() + ": " + msg});
            }
            return WebReceitaV2.readJson(ret, retClass);
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaPragasAlvosV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    protected void put(String url, String userToken, Object env) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            MediaType mediaType = MediaType.parse((String)"application/json");
            Request.Builder build = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + userToken);
            if (env != null) {
                body = RequestBody.create((MediaType)mediaType, (String)ToolJson.toJson((Object)env, (boolean)false));
                build.method("PUT", body);
            } else {
                body = RequestBody.create((MediaType)mediaType, (String)"");
                build.method("PUT", body);
            }
            Request request = build.build();
            Response response = client.newCall(request).execute();
            ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse((Integer)response.code());
            if (!stat.isSuccessful()) {
                String msg = "";
                if (response.body() != null) {
                    msg = response.body().string();
                }
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{stat.getStatusCode() + "-" + stat.getMesssage() + ": " + msg});
            }
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaPragasAlvosV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    protected void delete(String url, String userToken) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + userToken).method("DELETE", null).build();
            Response response = client.newCall(request).execute();
            ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse((Integer)response.code());
            if (!stat.isSuccessful()) {
                String msg = "";
                if (response.body() != null) {
                    msg = response.body().string();
                }
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{stat.getStatusCode() + "-" + stat.getMesssage() + ": " + msg});
            }
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaPragasAlvosV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    protected <M> M postAndGetOne(String url, String userToken, Class<M> retClass, Object env) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)ToolJson.toJson((Object)env, (boolean)false));
            Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + userToken).method("POST", body).build();
            Response response = client.newCall(request).execute();
            ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse((Integer)response.code());
            if (!stat.isSuccessful()) {
                String msg = "";
                if (response.body() != null) {
                    msg = response.body().string();
                }
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{stat.getStatusCode() + "-" + stat.getMesssage() + ": " + msg});
            }
            String ret = response.body().string();
            if (ret == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{response.body()});
            }
            return WebReceitaV2.readJson(ret, retClass);
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaPragasAlvosV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public static <T> T readJson(String result, Class<T> toRet) throws ExceptionIO {
        try {
            System.out.println("Reading json internal...");
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (T)mapper.readValue(result, toRet);
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    public static <T> List<T> readJsonList(String data, Class<T> clazz) throws ExceptionIO {
        try {
            ObjectMapper mapper = new ObjectMapper();
            CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, clazz);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (List)mapper.readValue(data, (JavaType)type);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExceptionIO(e);
        }
    }
}

