/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.constants.enums.nfe;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public enum EnumConstDistribuicaoNFeStatus {
    SERVICO_PARADO_MOMENTANEAMENTE(108, "Servico Parado Momentaneamente"),
    SERVICO_PARADO_SEM_PREVISAO(109, "Servico Parado sem Previsao"),
    NENHUM_DOC_LOCALIZADO(137, "Nenhum Documento localizado"),
    DOCUMENTO_LOCALIZADO(138, "Documentos Localizados");

    private final Integer value;
    private final String descricao;

    private EnumConstDistribuicaoNFeStatus(Integer value, String descricao) {
        this.value = value;
        this.descricao = descricao;
    }

    public Integer getValue() {
        return this.value;
    }

    public Short getValueShort() {
        return this.value.shortValue();
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static List<EnumConstDistribuicaoNFeStatus> getStatusFinal() {
        EnumConstDistribuicaoNFeStatus[] aux = new EnumConstDistribuicaoNFeStatus[]{DOCUMENTO_LOCALIZADO, NENHUM_DOC_LOCALIZADO, SERVICO_PARADO_MOMENTANEAMENTE, SERVICO_PARADO_SEM_PREVISAO};
        return Arrays.asList(aux);
    }

    public static boolean isDocFound(String codigo) {
        return DOCUMENTO_LOCALIZADO.equals((Object)EnumConstDistribuicaoNFeStatus.getByCodigo(codigo));
    }

    public static boolean isServicoParado(String codigo) {
        return SERVICO_PARADO_SEM_PREVISAO.equals((Object)EnumConstDistribuicaoNFeStatus.getByCodigo(codigo)) || SERVICO_PARADO_MOMENTANEAMENTE.equals((Object)EnumConstDistribuicaoNFeStatus.getByCodigo(codigo));
    }

    public static boolean isStatusFinal(String status) {
        EnumConstDistribuicaoNFeStatus aux = EnumConstDistribuicaoNFeStatus.getByCodigo(status);
        return EnumConstDistribuicaoNFeStatus.isStatusFinal(aux);
    }

    public static boolean isStatusFinal(EnumConstDistribuicaoNFeStatus status) {
        return EnumConstDistribuicaoNFeStatus.getStatusFinal().contains((Object)status);
    }

    public static EnumConstDistribuicaoNFeStatus getByCodigo(String value) {
        EnumConstDistribuicaoNFeStatus[] values;
        for (EnumConstDistribuicaoNFeStatus value1 : values = EnumConstDistribuicaoNFeStatus.values()) {
            if (!Objects.equals(value1.getValue(), Integer.valueOf(value))) continue;
            return value1;
        }
        return null;
    }
}

