/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.cbsibs.impl;

import com.touchcomp.basementorrules.exceptions.ExceptionImpostoCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.BaseCbsIBs;
import com.touchcomp.basementorrules.impostos.cbsibs.InterfaceCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.constants.EnumConstNFeIncidenciaCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsCalculado;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsParams;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Arrays;
import java.util.List;

public class CbsIbsTribDiferimento
extends BaseCbsIBs
implements InterfaceCbsIbs {
    @Override
    public CbsIbsCalculado calcular(CbsIbsParams.ParamsBuilder params) throws ExceptionImpostoCbsIbs {
        CbsIbsCalculado calc = new CbsIbsCalculado(params);
        if (ToolMethods.isAffirmative((Number)params.calcularCbsIbs())) {
            double percRedAliquota = params.percRedAliquota();
            double percRedBC = params.percRedBC();
            double aliquotaDiferimento = params.percDiferimento();
            double aliquota = params.aliquota();
            double baseCalculo = this.getBC(params);
            double aliquotaEfetiva = this.calcAliquotaEfetiva(params.aliquota(), percRedAliquota, params.modoArredondamento());
            double valor = this.calcImposto(baseCalculo, aliquotaEfetiva, params.modoArredondamento());
            double valorDif = this.calcDiferimento(valor, aliquotaDiferimento, params.modoArredondamento());
            calc.setBaseCalculo(baseCalculo);
            calc.setValor(valor -= valorDif);
            calc.setValorDiferimento(valorDif);
            calc.setAliquotaDiferimento(aliquotaDiferimento);
            calc.setPercRedAliquota(percRedAliquota);
            calc.setPercRedBC(percRedBC);
            calc.setAliquota(aliquota);
            calc.setAliquotaEfetiva(aliquotaEfetiva);
        }
        return calc;
    }

    @Override
    public List<EnumConstNFeIncidenciaCbsIbs> getIncidencia() {
        return Arrays.asList(EnumConstNFeIncidenciaCbsIbs.DIFERIMENTO, EnumConstNFeIncidenciaCbsIbs.DIFERIMENTO_RED_ALIQUOTA);
    }

    @Override
    public boolean validCalcEntrada() {
        return true;
    }

    @Override
    public boolean validCalcSaida() {
        return true;
    }
}

