/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.cfop.EnumConstCfop;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoAliquotaFCP;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoAliquotaIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoCalculoDiferencaAliquota;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoIcmsDispensado;
import com.touchcomp.basementor.constants.enums.modelofiscalicms.EnumConstModFiscalDifal;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeVersao;
import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;
import com.touchcomp.basementorrules.impostos.icms.tools.TRulesIcms;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class BaseIcms {
    protected double getBC(IcmsParams params) {
        double bc = params.getValorProdServ();
        if (!this.isNull(params.getIpiCalculado()).booleanValue() && this.isAffirmative(params.getIpiCalculado().getIpiParams().getIpiCompoeBCIcms()).booleanValue()) {
            bc += params.getIpiCalculado().getValorIpiCompoeBCICMS();
        }
        if (this.isAffirmative(params.getParamsCalcIcms().getIncluirDesconto()).booleanValue()) {
            bc -= params.getValorDesconto().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcIcms().getIncluirDespAcess()).booleanValue()) {
            bc += params.getValorDespAcessorias().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcIcms().getIncluirFrete()).booleanValue()) {
            bc += params.getValorFrete().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcIcms().getIncluirSeguro()).booleanValue()) {
            bc += params.getValorSeguro().doubleValue();
        }
        if (this.isEquals(params.getTipoCfop(), EnumConstCfop.CFOP_IMPORTACAO).booleanValue()) {
            if (params.getParamsCalcIcms().getIndiceCalcImportacao() <= 0.0) {
                params.getParamsCalcIcms().setIndiceCalcImportacao(1.0);
            }
            bc /= params.getParamsCalcIcms().getIndiceCalcImportacao().doubleValue();
        }
        return bc;
    }

    protected double getBCEntrada(IcmsParams params) {
        double bc = params.getValorProdServ();
        if (this.isAffirmative(params.getParamsCalcIcms().getIncluirDesconto()).booleanValue()) {
            bc -= params.getValorDesconto().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcIcms().getIncluirDespAcess()).booleanValue()) {
            bc += params.getValorDespAcessorias().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcIcms().getIncluirFrete()).booleanValue()) {
            bc += params.getValorFrete().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcIcms().getIncluirSeguro()).booleanValue()) {
            bc += params.getValorSeguro().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcIcms().getIncluirIcmsDesonerado()).booleanValue()) {
            bc -= params.getValorIcmsDesonerado().doubleValue();
        }
        if (params.getIpiCalculado() != null && params.getIpiCalculado().getIpiParams().getIpiCompoeBCIcms() != null && TMethods.isAffirmative((Number)params.getIpiCalculado().getIpiParams().getIpiCompoeBCIcms().getValue())) {
            bc = bc + params.getIpiCalculado().getValorIpiIndustria() + params.getIpiCalculado().getValorIpiObservacao();
        }
        return bc;
    }

    protected double getBCTotal(IcmsParams params) {
        double bc = params.getValorProdServ();
        bc -= params.getValorDesconto().doubleValue();
        bc += params.getValorDespAcessorias().doubleValue();
        bc += params.getValorFrete().doubleValue();
        bc += params.getValorSeguro().doubleValue();
        bc -= params.getValorIcmsDesonerado().doubleValue();
        if (params.getIpiCalculado() != null && params.getIpiCalculado().getIpiParams().getIpiCompoeBCIcms() != null && TMethods.isAffirmative((Number)params.getIpiCalculado().getIpiParams().getIpiCompoeBCIcms().getValue())) {
            bc = bc + params.getIpiCalculado().getValorIpiIndustria() + params.getIpiCalculado().getValorIpiObservacao();
        }
        return bc;
    }

    protected void ajustarBCOutros(IcmsParams params, IcmsCalculado icmsCalc) {
        Double bcOutros = icmsCalc.getValorIcmsOutros() != null ? icmsCalc.getValorIcmsOutros() : 0.0;
        Double baseCalculoTot = this.getBCTotal(params);
        Double valor = baseCalculoTot - icmsCalc.getBaseCalculoIcms() + bcOutros;
        if (valor < 0.0) {
            return;
        }
        icmsCalc.setValorIcmsOutros(valor);
    }

    protected void calcularReducao(IcmsParams params, IcmsCalculado calc) {
        double aliquotaIcms = params.getParamsCalcIcms().getAliquotaIcmsInformada();
        double baseCalculo = this.getBCCalculoReducao(params);
        double bcAcess = this.getBCDespAcessorias(params);
        if (this.isEquals(params.getParamsCalcIcms().getTipoAliquotaIcms(), EnumConstTipoAliquotaIcms.ALIQ_ICMS_SEM_INCIDENCIA).booleanValue()) {
            calc.setValorIcmsOutros(baseCalculo += bcAcess);
            calc.setAliquotaIcms(0.0);
            calc.setBaseCalculoIcms(baseCalculo);
            this.ajustarBCOutros(params, calc);
        } else {
            double vrReduz = baseCalculo * (params.getParamsCalcIcms().getPercRedBCIcms() / 100.0);
            calc.setValorBCIcmsNaoTributado(vrReduz);
            calc.setAliquotaIcms(aliquotaIcms);
            calc.setValorIcmsIsento(vrReduz);
            if (this.calcularValoresDesoneracao(params).booleanValue()) {
                calc.setValorIcmsDispensado(this.arrredondarNumero(vrReduz * (aliquotaIcms / 100.0), 2, params.getTipoArredondamento()));
                calc.setValorIcmsIsento(this.arrredondarNumero(vrReduz - calc.getValorIcmsDispensado(), 2, params.getTipoArredondamento()));
            }
            if (this.isEquals(params.getParamsCalcIcms().getIncluirDespAcessCalcRed(), EnumConstantsMentorSimNao.SIM).booleanValue()) {
                double valorIcms = this.calcIcms((baseCalculo += bcAcess) - vrReduz, aliquotaIcms, params.getTipoArredondamento());
                calc.setBaseCalculoIcms(baseCalculo);
                if (this.isRecuperaTributos(params)) {
                    calc.setValorIcmsTributado(baseCalculo - vrReduz);
                    calc.setValorIcms(valorIcms);
                    this.ajustarBCOutros(params, calc);
                } else {
                    calc.setValorIcmsOutros(baseCalculo - vrReduz);
                    calc.setValorIcmsSemAprov(valorIcms);
                }
            } else {
                calc.setBaseCalculoIcms(baseCalculo + bcAcess);
                double valorIcms = (baseCalculo - vrReduz) * (aliquotaIcms / 100.0) + bcAcess * (aliquotaIcms / 100.0);
                if (this.isRecuperaTributos(params)) {
                    calc.setValorIcmsTributado(calc.getBaseCalculoIcms() - vrReduz);
                    calc.setValorIcms(valorIcms);
                    this.ajustarBCOutros(params, calc);
                } else {
                    calc.setValorIcmsOutros(calc.getBaseCalculoIcms() - vrReduz);
                    calc.setValorIcmsSemAprov(valorIcms);
                }
            }
        }
    }

    protected double getBCCalculoReducao(IcmsParams params) {
        double bc = params.getValorProdServ();
        if (!this.isNull(params.getIpiCalculado()).booleanValue() && this.isAffirmative(params.getIpiCalculado().getIpiParams().getIpiCompoeBCIcms()).booleanValue()) {
            bc += params.getIpiCalculado().getValorIpiCompoeBCICMS();
        }
        if (this.isAffirmative(params.getParamsCalcIcms().getIncluirDesconto()).booleanValue()) {
            bc -= params.getValorDesconto().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcIcms().getIncluirIcmsDesonerado()).booleanValue()) {
            bc -= params.getValorIcmsDesonerado().doubleValue();
        }
        if (this.isEquals(params.getTipoCfop(), EnumConstCfop.CFOP_IMPORTACAO).booleanValue()) {
            if (params.getParamsCalcIcms().getIndiceCalcImportacao() <= 0.0) {
                params.getParamsCalcIcms().setIndiceCalcImportacao(1.0);
            }
            bc /= params.getParamsCalcIcms().getIndiceCalcImportacao().doubleValue();
        }
        return bc;
    }

    protected boolean isRecuperaTributos(IcmsParams params) {
        return params.getParamsCalcIcms() != null && params.getParamsCalcIcms().getRecuperaTributos() != null && ToolMethods.isAffirmative((Number)params.getParamsCalcIcms().getRecuperaTributos().getValue());
    }

    protected double getBCDespAcessorias(IcmsParams params) {
        double bcAcess = 0.0;
        if (this.isAffirmative(params.getParamsCalcIcms().getIncluirDespAcess()).booleanValue()) {
            bcAcess += params.getValorDespAcessorias().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcIcms().getIncluirFrete()).booleanValue()) {
            bcAcess += params.getValorFrete().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcIcms().getIncluirSeguro()).booleanValue()) {
            bcAcess += params.getValorSeguro().doubleValue();
        }
        return bcAcess;
    }

    protected double arrredondarNumero(double d, int casasDec, EnumConstTipoArredondamento tipoArredondamento) {
        return ToolFormatter.arrredondarNumero((Double)d, (int)casasDec, (int)tipoArredondamento.value);
    }

    protected Boolean icmsDescontadoValorTotalNota(IcmsParams params) {
        return this.isNull(params.getParamsCalcIcms().getTipoIcmsDispensado()) == false && this.isEquals(params.getParamsCalcIcms().getTipoIcmsDispensado(), EnumConstTipoIcmsDispensado.ICMS_DISPENSADO_DESCONTAR_VALOR_TOTAL_NOTA) != false && this.isNull(params.getParamsCalcIcms().getMotivoDesoneracaoIcms()) == false;
    }

    protected Double getAliquotaICMS(IcmsParams params) {
        if (this.isEquals(params.getParamsCalcIcms().getTipoAliquotaIcms(), EnumConstTipoAliquotaIcms.ALIQ_ICMS_INFORMADA).booleanValue()) {
            return params.getParamsCalcIcms().getAliquotaIcmsInformada();
        }
        if (this.isEquals(params.getUfDestino(), params.getUfOrigem()).booleanValue()) {
            return params.getParamsCalcIcms().getAliquotaIcmsOrigemDestino();
        }
        return params.getParamsCalcIcms().getAliquotaIcmsProduto();
    }

    protected void calcularValoresReducaoBCIcms(IcmsParams params, IcmsCalculado calc, double baseCalculo, double bcAcess, Double aliquotaICMS, Double percRedICMS) {
        double vrReduz = this.arrredondarNumero(baseCalculo * (percRedICMS / 100.0), 2, params.getTipoArredondamento());
        calc.setBaseCalculoIcms(this.arrredondarNumero(baseCalculo + bcAcess - vrReduz, 2, params.getTipoArredondamento()));
        double vlrIcms = this.arrredondarNumero((baseCalculo - vrReduz) * (aliquotaICMS / 100.0), 2, params.getTipoArredondamento()) + this.arrredondarNumero(bcAcess * (aliquotaICMS / 100.0), 2, params.getTipoArredondamento());
        calc.setValorIcms(vlrIcms);
        calc.setValorBCIcmsNaoTributado(this.arrredondarNumero(vrReduz, 2, params.getTipoArredondamento()));
        calc.setValorIcmsTributado(calc.getBaseCalculoIcms());
        double dif = baseCalculo + this.getBCDespAcessorias(params) - (calc.getValorIcmsTributado() + calc.getValorBCIcmsNaoTributado());
        if (Math.abs(dif) < 0.02) {
            calc.setValorBCIcmsNaoTributado(calc.getValorBCIcmsNaoTributado() + dif);
        }
        calc.setValorIcmsIsento(calc.getValorBCIcmsNaoTributado());
        if (this.isEquals(params.getParamsCalcIcms().getTipoIcmsDispensado(), EnumConstTipoIcmsDispensado.ICMS_DISPENSADO_DESCONTAR_VALOR_TOTAL_NOTA).booleanValue() || this.isEquals(params.getParamsCalcIcms().getTipoIcmsDispensado(), EnumConstTipoIcmsDispensado.ICMS_DISPENSADO_ABATER_SOMENTE_VALOR_CUSTO).booleanValue()) {
            calc.setValorIcmsDispensado(this.arrredondarNumero(vrReduz * (aliquotaICMS / 100.0), 2, params.getTipoArredondamento()));
            calc.setValorIcmsIsento(calc.getValorBCIcmsNaoTributado() - calc.getValorIcmsDispensado());
            calc.setValorBCIcmsNaoTributado(calc.getValorBCIcmsNaoTributado() - calc.getValorIcmsDispensado());
        }
        calc.setBaseCalculoIcms(baseCalculo);
        calc.setPercentualRedBC(percRedICMS);
        calc.setAliquotaIcms(aliquotaICMS);
    }

    protected void calcularValoresDesoneracao(IcmsParams params, IcmsCalculado calc, double baseCalculo, double bcAcess, Double aliquotaICMS, Double percRedICMS) {
        if (this.isEquals(params.getParamsCalcIcms().getTipoIcmsDispensado(), EnumConstTipoIcmsDispensado.ICMS_DISPENSADO_DESCONTAR_VALOR_TOTAL_NOTA).booleanValue() || this.isEquals(params.getParamsCalcIcms().getTipoIcmsDispensado(), EnumConstTipoIcmsDispensado.ICMS_DISPENSADO_ABATER_SOMENTE_VALOR_CUSTO).booleanValue()) {
            double vlrIcms = this.calcIcms(baseCalculo, aliquotaICMS, params.getTipoArredondamento());
            calc.setValorIcmsDispensado(vlrIcms);
        }
    }

    protected Boolean calcularValoresDesoneracao(IcmsParams params) {
        return this.isNull(params.getParamsCalcIcms().getTipoIcmsDispensado()) == false && this.isEquals(params.getParamsCalcIcms().getTipoIcmsDispensado(), EnumConstTipoIcmsDispensado.ICMS_DISPENSADO_DESCONTAR_VALOR_TOTAL_NOTA) != false || this.isEquals(params.getParamsCalcIcms().getTipoIcmsDispensado(), EnumConstTipoIcmsDispensado.ICMS_DISPENSADO_ABATER_SOMENTE_VALOR_CUSTO) != false;
    }

    protected double calcIcms(double baseCalculo, Double aliquotaICMS, EnumConstTipoArredondamento tipoArredondamento) {
        return this.arrredondarNumero(baseCalculo * (aliquotaICMS / 100.0), 2, tipoArredondamento);
    }

    protected double getAliquotaFCPPartilha(IcmsParams params) {
        double aliquotaFCP = this.getAliquotaFCP(params);
        if (!this.isNull(params.getParamsCalcIcms().getTipoAliquotaFCP()).booleanValue() && this.isEquals(params.getParamsCalcIcms().getTipoAliquotaFCP(), EnumConstTipoAliquotaFCP.CALCULAR_FCP_SOMENTE_DIFAL).booleanValue()) {
            aliquotaFCP = params.getParamsCalcIcms().getAliquotaFCP();
        }
        return aliquotaFCP;
    }

    protected void calcularFCP(Double baseCalculo, IcmsParams params, IcmsCalculado calc) {
        double aliquotaFCP = this.getAliquotaFCP(params);
        if (this.isEquals(params.getVersaoNFe(), EnumConstNFeVersao.VERSAO_4_00).booleanValue() && (this.isNull(params.getNaoCalcularFCP()).booleanValue() || this.isEquals(params.getNaoCalcularFCP(), EnumConstantsMentorSimNao.NAO).booleanValue()) && aliquotaFCP > 0.0 && calc.getValorIcms() > 0.0) {
            calc.setValorFCP(baseCalculo * (aliquotaFCP / 100.0));
            calc.setAliquotaFCP(aliquotaFCP);
            calc.setBaseCalculoFCP(baseCalculo);
        }
    }

    protected void calcularFCP(IcmsParams params, IcmsCalculado calc) {
        if (this.isEquals(params.getVersaoNFe(), EnumConstNFeVersao.VERSAO_4_00).booleanValue() && (this.isNull(params.getNaoCalcularFCP()).booleanValue() || !this.isAffirmative(params.getNaoCalcularFCP()).booleanValue())) {
            double aliquotaFCP = this.getAliquotaFCP(params);
            if (this.isCalcularPartilhaIcms(params)) {
                aliquotaFCP = this.getAliquotaFCPPartilha(params);
                calc.setAliquotaFCP(aliquotaFCP);
                calc.setValorFCP(calc.getBaseCalculoIcms() * (aliquotaFCP / 100.0));
            } else if (aliquotaFCP > 0.0 && calc.getValorIcms() > 0.0) {
                calc.setValorFCP(calc.getBaseCalculoIcms() * (aliquotaFCP / 100.0));
                calc.setValorFCP(this.arrredondarNumero(calc.getValorFCP(), 2, params.getTipoArredondamento()));
                calc.setAliquotaFCP(aliquotaFCP);
                calc.setBaseCalculoFCP(calc.getBaseCalculoIcms());
            }
        }
    }

    protected double getAliquotaFCP(IcmsParams params) {
        Double aliquotaFCP = 0.0;
        if (!this.isNull(params.getParamsCalcIcms().getTipoAliquotaFCP()).booleanValue() && this.isEquals(params.getParamsCalcIcms().getTipoAliquotaFCP(), EnumConstTipoAliquotaFCP.CALCULAR_FCP).booleanValue()) {
            aliquotaFCP = params.getParamsCalcIcms().getAliquotaFCP();
        }
        return aliquotaFCP != null ? aliquotaFCP : 0.0;
    }

    protected void calcPartilhaIcms(IcmsParams params, IcmsCalculado calc) throws ExceptionImpostoIcms {
        if (!this.isCalcularPartilhaIcms(params)) {
            return;
        }
        Double baseCalculo = calc.getValorIcmsTributado();
        Double vrIcms = calc.getValorIcms();
        if (vrIcms != null && vrIcms > 0.0) {
            Double aliqInternaDest = TRulesIcms.getAliquotaInternaUFDestinatario(params);
            Double aliqInterestadual = calc.getAliquotaIcms();
            Double diferenca = Math.abs(aliqInternaDest - aliqInterestadual);
            if (diferenca >= 0.0) {
                Double valorIcmsACalcular = baseCalculo * diferenca / 100.0;
                calc.setBaseCalculoIcmsUFDest(baseCalculo);
                calc.setAliquotaInternaUFDest(aliqInternaDest);
                calc.setAliquotaInterestadualIcms(aliqInterestadual);
                calc.setPercPartilhaIcms(TRulesIcms.getPercentualPartilhaIcms(params));
                Double vrIcmsUFDest = this.arrredondarNumero(valorIcmsACalcular * calc.getPercPartilhaIcms() / 100.0, 2, params.getTipoArredondamento());
                calc.setValorIcmsUFDest(vrIcmsUFDest);
                calc.setValorIcmsUFRem(valorIcmsACalcular - vrIcmsUFDest);
            }
        }
    }

    protected void calcPartilhaIcmsSimples(IcmsParams params, IcmsCalculado calc) {
        if (!this.isCalcularPartilhaIcms(params)) {
            return;
        }
        Double aliqInterestadual = params.getParamsCalcIcms().getAliquotaIcmsOrigemDestino();
        calc.setBaseCalculoIcmsUFDest(0.0);
        calc.setAliquotaInternaUFDest(0.0);
        calc.setAliquotaInterestadualIcms(aliqInterestadual);
        calc.setPercPartilhaIcms(TRulesIcms.getPercentualPartilhaIcms(params));
        calc.setValorIcmsUFDest(0.0);
        calc.setValorIcmsUFRem(0.0);
    }

    protected boolean isCalcularPartilhaIcms(IcmsParams params) {
        return this.isEquals(EnumConstModFiscalDifal.TIPO_DIFAL_NAO_CALCULAR.getValue(), params.getParamsCalcIcms().getTipoDifal()) != false && this.isAffirmative(params.getConsumidorFinal()) != false && this.isEquals(params.getUfOrigem(), params.getUfDestino()) == false && this.isEquals(params.getTipoCfop(), EnumConstCfop.CFOP_EXPORTACAO) == false && this.isEquals(params.getContribuinteEstado(), EnumConstContrEstadoIcms.NAO_CONTRIBUINTE) != false;
    }

    protected void calcularDiferencaAliquotaEntrada(IcmsParams params, IcmsCalculado calc) {
        double valorDif = 0.0;
        double aliquotaIcms = params.getParamsCalcIcms().getAliquotaIcmsProduto();
        if (this.isAffirmative(params.getCalculaDifAliquotaEntrada()).booleanValue() && aliquotaIcms > 0.0) {
            Double bcDifAliq = this.getBC(params);
            if (!this.isEquals(params.getUfDestino(), params.getUfOrigem()).booleanValue() && this.isEquals(params.getTipoCfop(), EnumConstCfop.CFOP_INTERNO).booleanValue()) {
                Double aliqModeloOrEstado = 0.0;
                aliqModeloOrEstado = this.isEquals(params.getParamsCalcIcms().getTipoAliquotaIcms(), EnumConstTipoAliquotaIcms.ALIQ_ICMS_INFORMADA) != false ? params.getParamsCalcIcms().getAliquotaIcmsInformada() : params.getParamsCalcIcms().getAliquotaIcmsOrigemDestino();
                if (aliqModeloOrEstado != null && aliqModeloOrEstado > 0.0) {
                    valorDif = this.calcularDiferencaAliquota(aliqModeloOrEstado, aliquotaIcms, bcDifAliq, params.getParamsCalcIcms().getTipoCalcDifAliquota());
                }
            }
        }
        if (valorDif < 0.0) {
            valorDif = 0.0;
        }
        calc.setValorDifAliquota(valorDif);
    }

    private double calcularDiferencaAliquota(Double aliqModeloOrEstado, double aliquotaIcms, Double valorTotalItem, EnumConstTipoCalculoDiferencaAliquota mod) {
        double valorDif = 0.0;
        if (!this.isNull(mod).booleanValue() && this.isEquals(mod, EnumConstTipoCalculoDiferencaAliquota.TIPO_MODO_2_DIF_ALIQUOTA).booleanValue()) {
            double valorCompraSemIcms = valorTotalItem * (1.0 - aliqModeloOrEstado / 100.0);
            double novaBCIcms = valorCompraSemIcms / (1.0 - aliquotaIcms / 100.0);
            double novoVlrIcms = novaBCIcms * aliquotaIcms / 100.0;
            return novoVlrIcms - (valorTotalItem - valorCompraSemIcms);
        }
        valorDif = valorTotalItem * (aliquotaIcms / 100.0) - valorTotalItem * (aliqModeloOrEstado / 100.0);
        return valorDif;
    }

    protected Boolean isEquals(Object ob1, Object ob2) {
        return ToolMethods.isEquals((Object)ob1, (Object)ob2);
    }

    protected Boolean isNull(Object ob1) {
        return ToolMethods.isNull((Object)ob1);
    }

    protected Boolean isAffirmative(EnumConstantsMentorSimNao value) {
        if (value == null) {
            return false;
        }
        return ToolMethods.isAffirmative((Number)value.getValue());
    }
}

