/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.BaseIcmsST;
import com.touchcomp.basementorrules.impostos.icms.impl.InterfaceIcmsCalculo;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;
import java.util.Arrays;
import java.util.List;

public class Icms10
extends BaseIcmsST
implements InterfaceIcmsCalculo {
    @Override
    public IcmsCalculado calcular(IcmsParams params) throws ExceptionImpostoIcms {
        IcmsCalculado calc = new IcmsCalculado(params);
        double baseCalculo = this.getBC(params);
        double aliquotaIcms = params.getParamsCalcIcms().getAliquotaIcmsInformada();
        double valorIcms = this.calcIcms(baseCalculo, aliquotaIcms, params.getTipoArredondamento());
        calc.setBaseCalculoIcms(baseCalculo);
        calc.setValorIcmsTributado(calc.getBaseCalculoIcms());
        calc.setValorIcms(valorIcms);
        calc.setAliquotaIcms(aliquotaIcms);
        if (params.getEntradaSaida() == EnumConstantsMentorEntSaida.ENTRADA) {
            if (!this.isRecuperaTributos(params)) {
                calc.setValorIcmsOutros(calc.getBaseCalculoIcms());
                calc.setValorIcmsSemAprov(valorIcms);
                calc.setValorIcmsTributado(0.0);
                calc.setValorIcms(0.0);
            }
            this.calcularDiferencaAliquotaEntrada(params, calc);
        } else {
            this.calcularFCP(params, calc);
            this.calcularSt(params, calc);
            this.calcularFCPSt(params, calc);
            this.calcPartilhaIcms(params, calc);
        }
        return calc;
    }

    @Override
    public List<EnumConstNFeIncidenciaIcms> getIncidencia() {
        return Arrays.asList(EnumConstNFeIncidenciaIcms.TRIBUTADA_COM_COBRANCA_ICMS_POR_SUBSTITUICAO_TRIBUTARIA);
    }

    @Override
    public boolean validCalcEntrada() {
        return true;
    }

    @Override
    public boolean validCalcSaida() {
        return true;
    }
}

