/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms.impl;

import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.BaseIcmsST;
import com.touchcomp.basementorrules.impostos.icms.impl.InterfaceIcmsCalculo;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;
import java.util.Arrays;
import java.util.List;

public class Icms50
extends BaseIcmsST
implements InterfaceIcmsCalculo {
    @Override
    public IcmsCalculado calcular(IcmsParams params) throws ExceptionImpostoIcms {
        IcmsCalculado calc = new IcmsCalculado(params);
        double baseCalculo = this.getBC(params);
        double bcAcess = this.getBCDespAcessorias(params);
        this.calcularValoresDesoneracao(params, calc, baseCalculo, bcAcess, params.getParamsCalcIcms().getAliquotaIcmsInformada(), params.getParamsCalcIcms().getPercRedBCIcms());
        calc.setBaseCalculoIcms(baseCalculo);
        calc.setValorIcmsOutros(calc.getBaseCalculoIcms() - calc.getValorIcmsDispensado());
        calc.setAliquotaIcms(params.getParamsCalcIcms().getAliquotaIcmsInformada());
        if (params.getIncidenciaIcms().equals((Object)EnumConstNFeIncidenciaIcms.ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA) && params.getParamsCalcST() != null) {
            calc.setVrBCICMSSTRetido(params.getParamsCalcST().getVrUnidadeBCICMSSTRetido() * params.getQuantidadeTotal());
            calc.setVrICMSSTRetido(params.getParamsCalcST().getVrUnidadeICMSSTRetido() * params.getQuantidadeTotal());
        }
        return calc;
    }

    @Override
    public List<EnumConstNFeIncidenciaIcms> getIncidencia() {
        return Arrays.asList(EnumConstNFeIncidenciaIcms.SUSPENSAO);
    }

    @Override
    public boolean validCalcEntrada() {
        return true;
    }

    @Override
    public boolean validCalcSaida() {
        return true;
    }
}

