/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.ipi.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.fornecedor.EnumConstTipoFornecedor;
import com.touchcomp.basementor.constants.enums.impostos.ipi.EnumConstNFeIncidenciaIpi;
import com.touchcomp.basementorrules.impostos.ipi.impl.InterfaceIPICalculo;
import com.touchcomp.basementorrules.impostos.ipi.model.IPICalculado;
import com.touchcomp.basementorrules.impostos.ipi.model.IPIParams;
import java.util.Arrays;
import java.util.List;

public class IPI00
implements InterfaceIPICalculo {
    @Override
    public IPICalculado calcular(IPIParams params) {
        EnumConstantsMentorSimNao ipiTribQtde = params.getTribQuantidade();
        ipiTribQtde = ipiTribQtde == null ? EnumConstantsMentorSimNao.NAO : ipiTribQtde;
        double baseCalculo = params.getBaseCalculo();
        double aliquotaIpi = params.getAliquotaIPI();
        double quantidade = params.getQuantidadeItens();
        IPICalculado calc = new IPICalculado(params);
        if (params.getEntradaSaida() == EnumConstantsMentorEntSaida.SAIDA) {
            if (ipiTribQtde == EnumConstantsMentorSimNao.NAO) {
                calc.setValorIpiTributado(baseCalculo);
                calc.setValorIpiIndustria(baseCalculo * (aliquotaIpi / 100.0));
                calc.setAliquotaIpi(aliquotaIpi);
            } else {
                calc.setValorIpiTributado(baseCalculo);
                calc.setValorIpiIndustria(aliquotaIpi * quantidade);
            }
        } else if (params.getRecuperarTributos() == EnumConstantsMentorSimNao.SIM && params.getTipoFornecedor() == EnumConstTipoFornecedor.INDUSTRIA) {
            calc.setValorIpiTributado(params.getBaseCalculo());
            if (ipiTribQtde == EnumConstantsMentorSimNao.NAO) {
                calc.setValorIpiIndustria(baseCalculo * (aliquotaIpi / 100.0));
            } else {
                calc.setValorIpiIndustria(aliquotaIpi * quantidade);
            }
        } else if (params.getRecuperarTributos() == EnumConstantsMentorSimNao.SIM && params.getTipoFornecedor() == EnumConstTipoFornecedor.COMERCIO) {
            calc.setValorIpiTributado(params.getBaseCalculo());
            if (ipiTribQtde == EnumConstantsMentorSimNao.NAO) {
                calc.setValorIpiComercio(baseCalculo * (aliquotaIpi / 100.0) * 0.5);
            } else {
                calc.setValorIpiComercio(aliquotaIpi * quantidade);
            }
        } else if (params.getRecuperarTributos() != EnumConstantsMentorSimNao.SIM && params.getTipoFornecedor() == EnumConstTipoFornecedor.INDUSTRIA) {
            calc.setValorIpiOutros(params.getBaseCalculo());
            if (ipiTribQtde == EnumConstantsMentorSimNao.NAO) {
                calc.setValorIpiObservacao(baseCalculo * (aliquotaIpi / 100.0));
            } else {
                calc.setValorIpiObservacao(aliquotaIpi * quantidade);
            }
        } else if (params.getRecuperarTributos() != EnumConstantsMentorSimNao.SIM && params.getTipoFornecedor() == EnumConstTipoFornecedor.COMERCIO) {
            calc.setValorIpiOutros(params.getBaseCalculo());
        }
        return calc;
    }

    @Override
    public List<EnumConstNFeIncidenciaIpi> getIncidencia() {
        return Arrays.asList(EnumConstNFeIncidenciaIpi.ENTRADA_COM_RECUPERACAO_CREDITO_00);
    }

    @Override
    public boolean validCalcEntrada() {
        return true;
    }

    @Override
    public boolean validCalcSaida() {
        return false;
    }
}

