/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.ipi.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.impostos.ipi.EnumConstNFeIncidenciaIpi;
import com.touchcomp.basementorrules.impostos.ipi.impl.InterfaceIPICalculo;
import com.touchcomp.basementorrules.impostos.ipi.model.IPICalculado;
import com.touchcomp.basementorrules.impostos.ipi.model.IPIParams;
import java.util.Arrays;
import java.util.List;

public class IPI01030405
implements InterfaceIPICalculo {
    @Override
    public IPICalculado calcular(IPIParams params) {
        EnumConstantsMentorSimNao ipiTribQtde = params.getTribQuantidade();
        ipiTribQtde = ipiTribQtde == null ? EnumConstantsMentorSimNao.NAO : ipiTribQtde;
        double baseCalculo = params.getBaseCalculo();
        double quantidade = params.getQuantidadeItens();
        IPICalculado calc = new IPICalculado(params);
        if (params.getEntradaSaida() == EnumConstantsMentorEntSaida.SAIDA) {
            if (ipiTribQtde == EnumConstantsMentorSimNao.NAO) {
                calc.setValorIpiOutros(baseCalculo);
            } else {
                calc.setValorIpiOutros(quantidade * baseCalculo);
            }
        } else {
            calc.setValorIpiOutros(baseCalculo);
        }
        return calc;
    }

    @Override
    public List<EnumConstNFeIncidenciaIpi> getIncidencia() {
        return Arrays.asList(EnumConstNFeIncidenciaIpi.ENTRADA_TRIBUTADA_ALIQUOTA_ZERO_01, EnumConstNFeIncidenciaIpi.ENTRADA_NAO_TRIBUTADA_03, EnumConstNFeIncidenciaIpi.ENTRADA_IMUNE_04, EnumConstNFeIncidenciaIpi.ENTRADAS_COM_SUSPENSAO_05);
    }

    @Override
    public boolean validCalcEntrada() {
        return true;
    }

    @Override
    public boolean validCalcSaida() {
        return false;
    }
}

