/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.ipi.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.impostos.ipi.EnumConstNFeIncidenciaIpi;
import com.touchcomp.basementorrules.impostos.ipi.impl.InterfaceIPICalculo;
import com.touchcomp.basementorrules.impostos.ipi.model.IPICalculado;
import com.touchcomp.basementorrules.impostos.ipi.model.IPIParams;
import java.util.Arrays;
import java.util.List;

public class IPI99
implements InterfaceIPICalculo {
    @Override
    public IPICalculado calcular(IPIParams params) {
        EnumConstantsMentorSimNao ipiTribQtde = params.getTribQuantidade();
        ipiTribQtde = ipiTribQtde == null ? EnumConstantsMentorSimNao.NAO : ipiTribQtde;
        double baseCalculo = params.getBaseCalculo();
        double aliquotaIpi = params.getAliquotaIPI();
        double quantidade = params.getQuantidadeItens();
        IPICalculado calc = new IPICalculado(params);
        if (ipiTribQtde == EnumConstantsMentorSimNao.NAO) {
            calc.setValorIpiOutros(baseCalculo);
            calc.setAliquotaIpi(0.0);
        } else {
            calc.setValorIpiOutros(aliquotaIpi * quantidade);
            calc.setAliquotaIpi(0.0);
        }
        return calc;
    }

    @Override
    public List<EnumConstNFeIncidenciaIpi> getIncidencia() {
        return Arrays.asList(EnumConstNFeIncidenciaIpi.OUTRAS_SAIDAS_99);
    }

    @Override
    public boolean validCalcEntrada() {
        return false;
    }

    @Override
    public boolean validCalcSaida() {
        return true;
    }
}

