/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.is;

import com.touchcomp.basementorrules.constants.EnumConstSimNaoImp;
import com.touchcomp.basementorrules.constants.EnumConstTipoCalcImp;
import com.touchcomp.basementorrules.impostos.BaseValoresCalculados;
import com.touchcomp.basementorrules.impostos.is.model.ISCalculado;
import com.touchcomp.basementorrules.impostos.is.model.ISParams;
import java.util.Objects;

public class CompImpostoISeletivo
extends BaseValoresCalculados {
    public static CompImpostoISeletivo get() {
        return new CompImpostoISeletivo();
    }

    public ISCalculado calcular(ISParams.ParamsBuilder parameters) {
        double vlrProdServ;
        double valorDesconto = this.zeroIsNull(parameters.valorDesconto());
        double valorFrete = this.zeroIsNull(parameters.valorFrete());
        double valorDespAcess = this.zeroIsNull(parameters.valorDespAcess());
        double valorSeguro = this.zeroIsNull(parameters.valorSeguro());
        double bc = vlrProdServ = this.zeroIsNull(parameters.vrProdServ()).doubleValue();
        if (Objects.equals((Object)parameters.incluirFreteBC(), (Object)EnumConstSimNaoImp.SIM)) {
            bc += valorFrete;
        }
        if (Objects.equals((Object)parameters.incluirSeguroBC(), (Object)EnumConstSimNaoImp.SIM)) {
            bc += valorSeguro;
        }
        if (Objects.equals((Object)parameters.incluirValorDescontoBC(), (Object)EnumConstSimNaoImp.SIM)) {
            bc -= valorDesconto;
        }
        if (Objects.equals((Object)parameters.incluirValorDespAcessBC(), (Object)EnumConstSimNaoImp.SIM)) {
            bc += valorDespAcess;
        }
        ISCalculado calc = new ISCalculado(parameters.params());
        double aliqIS = this.zeroIsNull(parameters.aliquotaIS());
        if (parameters.tipoCalculo() == EnumConstTipoCalcImp.CALCULAR_NORMAL) {
            double aliqEfetivaIS = aliqIS;
            double percRedBC = this.zeroIsNull(parameters.percRedBC());
            double percRedAliquotaIS = this.zeroIsNull(parameters.percRedAliquotaIS());
            if (percRedAliquotaIS > 0.0) {
                aliqEfetivaIS *= 1.0 - percRedAliquotaIS / 100.0;
            }
            if (percRedBC > 0.0) {
                bc *= 1.0 - percRedBC / 100.0;
            }
            double valorIS = bc * (aliqEfetivaIS / 100.0);
            calc.setAliquotaIS(aliqIS);
            calc.setAliquotaISEfetiva(aliqEfetivaIS);
            calc.setBaseCalculo(bc);
            calc.setValorIS(valorIS);
        } else if (parameters.tipoCalculo() == EnumConstTipoCalcImp.HABILITAR) {
            calc.setAliquotaIS(aliqIS);
            calc.setAliquotaISEfetiva(aliqIS);
        }
        return calc;
    }
}

